/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.message;

import java.util.List;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;

public class ApplicationActivityMessage
extends AuditMessage {
    public static final AuditEvent.TypeCode APPLICATION_START = AuditEvent.TypeCode.APPLICATION_START;
    public static final AuditEvent.TypeCode APPLICATION_STOP = AuditEvent.TypeCode.APPLICATION_STOP;

    public ApplicationActivityMessage(AuditEvent.TypeCode typeCode) {
        super(new AuditEvent(AuditEvent.ID.APPLICATION_ACTIVITY, AuditEvent.ActionCode.EXECUTE).addEventTypeCode(ApplicationActivityMessage.check(typeCode)));
    }

    private static AuditEvent.TypeCode check(AuditEvent.TypeCode typeCode) {
        if (typeCode == null) {
            throw new NullPointerException("typeCode");
        }
        return typeCode;
    }

    public ActiveParticipant addApplication(String processID, String[] aets, String processName, String nodeID) {
        return this.addActiveParticipant(ActiveParticipant.createActiveProcess(processID, aets, processName, nodeID, false).addRoleIDCode(ActiveParticipant.RoleIDCode.APPLICATION));
    }

    public ActiveParticipant addApplicationLauncher(String userID, String altUserID, String userName, String napID) {
        return this.addActiveParticipant(ActiveParticipant.createActivePerson(userID, altUserID, userName, napID, true).addRoleIDCode(ActiveParticipant.RoleIDCode.APPLICATION_LAUNCHER));
    }

    public void validate() {
        super.validate();
        ActiveParticipant app = null;
        for (ActiveParticipant ap : this.activeParticipants) {
            List<ActiveParticipant.RoleIDCode> roleIDCodeIDs = ap.getRoleIDCodes();
            if (!roleIDCodeIDs.contains(ActiveParticipant.RoleIDCode.APPLICATION)) continue;
            if (ap.isUserIsRequestor()) {
                throw new IllegalStateException("Application is Requesting User");
            }
            if (app != null) {
                throw new IllegalStateException("Multiple Application identification");
            }
            app = ap;
        }
        if (app == null) {
            throw new IllegalStateException("No Application Identification");
        }
    }
}

