/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.audit.log4j.helpers;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SyslogWriter
extends Writer {
    private static final int SYSLOG_PORT = 514;
    private InetAddress address;
    private final int port;
    private DatagramSocket ds;
    private String encoding;
    private Logger logger = LogManager.getLogger(SyslogWriter.class);
    private StringBuffer buf = new StringBuffer();

    public SyslogWriter(String syslogHost, String encoding) {
        if (syslogHost == null) {
            throw new NullPointerException("syslogHost");
        }
        String host = syslogHost;
        int urlPort = -1;
        if (host.indexOf("[") != -1 || host.indexOf(58) == host.lastIndexOf(58)) {
            try {
                URL url = new URL("http://" + host);
                if (url.getHost() != null) {
                    host = url.getHost();
                    if (host.startsWith("[") && host.charAt(host.length() - 1) == ']') {
                        host = host.substring(1, host.length() - 1);
                    }
                    urlPort = url.getPort();
                }
            }
            catch (MalformedURLException e) {
                this.logger.warn((Object)"Malformed URL: will attempt to interpret as InetAddress.", (Throwable)e);
            }
        }
        if (urlPort == -1) {
            urlPort = 514;
        }
        this.port = urlPort;
        try {
            this.address = InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            this.logger.error((Object)("Could not find " + host + ". All logging will FAIL."), (Throwable)e);
        }
        try {
            this.ds = new DatagramSocket();
        }
        catch (SocketException e) {
            e.printStackTrace();
            this.logger.error((Object)("Could not instantiate DatagramSocket to " + host + ". All logging will FAIL."), (Throwable)e);
        }
        if (encoding != null) {
            try {
                encoding.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error((Object)("Unsupported encoding " + encoding + ". Use default encoding."));
                encoding = null;
            }
        }
        this.encoding = encoding;
    }

    public void write(char c) {
        this.buf.append(c);
    }

    public void write(char[] charArray, int offset, int len) {
        this.buf.append(charArray, offset, len);
    }

    public void write(String str) {
        this.buf.append(str);
    }

    public void flush() throws IOException {
        if (this.buf.length() == 0) {
            return;
        }
        byte[] payload = this.encoding == null ? this.buf.toString().getBytes() : this.buf.toString().getBytes(this.encoding);
        DatagramPacket packet = new DatagramPacket(payload, payload.length, this.address, this.port);
        this.ds.send(packet);
        this.buf.setLength(0);
    }

    public void reset() {
        this.buf.setLength(0);
    }

    public void close() {
        try {
            this.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ds.close();
    }
}

