/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.notification;

import javax.management.Notification;
import javax.management.NotificationListener;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JBossNotificationBroadcasterSupport;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.ThreadPool;

public class AsynchNotificationBroadcasterSupport
extends JBossNotificationBroadcasterSupport {
    private static Logger log = Logger.getLogger(AsynchNotifier.class);
    private static ThreadPool defaultPool = new BasicThreadPool("AsynchNotificationBroadcasterSupport");
    private static long defaultNotificationTimeout;
    private long notificationTimeout;
    private ThreadPool pool;

    public static synchronized void setDefaultThreadPool(ThreadPool tp) {
        defaultPool = tp;
    }

    public static long getDefaultNotificationTimeout() {
        return defaultNotificationTimeout;
    }

    public static void setDefaultNotificationTimeout(long defaultNotificationTimeout) {
        AsynchNotificationBroadcasterSupport.defaultNotificationTimeout = defaultNotificationTimeout;
    }

    public AsynchNotificationBroadcasterSupport() {
        this(defaultNotificationTimeout, defaultPool);
    }

    public AsynchNotificationBroadcasterSupport(long notificationTimeout) {
        this(notificationTimeout, defaultPool);
    }

    public AsynchNotificationBroadcasterSupport(long notificationTimeout, ThreadPool pool) {
        this.notificationTimeout = notificationTimeout;
        this.pool = pool;
    }

    public long getNotificationTimeout() {
        return this.notificationTimeout;
    }

    public void setNotificationTimeout(long notificationTimeout) {
        this.notificationTimeout = notificationTimeout;
    }

    public ThreadPool getThreadPool() {
        return this.pool;
    }

    public void setThreadPool(ThreadPool pool) {
        this.pool = pool;
    }

    public void handleNotification(NotificationListener listener, Notification notification, Object handback) {
        AsynchNotifier notifier = new AsynchNotifier(listener, notification, handback);
        this.pool.run((Runnable)notifier, 0L, this.notificationTimeout);
    }

    protected void stopThreadPool(boolean immeadiate) {
        if (this.pool != defaultPool) {
            this.pool.stop(immeadiate);
        }
    }

    public class AsynchNotifier
    implements Runnable {
        NotificationListener listener;
        Notification notification;
        Object handback;

        public AsynchNotifier(NotificationListener listener, Notification notification, Object handback) {
            this.listener = listener;
            this.notification = notification;
            this.handback = handback;
        }

        public void run() {
            try {
                this.listener.handleNotification(this.notification, this.handback);
            }
            catch (Throwable throwable) {
                log.error((Object)("Error processing notification=" + this.notification + " listener=" + this.listener + " handback=" + this.handback), throwable);
            }
        }
    }
}

