/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.endpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import org.jboss.aop.AspectManager;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.delegate.ConnectionEndpoint;
import org.jboss.jms.delegate.IDBlock;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.server.ConnectionManager;
import org.jboss.jms.server.DestinationManager;
import org.jboss.jms.server.JMSCondition;
import org.jboss.jms.server.SecurityStore;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.destination.ManagedDestination;
import org.jboss.jms.server.endpoint.ServerConnectionFactoryEndpoint;
import org.jboss.jms.server.endpoint.ServerSessionEndpoint;
import org.jboss.jms.server.endpoint.advised.SessionAdvised;
import org.jboss.jms.tx.ClientTransaction;
import org.jboss.jms.tx.MessagingXid;
import org.jboss.jms.tx.TransactionRequest;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.JMSWireFormat;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.contract.Binding;
import org.jboss.messaging.core.contract.Delivery;
import org.jboss.messaging.core.contract.MessageReference;
import org.jboss.messaging.core.contract.MessageStore;
import org.jboss.messaging.core.contract.PostOffice;
import org.jboss.messaging.core.contract.Queue;
import org.jboss.messaging.core.impl.tx.Transaction;
import org.jboss.messaging.core.impl.tx.TransactionRepository;
import org.jboss.messaging.util.ExceptionUtil;
import org.jboss.messaging.util.GUIDGenerator;
import org.jboss.messaging.util.Util;
import org.jboss.remoting.Client;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
import org.jboss.remoting.marshal.Marshaller;
import org.jboss.remoting.marshal.UnMarshaller;

public class ServerConnectionEndpoint
implements ConnectionEndpoint {
    private static final Logger log = Logger.getLogger(ServerConnectionEndpoint.class);
    private static boolean trace = log.isTraceEnabled();
    private String id;
    private volatile boolean closed;
    private volatile boolean started;
    private String clientID;
    private String username;
    private String password;
    private String remotingClientSessionID;
    private String jmsClientVMID;
    private ServerPeer serverPeer;
    private PostOffice postOffice;
    private SecurityStore sm;
    private ConnectionManager cm;
    private TransactionRepository tr;
    private MessageStore ms;
    private ServerInvokerCallbackHandler callbackHandler;
    private Map sessions;
    private Set temporaryDestinations;
    private int prefetchSize;
    private int defaultTempQueueFullSize;
    private int defaultTempQueuePageSize;
    private int defaultTempQueueDownCacheSize;
    private int dupsOKBatchSize;
    private ServerConnectionFactoryEndpoint cfendpoint;
    private byte usingVersion;
    private Integer failedNodeID;

    public ServerConnectionEndpoint(ServerPeer serverPeer, String clientID, String username, String password, int prefetchSize, int defaultTempQueueFullSize, int defaultTempQueuePageSize, int defaultTempQueueDownCacheSize, int failedNodeID, ServerConnectionFactoryEndpoint cfendpoint, String remotingSessionID, String clientVMID, byte versionToUse, ServerInvokerCallbackHandler callbackHandler, int dupsOKBatchSize) throws Exception {
        this.serverPeer = serverPeer;
        this.cfendpoint = cfendpoint;
        this.sm = serverPeer.getSecurityManager();
        this.tr = serverPeer.getTxRepository();
        this.cm = serverPeer.getConnectionManager();
        this.ms = serverPeer.getMessageStore();
        this.postOffice = serverPeer.getPostOfficeInstance();
        this.started = false;
        this.id = GUIDGenerator.generateGUID();
        this.clientID = clientID;
        this.prefetchSize = prefetchSize;
        this.defaultTempQueueFullSize = defaultTempQueueFullSize;
        this.defaultTempQueuePageSize = defaultTempQueuePageSize;
        this.defaultTempQueueDownCacheSize = defaultTempQueueDownCacheSize;
        this.dupsOKBatchSize = dupsOKBatchSize;
        this.sessions = new HashMap();
        this.temporaryDestinations = new HashSet();
        this.username = username;
        this.password = password;
        if (failedNodeID >= 0) {
            this.failedNodeID = new Integer(failedNodeID);
        }
        this.remotingClientSessionID = remotingSessionID;
        this.jmsClientVMID = clientVMID;
        this.usingVersion = versionToUse;
        this.serverPeer.getConnectionManager().registerConnection(this.jmsClientVMID, this.remotingClientSessionID, this);
        this.callbackHandler = callbackHandler;
        Client callbackClient = callbackHandler.getCallbackClient();
        if (callbackClient != null) {
            callbackClient.setSubsystem("CALLBACK");
            callbackClient.setMarshaller((Marshaller)new JMSWireFormat());
            callbackClient.setUnMarshaller((UnMarshaller)new JMSWireFormat());
        } else {
            log.trace((Object)"ServerInvokerCallbackHandler callback Client is not available: must be using pull callbacks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionDelegate createSessionDelegate(boolean transacted, int acknowledgmentMode, boolean isXA) throws JMSException {
        try {
            SessionAdvised advised;
            log.trace((Object)(this + " creating " + (transacted ? "transacted" : "non transacted") + " session, " + Util.acknowledgmentMode(acknowledgmentMode) + ", " + (isXA ? "XA" : "non XA")));
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            String sessionID = GUIDGenerator.generateGUID();
            ServerSessionEndpoint ep = new ServerSessionEndpoint(sessionID, this, transacted || acknowledgmentMode == 2);
            Map map = this.sessions;
            synchronized (map) {
                this.sessions.put(sessionID, ep);
            }
            AspectManager aspectManager = AspectManager.instance();
            synchronized (aspectManager) {
                advised = new SessionAdvised(ep);
            }
            SessionAdvised sessionAdvised = advised;
            this.serverPeer.addSession(sessionID, ep);
            Dispatcher.instance.registerTarget(sessionID, sessionAdvised);
            log.trace((Object)("created and registered " + ep));
            ClientSessionDelegate d = new ClientSessionDelegate(sessionID, this.dupsOKBatchSize);
            log.trace((Object)("created " + d));
            return d;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " createSessionDelegate");
        }
    }

    public String getClientID() throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            return this.clientID;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " getClientID");
        }
    }

    public void setClientID(String clientID) throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            if (this.clientID != null && this.failedNodeID == null) {
                throw new IllegalStateException("Cannot set clientID, already set as " + this.clientID);
            }
            log.trace((Object)(this + "setting client ID to " + clientID));
            this.clientID = clientID;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " setClientID");
        }
    }

    public void start() throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            this.setStarted(true);
            log.trace((Object)(this + " started"));
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " start");
        }
    }

    public synchronized void stop() throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            this.setStarted(false);
            log.trace((Object)("Connection " + this.id + " stopped"));
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " stop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            HashMap sessionsClone;
            if (trace) {
                log.trace((Object)(this + " close()"));
            }
            if (this.closed) {
                log.warn((Object)"Connection is already closed");
                return;
            }
            Object object = this.sessions;
            synchronized (object) {
                sessionsClone = new HashMap(this.sessions);
            }
            for (ServerSessionEndpoint sess : sessionsClone.values()) {
                sess.localClose();
            }
            this.sessions.clear();
            object = this.temporaryDestinations;
            synchronized (object) {
                for (JBossDestination dest : this.temporaryDestinations) {
                    if (dest.isQueue()) {
                        this.postOffice.removeBinding(dest.getName(), this.postOffice.isClustered());
                    } else {
                        Collection queues = this.serverPeer.getPostOfficeInstance().getQueuesForCondition(new JMSCondition(false, dest.getName()), true);
                        if (!queues.isEmpty()) {
                            throw new IllegalStateException("Cannot delete temporary destination if it has consumer(s)");
                        }
                    }
                    DestinationManager dm = this.serverPeer.getDestinationManager();
                    ManagedDestination mDest = dm.getDestination(dest.getName(), dest.isQueue());
                    if (dm == null) {
                        throw new InvalidDestinationException("No such destination: " + dest);
                    }
                    dm.unregisterDestination(mDest);
                }
                this.temporaryDestinations.clear();
            }
            this.cm.unregisterConnection(this.jmsClientVMID, this.remotingClientSessionID);
            Dispatcher.instance.unregisterTarget(this.id, this);
            this.closed = true;
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " close");
        }
    }

    public long closing(long sequence) throws JMSException {
        log.trace((Object)(this + " closing (noop)"));
        return -1L;
    }

    public void closeCallbackClient() {
        block2: {
            try {
                this.callbackHandler.getCallbackClient().disconnect();
            }
            catch (Throwable t) {
                if (!trace) break block2;
                log.trace((Object)"Failed to diconnect callback client", t);
            }
        }
    }

    public void sendTransaction(TransactionRequest request, boolean checkForDuplicates) throws JMSException {
        try {
            if (this.closed) {
                throw new IllegalStateException("Connection is closed");
            }
            if (request.getRequestType() == 0) {
                if (trace) {
                    log.trace((Object)(this + " received ONE_PHASE_COMMIT request"));
                }
                Transaction tx = this.tr.createTransaction();
                this.processTransaction(request.getState(), tx, checkForDuplicates);
                tx.commit();
            } else if (request.getRequestType() == 2) {
                if (trace) {
                    log.trace((Object)(this + " received TWO_PHASE_COMMIT prepare request"));
                }
                Transaction tx = this.tr.createTransaction(request.getXid());
                this.processTransaction(request.getState(), tx, checkForDuplicates);
                tx.prepare();
            } else if (request.getRequestType() == 3) {
                if (trace) {
                    log.trace((Object)(this + " received TWO_PHASE_COMMIT commit request"));
                }
                Transaction tx = this.tr.getPreparedTx(request.getXid());
                if (trace) {
                    log.trace((Object)("Committing " + tx));
                }
                tx.commit();
            } else if (request.getRequestType() == 4) {
                if (trace) {
                    log.trace((Object)(this + " received TWO_PHASE_COMMIT rollback request"));
                }
                Transaction tx = this.tr.getPreparedTx(request.getXid());
                if (trace) {
                    log.trace((Object)(this + " rolling back " + tx));
                }
                tx.rollback();
            }
            if (trace) {
                log.trace((Object)(this + " processed transaction successfully"));
            }
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " sendTransaction");
        }
    }

    public MessagingXid[] getPreparedTransactions() throws JMSException {
        try {
            List xids = this.tr.recoverPreparedTransactions();
            return xids.toArray(new MessagingXid[xids.size()]);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " getPreparedTransactions");
        }
    }

    public IDBlock getIdBlock(int size) throws JMSException {
        try {
            return this.serverPeer.getMessageIDManager().getIDBlock(size);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " getIdBlock");
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public SecurityStore getSecurityManager() {
        return this.sm;
    }

    public ServerInvokerCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public ServerPeer getServerPeer() {
        return this.serverPeer;
    }

    public ServerConnectionFactoryEndpoint getConnectionFactoryEndpoint() {
        return this.cfendpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSessions() {
        ArrayList list = new ArrayList();
        Map map = this.sessions;
        synchronized (map) {
            list.addAll(this.sessions.values());
        }
        return list;
    }

    public String toString() {
        return "ConnectionEndpoint[" + this.id + "]";
    }

    byte getUsingVersion() {
        return this.usingVersion;
    }

    int getPrefetchSize() {
        return this.prefetchSize;
    }

    int getDefaultTempQueueFullSize() {
        return this.defaultTempQueueFullSize;
    }

    int getDefaultTempQueuePageSize() {
        return this.defaultTempQueuePageSize;
    }

    int getDefaultTempQueueDownCacheSize() {
        return this.defaultTempQueueDownCacheSize;
    }

    String getConnectionID() {
        return this.id;
    }

    boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSession(String sessionId) throws Exception {
        Map map = this.sessions;
        synchronized (map) {
            if (this.sessions.remove(sessionId) == null) {
                throw new IllegalStateException("Cannot find session with id " + sessionId + " to remove");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTemporaryDestination(Destination dest) {
        Set set = this.temporaryDestinations;
        synchronized (set) {
            this.temporaryDestinations.add(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTemporaryDestination(Destination dest) {
        Set set = this.temporaryDestinations;
        synchronized (set) {
            this.temporaryDestinations.remove(dest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasTemporaryDestination(Destination dest) {
        Set set = this.temporaryDestinations;
        synchronized (set) {
            return this.temporaryDestinations.contains(dest);
        }
    }

    String getRemotingClientSessionID() {
        return this.remotingClientSessionID;
    }

    boolean sendMessage(JBossMessage msg, Transaction tx, boolean checkForDuplicates) throws Exception {
        JBossDestination dest = (JBossDestination)msg.getJMSDestination();
        if (!dest.isDirect()) {
            long msgID = this.serverPeer.getMessageIDMgr().getID();
            msg.setMessageId(msgID);
        }
        if (trace) {
            log.trace((Object)(this + " sending message " + msg + (tx == null ? " non-transactionally" : " in " + tx)));
        }
        msg.setConnectionID(this.id);
        MessageReference ref = msg.createReference();
        if (checkForDuplicates && this.serverPeer.getPersistenceManagerInstance().idExists(msg.getJMSMessageID())) {
            log.trace((Object)"ID exists in ID cache, probably duplicate sent on failover");
            return false;
        }
        long schedDeliveryTime = msg.getScheduledDeliveryTime();
        if (schedDeliveryTime > 0L) {
            ref.setScheduledDeliveryTime(schedDeliveryTime);
        }
        if (dest.isDirect()) {
            Binding binding;
            if (trace) {
                log.trace((Object)(this + " routing " + msg + " to direct destination"));
            }
            if ((binding = this.postOffice.getBindingForQueueName(dest.getName())) == null) {
                throw new IllegalArgumentException("Cannot find binding for queue " + dest.getName());
            }
            Queue queue = binding.queue;
            Long scid = (Long)ref.getMessage().removeHeader("SCID");
            Delivery del = queue.handleMove(ref, scid);
            if (del == null) {
                throw new JMSException("Failed to route " + ref + " to " + dest.getName());
            }
        } else if (dest.isQueue()) {
            if (trace) {
                log.trace((Object)(this + " routing " + msg + " to queue"));
            }
            if (!this.postOffice.route(ref, new JMSCondition(true, dest.getName()), tx)) {
                throw new JMSException("Failed to route " + ref + " to " + dest.getName());
            }
        } else {
            if (trace) {
                log.trace((Object)(this + " routing " + msg + " to postoffice"));
            }
            this.postOffice.route(ref, new JMSCondition(false, dest.getName()), tx);
        }
        if (trace) {
            log.trace((Object)("sent " + msg));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStarted(boolean s) throws Throwable {
        HashMap sessionsClone = null;
        Map map = this.sessions;
        synchronized (map) {
            sessionsClone = new HashMap(this.sessions);
        }
        for (ServerSessionEndpoint sd : sessionsClone.values()) {
            sd.setStarted(s);
        }
        this.started = s;
    }

    private void processTransaction(ClientTransaction txState, Transaction tx, boolean checkForDuplicates) throws Throwable {
        if (trace) {
            log.trace((Object)(this + " processing transaction " + tx));
        }
        for (ClientTransaction.SessionTxState sessionState : txState.getSessionStates()) {
            ServerSessionEndpoint session;
            for (JBossMessage message : sessionState.getMsgs()) {
                boolean accepted;
                if (checkForDuplicates && !message.isReliable() || (accepted = this.sendMessage(message, tx, checkForDuplicates))) continue;
                break;
            }
            if ((session = this.serverPeer.getSession(sessionState.getSessionId())) == null) {
                throw new IllegalStateException("Cannot find session with id " + sessionState.getSessionId());
            }
            session.acknowledgeTransactionally(sessionState.getAcks(), tx);
        }
        if (trace) {
            log.trace((Object)(this + " processed transaction " + tx));
        }
    }
}

