/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.container;

import javax.jms.Destination;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.jms.client.delegate.ClientBrowserDelegate;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.ClientConsumerDelegate;
import org.jboss.jms.client.delegate.ClientProducerDelegate;
import org.jboss.jms.client.delegate.ClientSessionDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.remoting.ConsolidatedRemotingConnectionListener;
import org.jboss.jms.client.remoting.JMSRemotingConnection;
import org.jboss.jms.client.state.BrowserState;
import org.jboss.jms.client.state.ConnectionState;
import org.jboss.jms.client.state.ConsumerState;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.jms.client.state.ProducerState;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.CreateConnectionResult;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Version;

public class StateCreationAspect {
    private static final Logger log = Logger.getLogger(StateCreationAspect.class);
    private boolean trace = log.isTraceEnabled();

    public Object handleCreateConnectionDelegate(Invocation inv) throws Throwable {
        CreateConnectionResult res = (CreateConnectionResult)inv.invokeNext();
        ClientConnectionDelegate connectionDelegate = res.getDelegate();
        if (connectionDelegate != null && connectionDelegate.getState() == null) {
            if (this.trace) {
                log.trace((Object)(connectionDelegate + " not configured, configuring ..."));
            }
            int serverID = connectionDelegate.getServerID();
            Version versionToUse = connectionDelegate.getVersionToUse();
            JMSRemotingConnection remotingConnection = connectionDelegate.getRemotingConnection();
            ConsolidatedRemotingConnectionListener listener = new ConsolidatedRemotingConnectionListener();
            remotingConnection.addConnectionListener(listener);
            if (versionToUse == null) {
                throw new IllegalStateException("Connection version is null");
            }
            ConnectionState connectionState = new ConnectionState(serverID, connectionDelegate, remotingConnection, versionToUse);
            listener.setConnectionState(connectionState);
            connectionDelegate.setState(connectionState);
        }
        return res;
    }

    public Object handleCreateSessionDelegate(Invocation invocation) throws Throwable {
        ClientSessionDelegate sessionDelegate;
        ClientSessionDelegate delegate = sessionDelegate = (ClientSessionDelegate)invocation.invokeNext();
        ConnectionState connectionState = (ConnectionState)this.getState(invocation);
        MethodInvocation mi = (MethodInvocation)invocation;
        boolean transacted = (Boolean)mi.getArguments()[0];
        int ackMode = (Integer)mi.getArguments()[1];
        boolean xa = (Boolean)mi.getArguments()[2];
        SessionState sessionState = new SessionState(connectionState, sessionDelegate, transacted, ackMode, xa, sessionDelegate.getDupsOKBatchSize());
        ((DelegateSupport)delegate).setState(sessionState);
        return delegate;
    }

    public Object handleCreateConsumerDelegate(Invocation invocation) throws Throwable {
        ClientConsumerDelegate consumerDelegate;
        ClientConsumerDelegate delegate = consumerDelegate = (ClientConsumerDelegate)invocation.invokeNext();
        SessionState sessionState = (SessionState)this.getState(invocation);
        MethodInvocation mi = (MethodInvocation)invocation;
        JBossDestination dest = (JBossDestination)mi.getArguments()[0];
        String selector = (String)mi.getArguments()[1];
        boolean noLocal = (Boolean)mi.getArguments()[2];
        String subscriptionName = (String)mi.getArguments()[3];
        boolean connectionConsumer = (Boolean)mi.getArguments()[4];
        String consumerID = consumerDelegate.getID();
        int bufferSize = consumerDelegate.getBufferSize();
        int maxDeliveries = consumerDelegate.getMaxDeliveries();
        long redeliveryDelay = consumerDelegate.getRedeliveryDelay();
        ConsumerState consumerState = new ConsumerState(sessionState, consumerDelegate, dest, selector, noLocal, subscriptionName, consumerID, connectionConsumer, bufferSize, maxDeliveries, redeliveryDelay);
        ((DelegateSupport)delegate).setState(consumerState);
        return consumerDelegate;
    }

    public Object handleCreateProducerDelegate(Invocation invocation) throws Throwable {
        ClientProducerDelegate producerDelegate = new ClientProducerDelegate();
        DelegateSupport delegate = producerDelegate;
        SessionState sessionState = (SessionState)this.getState(invocation);
        MethodInvocation mi = (MethodInvocation)invocation;
        Destination dest = (Destination)mi.getArguments()[0];
        ProducerState producerState = new ProducerState(sessionState, producerDelegate, dest);
        delegate.setState(producerState);
        producerDelegate.getDeliveryMode();
        return producerDelegate;
    }

    public Object handleCreateBrowserDelegate(Invocation invocation) throws Throwable {
        ClientBrowserDelegate browserDelegate;
        MethodInvocation mi = (MethodInvocation)invocation;
        ClientBrowserDelegate delegate = browserDelegate = (ClientBrowserDelegate)invocation.invokeNext();
        SessionState sessionState = (SessionState)this.getState(invocation);
        JBossDestination destination = (JBossDestination)mi.getArguments()[0];
        String selector = (String)mi.getArguments()[1];
        BrowserState state = new BrowserState(sessionState, browserDelegate, destination, selector);
        ((DelegateSupport)delegate).setState(state);
        return browserDelegate;
    }

    private HierarchicalState getState(Invocation inv) {
        return ((DelegateSupport)inv.getTargetObject()).getState();
    }
}

