/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.validator;

import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.validation.AbstractFormValidator;
import org.dcm4chee.usr.entity.User;
import org.dcm4chee.web.common.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PasswordValidator
extends AbstractFormValidator {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(PasswordValidator.class);
    private User user;
    private final FormComponent<?> passwordField;

    public PasswordValidator(User user, FormComponent<?> passwordField) {
        this.user = user;
        this.passwordField = passwordField;
    }

    public FormComponent<?>[] getDependentFormComponents() {
        return new FormComponent[]{this.passwordField};
    }

    public void validate(Form<?> form) {
        try {
            if (!this.user.getPassword().equals(SecurityUtils.encodePassword((String)this.passwordField.getInput()))) {
                this.error(this.passwordField);
            }
        }
        catch (Exception e) {
            log.error(((Object)((Object)this)).getClass().toString() + ": " + "validate: " + e.getMessage());
            e.printStackTrace();
            log.debug("Exception: ", (Throwable)e);
        }
    }
}

