/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.dcm4chee.icons.ImageManager;
import org.dcm4chee.icons.behaviours.ImageSizeBehaviour;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.entity.User;
import org.dcm4chee.usr.entity.UserRoleAssignment;
import org.dcm4chee.usr.model.Role;
import org.dcm4chee.usr.ui.config.delegate.UsrCfgDelegate;
import org.dcm4chee.usr.ui.usermanagement.ChangePasswordLink;
import org.dcm4chee.usr.ui.usermanagement.user.AddUserPage;
import org.dcm4chee.usr.ui.usermanagement.user.RoleAssignmentPage;
import org.dcm4chee.usr.ui.util.CSSUtils;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.behaviours.TooltipBehaviour;
import org.dcm4chee.web.common.markup.ModalWindowLink;
import org.dcm4chee.web.common.markup.modal.ConfirmationWindow;
import org.dcm4chee.web.common.secure.SecureSession;
import org.dcm4chee.web.common.secure.SecurityBehavior;
import org.dcm4chee.web.common.util.Auditlog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserListPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    private UserAccess userAccess;
    private ListModel<User> allUsers;
    private ListModel<Role> allRoles;
    List<String> roleTypes;
    private String userId;
    private ModalWindow addUserWindow;
    private ModalWindow changePasswordWindow;
    private ModalWindow manageRolesWindow;
    private ConfirmationWindow<User> confirmationWindow;

    public UserListPanel(String id) {
        super(id);
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
        this.setOutputMarkupId(true);
        this.userId = ((SecureSession)this.getSession()).getUsername();
        Component[] componentArray = new Component[1];
        this.changePasswordWindow = new ModalWindow("change-password-window");
        componentArray[0] = this.changePasswordWindow;
        this.add(componentArray);
        int[] winSize = UsrCfgDelegate.getInstance().getWindowSize("changePassword");
        if (winSize != null) {
            this.changePasswordWindow.setInitialWidth(winSize[0]);
            this.changePasswordWindow.setInitialHeight(winSize[1]);
        }
        this.allUsers = new ListModel(this.getAllUsers());
        this.allRoles = new ListModel(this.getAllRoles());
        Component[] componentArray2 = new Component[1];
        this.confirmationWindow = new ConfirmationWindow<User>("confirmation-window"){
            private static final long serialVersionUID = 1L;

            public void onConfirmation(AjaxRequestTarget target, User userObject) {
                ((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).deleteUser(userObject.getUserID());
                Auditlog.logSoftwareConfiguration((boolean)true, (String)("User " + userObject.getUserID() + " deleted."));
                target.addComponent((Component)UserListPanel.this);
                UserListPanel.this.allUsers.setObject((Object)UserListPanel.this.getAllUsers());
            }
        };
        componentArray2[0] = this.confirmationWindow;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.addUserWindow = new ModalWindow("add-user-window").setPageCreator(new ModalWindow.PageCreator(){
            private static final long serialVersionUID = 1L;

            public Page createPage() {
                return new AddUserPage(UserListPanel.this.addUserWindow, (ListModel<User>)UserListPanel.this.allUsers);
            }
        });
        componentArray3[0] = this.addUserWindow;
        this.add(componentArray3);
        winSize = UsrCfgDelegate.getInstance().getWindowSize("addUser");
        this.add(new Component[]{new ModalWindowLink("toggle-user-form-link", this.addUserWindow, winSize[0], winSize[1]).add(new Component[]{new Image("toggle-user-form-image", ImageManager.IMAGE_USER_ADD).add(new IBehavior[]{new ImageSizeBehaviour("vertical-align: middle;")})}).add(new Component[]{new Label("userlist.add-user-form.title", (IModel)new ResourceModel("userlist.add-user-form.title"))}).add(new IBehavior[]{new TooltipBehaviour("userlist.")}).add(new IBehavior[]{new SecurityBehavior(UserListPanel.getModuleName() + ":newUserLink")})});
        Component[] componentArray4 = new Component[1];
        this.manageRolesWindow = new ModalWindow("manage-roles-window");
        componentArray4[0] = this.manageRolesWindow;
        this.add(componentArray4);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.allUsers.setObject(this.getAllUsers());
        this.allRoles.setObject(this.getAllRoles());
        RepeatingView roleRows = new RepeatingView("role-rows");
        this.addOrReplace(new Component[]{roleRows});
        for (int i = 0; i < ((List)this.allUsers.getObject()).size(); ++i) {
            final User user = (User)((List)this.allUsers.getObject()).get(i);
            Component[] componentArray = new Component[1];
            WebMarkupContainer rowParent = new WebMarkupContainer(roleRows.newChildId());
            componentArray[0] = rowParent.add(new Component[]{new Label("userID", user.getUserID())});
            roleRows.add(componentArray);
            ChangePasswordLink changePasswordLink = new ChangePasswordLink("change-password-link", this.changePasswordWindow, this.userId, user);
            changePasswordLink.add(new Component[]{new Image("img-change-password", ImageManager.IMAGE_USER_CHANGE_PASSWORD).add(new IBehavior[]{new ImageSizeBehaviour()})}).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)new ResourceModel("userlist.change_password.tooltip").wrapOnAssignment((Component)this).getObject()))});
            rowParent.add(new Component[]{changePasswordLink}).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(i))))});
            changePasswordLink.add(new IBehavior[]{new SecurityBehavior(UserListPanel.getModuleName() + ":changePasswordLink")});
            AjaxFallbackLink<Object> removeUserLink = new AjaxFallbackLink<Object>("remove-user-link"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    UserListPanel.this.confirmationWindow.confirm(target, (IModel)new Model((Serializable)new ResourceModel("userlist.remove-user-link.confirmation").wrapOnAssignment((Component)this.getParent()).getObject()), (Object)user);
                }
            };
            removeUserLink.add(new Component[]{new Image("img-delete", ImageManager.IMAGE_COMMON_REMOVE).add(new IBehavior[]{new TooltipBehaviour("userlist.", "remove-user-link", (IModel)new PropertyModel((Object)user, "userID"))}).add(new IBehavior[]{new ImageSizeBehaviour()})}).setVisible(!this.userId.equals(user.getUserID()));
            rowParent.add(new Component[]{removeUserLink});
            removeUserLink.add(new IBehavior[]{new SecurityBehavior(UserListPanel.getModuleName() + ":removeUserLink")});
            int[] winSize = UsrCfgDelegate.getInstance().getWindowSize("manageRoles");
            rowParent.add(new Component[]{new ModalWindowLink("manage-roles-link", this.manageRolesWindow, winSize[0], winSize[1]){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    UserListPanel.this.manageRolesWindow.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = 1L;

                        public Page createPage() {
                            return new RoleAssignmentPage(UserListPanel.this.manageRolesWindow, user);
                        }
                    });
                    super.onClick(target);
                }
            }.add(new Component[]{new Image("img-roles", ImageManager.IMAGE_USER_ROLE_ADD).add(new IBehavior[]{new TooltipBehaviour("userlist.", "manage-roles-link")})}).add(new IBehavior[]{new SecurityBehavior(UserListPanel.getModuleName() + ":manageRolesLink")})});
            StringBuffer assignedRoles = new StringBuffer();
            for (UserRoleAssignment ura : user.getRoles()) {
                assignedRoles.append(ura.getRole()).append(", ");
            }
            if (assignedRoles.length() > 0) {
                assignedRoles.delete(assignedRoles.length() - 2, assignedRoles.length() - 1);
            }
            rowParent.add(new Component[]{new Label("assigned-roles", assignedRoles.toString())});
        }
    }

    private List<User> getAllUsers() {
        ArrayList<User> allUsers = new ArrayList<User>();
        allUsers.addAll(((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).getAllUsers(((SecureSession)RequestCycle.get().getSession()).getUsername()));
        return allUsers;
    }

    private List<Role> getAllRoles() {
        ArrayList<Role> allRolenames = new ArrayList<Role>(2);
        allRolenames.addAll(this.userAccess.getAllRoles());
        return allRolenames;
    }

    public static String getModuleName() {
        return "userlist";
    }
}

