/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.user;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.security.components.SecureWebPage;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.entity.User;
import org.dcm4chee.usr.entity.UserRoleAssignment;
import org.dcm4chee.usr.model.Role;
import org.dcm4chee.usr.ui.util.CSSUtils;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.secure.SecurityBehavior;
import org.dcm4chee.web.common.util.Auditlog;

public class RoleAssignmentPage
extends SecureWebPage {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    UserAccess userAccess;
    private User user;

    public RoleAssignmentPage(ModalWindow modalWindow, User user) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
        this.user = user;
        this.setOutputMarkupId(true);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.addOrReplace(new Component[]{new Label("username", this.user.getUserID()).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)this.user.getUserID())))})});
        List allRoles = this.userAccess.getAllRoles();
        RepeatingView roleRows = new RepeatingView("role-rows");
        this.addOrReplace(new Component[]{roleRows});
        int i = 0;
        for (Role role : allRoles) {
            Component[] componentArray = new Component[1];
            WebMarkupContainer rowParent = new WebMarkupContainer(roleRows.newChildId());
            componentArray[0] = rowParent.add(new Component[]{new Label("rolename", role.getRolename()).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)role.getRolename())))})});
            roleRows.add(componentArray);
            if (role.isSuperuser()) {
                rowParent.add(new IBehavior[]{new SecurityBehavior(RoleAssignmentPage.getModuleName() + ":superuserRoleRow")});
            }
            rowParent.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(i++))))});
            AjaxCheckBox roleCheckbox = new AjaxCheckBox("role-checkbox", new HasRoleModel(this.user, role.getRolename())){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    target.addComponent((Component)this);
                }

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("title", (CharSequence)new ResourceModel(((HasRoleModel)this.getModel()).getObject() != false ? "roleAssignment.has-role-checkbox.remove.tooltip" : "roleAssignment.has-role-checkbox.add.tooltip").wrapOnAssignment((Component)this).getObject());
                }
            };
            roleCheckbox.add(new IBehavior[]{new SecurityBehavior(RoleAssignmentPage.getModuleName() + ":changeRoleAssignmentCheckbox")});
            roleRows.add(new Component[]{rowParent.add(new Component[]{roleCheckbox})});
        }
    }

    public static String getModuleName() {
        return "roleassignment";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HasRoleModel
    implements IModel<Boolean> {
        private static final long serialVersionUID = 1L;
        private User user;
        private String rolename;
        private UserRoleAssignment ura;

        public HasRoleModel(User user, String rolename) {
            this.user = user;
            this.rolename = rolename;
            this.ura = new UserRoleAssignment();
            this.ura.setUserID(user.getUserID());
            this.ura.setRole(rolename);
        }

        public Boolean getObject() {
            for (UserRoleAssignment role : this.user.getRoles()) {
                if (!role.getRole().equals(this.rolename)) continue;
                return true;
            }
            return false;
        }

        public void setObject(Boolean hasRole) {
            if (hasRole.booleanValue()) {
                RoleAssignmentPage.this.userAccess.assignRole(this.ura);
                this.user.getRoles().add(this.ura);
            } else {
                RoleAssignmentPage.this.userAccess.unassignRole(this.ura);
                for (UserRoleAssignment role : this.user.getRoles()) {
                    if (!role.getRole().equals(this.rolename)) continue;
                    this.user.getRoles().remove(role);
                    break;
                }
            }
            Auditlog.logSoftwareConfiguration((boolean)true, (String)("User " + this.ura.getUserID() + ": Role " + this.ura.getRole() + (hasRole != false ? " assigned" : " unassigned")));
        }

        public void detach() {
        }
    }
}

