/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.user;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.EqualPasswordInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.security.components.SecureWebPage;
import org.apache.wicket.validation.IValidator;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.entity.User;
import org.dcm4chee.usr.ui.validator.UserValidator;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.markup.BaseForm;
import org.dcm4chee.web.common.util.Auditlog;
import org.dcm4chee.web.common.util.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddUserPage
extends SecureWebPage {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    private static Logger log = LoggerFactory.getLogger(AddUserPage.class);
    protected ModalWindow window;

    public AddUserPage(ModalWindow window, ListModel<User> allUsers) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.window = window;
        this.add(new Component[]{new AddUserForm("add-user-form", allUsers)});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class AddUserForm
    extends BaseForm {
        private static final long serialVersionUID = 1L;
        private Model<String> newUsername;
        private Model<String> password;

        public AddUserForm(String id, final ListModel<User> allUsers) {
            super(id);
            this.newUsername = new Model();
            this.password = new Model();
            this.add(new Component[]{new TextField("userlist.add-user-form.username.input", this.newUsername).setRequired(true).add((IValidator)new UserValidator(allUsers))});
            PasswordTextField passwordTf1 = null;
            PasswordTextField passwordTf2 = null;
            Component[] componentArray = new Component[1];
            passwordTf1 = new PasswordTextField("userlist.add-user-form.password_1.input", this.password);
            componentArray[0] = passwordTf1;
            this.add(componentArray);
            Component[] componentArray2 = new Component[1];
            passwordTf2 = new PasswordTextField("userlist.add-user-form.password_2.input", (IModel)new Model((Serializable)((Object)"")));
            componentArray2[0] = passwordTf2;
            this.add(componentArray2);
            this.add((IFormValidator)new EqualPasswordInputValidator((FormComponent)passwordTf1, (FormComponent)passwordTf2));
            this.add(new Component[]{new AjaxFallbackButton("add-user-submit", (Form)this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    try {
                        User user = new User();
                        user.setUserID((String)((Object)AddUserForm.this.newUsername.getObject()));
                        user.setPassword(SecurityUtils.encodePassword((String)((String)((Object)AddUserForm.this.password.getObject()))));
                        user.setRoles(new ArrayList());
                        ((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).createUser(user);
                        Auditlog.logSoftwareConfiguration((boolean)true, (String)("User " + user.getUserID() + " created."));
                        List currentUsers = (List)allUsers.getObject();
                        currentUsers.add(user);
                        allUsers.setObject((Object)currentUsers);
                        AddUserPage.this.window.close(target);
                    }
                    catch (Exception e) {
                        log.error(((Object)((Object)this)).getClass().toString() + ": " + "onSubmit: " + e.getMessage());
                        log.debug("Exception: ", (Throwable)e);
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.addComponent(form);
                }
            }});
        }
    }
}

