/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.role.group;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.dcm4chee.icons.ImageManager;
import org.dcm4chee.icons.behaviours.ImageSizeBehaviour;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.Group;
import org.dcm4chee.usr.ui.config.delegate.UsrCfgDelegate;
import org.dcm4chee.usr.ui.usermanagement.role.group.CreateOrEditGroupPage;
import org.dcm4chee.usr.ui.util.CSSUtils;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.behaviours.TooltipBehaviour;
import org.dcm4chee.web.common.markup.ModalWindowLink;
import org.dcm4chee.web.common.markup.modal.ConfirmationWindow;
import org.dcm4chee.web.common.secure.SecurityBehavior;
import org.dcm4chee.web.common.util.Auditlog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupListPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    UserAccess userAccess;
    private ListModel<Group> allGroups;
    private ConfirmationWindow<Group> confirmationWindow;
    private ModalWindow modalWindow;
    int[] winSize;

    public GroupListPanel(String id) {
        super(id);
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.winSize = UsrCfgDelegate.getInstance().getWindowSize("editGroup");
        this.userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
        this.setOutputMarkupId(true);
        this.allGroups = new ListModel(this.getAllGroups());
        Component[] componentArray = new Component[1];
        this.confirmationWindow = new ConfirmationWindow<Group>("confirmation-window"){
            private static final long serialVersionUID = 1L;

            public void onConfirmation(AjaxRequestTarget target, Group group) {
                GroupListPanel.this.userAccess.removeGroup(group);
                Auditlog.logSoftwareConfiguration((boolean)true, (String)("Role Group " + group.getGroupname() + " removed."));
                target.addComponent((Component)GroupListPanel.this);
                GroupListPanel.this.allGroups.setObject((Object)GroupListPanel.this.getAllGroups());
            }
        };
        componentArray[0] = this.confirmationWindow;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.modalWindow = new ModalWindow("modal-window");
        componentArray2[0] = this.modalWindow;
        this.add(componentArray2);
        this.add(new Component[]{new ModalWindowLink("toggle-group-form-link", this.modalWindow, this.winSize[0], this.winSize[1]){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                GroupListPanel.this.modalWindow.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = 1L;

                    public Page createPage() {
                        return new CreateOrEditGroupPage(GroupListPanel.this.modalWindow, (ListModel<Group>)GroupListPanel.this.allGroups, null);
                    }
                });
                super.onClick(target);
            }
        }.add(new Component[]{new Image("toggle-group-form-image", ImageManager.IMAGE_USER_ROLE_GROUP_ADD).add(new IBehavior[]{new ImageSizeBehaviour("vertical-align: middle;")})}).add(new Component[]{new Label("grouplist.add-group-form.title", (IModel)new ResourceModel("grouplist.add-group-form.title"))}).add(new IBehavior[]{new TooltipBehaviour("grouplist.")}).add(new IBehavior[]{new SecurityBehavior(GroupListPanel.getModuleName() + ":newGroupLink")})});
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        RepeatingView groupRows = new RepeatingView("group-rows");
        this.addOrReplace(new Component[]{groupRows});
        for (int i = 0; i < ((List)this.allGroups.getObject()).size(); ++i) {
            final Group group = (Group)((List)this.allGroups.getObject()).get(i);
            Component[] componentArray = new Component[1];
            WebMarkupContainer rowParent = new WebMarkupContainer(groupRows.newChildId());
            componentArray[0] = rowParent.add(new Component[]{new Label("groupname", group.getGroupname()).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)group.getDescription())))})});
            groupRows.add(componentArray);
            rowParent.add(new IBehavior[]{new AttributeModifier("style", true, (IModel)new Model((Serializable)((Object)("background-color: " + group.getColor()))))});
            rowParent.add(new Component[]{new Label("color", group.getColor())});
            rowParent.add(new Component[]{new ModalWindowLink("edit-group-link", this.modalWindow, this.winSize[0], this.winSize[1]){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    GroupListPanel.this.modalWindow.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = 1L;

                        public Page createPage() {
                            return new CreateOrEditGroupPage(GroupListPanel.this.modalWindow, (ListModel<Group>)GroupListPanel.this.allGroups, group);
                        }
                    });
                    super.onClick(target);
                }
            }.add(new Component[]{new Image("grouplist.edit.image", ImageManager.IMAGE_COMMON_DICOM_EDIT).add(new IBehavior[]{new TooltipBehaviour("grouplist.", "edit-group-link", (IModel)new Model((Serializable)((Object)group.getGroupname())))}).add(new IBehavior[]{new ImageSizeBehaviour("vertical-align: middle;")})}).add(new IBehavior[]{new SecurityBehavior(GroupListPanel.getModuleName() + ":editGroupLink")})});
            rowParent.add(new Component[]{new AjaxFallbackLink<Object>("remove-group-link"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    GroupListPanel.this.confirmationWindow.confirm(target, (IModel)new Model((Serializable)new ResourceModel("grouplist.remove-group-link.confirmation").wrapOnAssignment((Component)this.getParent()).getObject()), (Object)group);
                }
            }.add(new Component[]{new Image("grouplist.delete.image", ImageManager.IMAGE_COMMON_REMOVE).add(new IBehavior[]{new TooltipBehaviour("grouplist.", "remove-group-link", (IModel)new Model((Serializable)((Object)group.getGroupname())))})}).add(new IBehavior[]{new ImageSizeBehaviour()}).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(i))))}).add(new IBehavior[]{new SecurityBehavior(GroupListPanel.getModuleName() + ":removeGroupLink")}).setVisible(!group.getGroupname().equals("Web") && !group.getGroupname().equals("Dicom"))});
        }
    }

    private ArrayList<Group> getAllGroups() {
        ArrayList<Group> allGroups = new ArrayList<Group>();
        allGroups.addAll(this.userAccess.getAllGroups());
        return allGroups;
    }

    public static String getModuleName() {
        return "grouplist";
    }
}

