/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.role.group;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.security.components.SecureWebPage;
import org.apache.wicket.validation.IValidator;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.Group;
import org.dcm4chee.usr.ui.usermanagement.markup.ColorPicker;
import org.dcm4chee.usr.ui.validator.GroupValidator;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketApplication;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.markup.BaseForm;
import org.dcm4chee.web.common.util.Auditlog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOrEditGroupPage
extends SecureWebPage {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    private static Logger log = LoggerFactory.getLogger(CreateOrEditGroupPage.class);
    protected ModalWindow window;

    public CreateOrEditGroupPage(ModalWindow window, ListModel<Group> allGroupnames, Group group) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.window = window;
        this.add(new Component[]{new CreateOrEditGroupForm("add-group-form", allGroupnames, group)});
        this.add(new Component[]{new WebMarkupContainer("create-group-title").setVisible(group == null)});
        this.add(new Component[]{new WebMarkupContainer("edit-group-title").setVisible(group != null)});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CreateOrEditGroupForm
    extends BaseForm {
        private static final long serialVersionUID = 1L;
        private Model<String> groupname;
        private Model<String> description;
        private Model<String> colorPickerModel;
        private TextField<String> groupnameTextField;
        private TextField<String> descriptionTextField;

        public CreateOrEditGroupForm(String id, final ListModel<Group> allGroupnames, final Group group) {
            super(id);
            this.groupname = new Model();
            this.description = new Model();
            this.colorPickerModel = new Model();
            this.groupnameTextField = new TextField("grouplist.add-group-form.groupname.input", this.groupname);
            this.descriptionTextField = new TextField("grouplist.add-group-form.description.input", this.description);
            ((BaseWicketApplication)this.getApplication()).getInitParameter("UserAccessServiceName");
            this.add(new Component[]{this.groupnameTextField.setRequired(true).add((IValidator)new GroupValidator(allGroupnames, group == null ? null : group.getGroupname())).setEnabled(group == null || !group.getGroupname().equals("Web") && !group.getGroupname().equals("Dicom"))});
            this.add(new Component[]{this.descriptionTextField});
            Component[] componentArray = new Component[1];
            final ColorPicker colorPicker = new ColorPicker("color-picker", this.colorPickerModel);
            componentArray[0] = colorPicker;
            this.add(componentArray);
            if (group != null) {
                this.groupnameTextField.setModelObject((Object)group.getGroupname());
                this.descriptionTextField.setModelObject((Object)group.getDescription());
                colorPicker.setColorValue(group.getColor());
            }
            this.add(new Component[]{new AjaxFallbackButton("add-group-submit", (Form)this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    try {
                        UserAccess userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
                        if (group == null) {
                            Group newGroup = new Group((String)((Object)CreateOrEditGroupForm.this.groupname.getObject()));
                            newGroup.setDescription((String)((Object)CreateOrEditGroupForm.this.description.getObject()));
                            newGroup.setColor(colorPicker.getColorValue());
                            userAccess.addGroup(newGroup);
                            Auditlog.logSoftwareConfiguration((boolean)true, (String)("Role Group " + newGroup + " created."));
                        } else {
                            StringBuilder sb = new StringBuilder("Role Group ").append(CreateOrEditGroupForm.this.groupname).append(" updated.");
                            boolean changed = Auditlog.addChange((StringBuilder)sb, (boolean)false, (String)"rolename", (Object)group.getGroupname(), (Object)CreateOrEditGroupForm.this.groupname.getObject());
                            Auditlog.addChange((StringBuilder)sb, (boolean)changed, (String)"description", (Object)group.getDescription(), (Object)CreateOrEditGroupForm.this.description.getObject());
                            Auditlog.addChange((StringBuilder)sb, (boolean)changed, (String)"color", (Object)group.getColor(), (Object)colorPicker.getColorValue());
                            group.setGroupname((String)((Object)CreateOrEditGroupForm.this.groupname.getObject()));
                            group.setDescription((String)((Object)CreateOrEditGroupForm.this.description.getObject()));
                            group.setColor(colorPicker.getColorValue());
                            userAccess.updateGroup(group);
                            Auditlog.logSoftwareConfiguration((boolean)true, (String)("Role Group " + CreateOrEditGroupForm.this.groupname + " updated."));
                        }
                        allGroupnames.setObject((Object)userAccess.getAllGroups());
                        CreateOrEditGroupPage.this.window.close(target);
                    }
                    catch (Exception e) {
                        log.error(((Object)((Object)this)).getClass().toString() + ": " + "onSubmit: " + e.getMessage());
                        log.debug("Exception: ", (Throwable)e);
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.addComponent(form);
                }
            }});
        }
    }
}

