/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.role.assignment;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.security.components.SecureWebPage;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.Role;
import org.dcm4chee.usr.ui.config.delegate.UsrCfgDelegate;
import org.dcm4chee.usr.ui.util.CSSUtils;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketApplication;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.secure.SecureSession;
import org.dcm4chee.web.common.secure.SecurityBehavior;
import org.dcm4chee.web.common.util.Auditlog;

public class WebPermissionsPage
extends SecureWebPage {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    UserAccess userAccess;
    private Role role;

    public WebPermissionsPage(ModalWindow modalWindow, Role role) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
        this.role = role;
        this.setOutputMarkupId(true);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.addOrReplace(new Component[]{new Label("rolename", this.role.getRolename()).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)this.role.getDescription())))})});
        RepeatingView principalRows = new RepeatingView("principal-rows");
        this.addOrReplace(new Component[]{principalRows});
        Map principalsAndKeys = ((SecureSession)this.getSession()).getAllSwarmPrincipals();
        Iterator principals = principalsAndKeys.keySet().iterator();
        boolean showStudyPermissionRights = UsrCfgDelegate.getInstance().getShowStudyPermissionRights();
        String studyPermissionsAll = BaseWicketApplication.get().getInitParameter("StudyPermissionsAllRolename");
        String studyPermissionsOwn = BaseWicketApplication.get().getInitParameter("StudyPermissionsOwnRolename");
        String studyPermissionsPropagation = BaseWicketApplication.get().getInitParameter("StudyPermissionsPropagationRolename");
        int i = 0;
        while (principals.hasNext()) {
            String principal = (String)principals.next();
            if (!showStudyPermissionRights && (principal.equals(studyPermissionsAll) || principal.equals(studyPermissionsOwn) || principal.equals(studyPermissionsPropagation))) continue;
            String key = (String)principalsAndKeys.get(principal);
            Component[] componentArray = new Component[1];
            WebMarkupContainer rowParent = new WebMarkupContainer(principalRows.newChildId());
            componentArray[0] = rowParent.add(new Component[]{new Label("principalname", (IModel)(key == null ? new Model((Serializable)((Object)principal)) : new ResourceModel(key + ".name", principal))).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)(key == null ? new Model((Serializable)((Object)principal)) : new ResourceModel(key + ".tooltip", key)))})});
            principalRows.add(componentArray);
            rowParent.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(i++))))});
            AjaxCheckBox principalCheckbox = new AjaxCheckBox("principal-checkbox", new HasPrincipalModel(this.role, principal)){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    target.addComponent((Component)this);
                }

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("title", (CharSequence)new ResourceModel(((HasPrincipalModel)this.getModel()).getObject() != false ? "webPermissions.has-principal-checkbox.remove.tooltip" : "webPermissions.has-principal-checkbox.add.tooltip").wrapOnAssignment((Component)this).getObject());
                }
            };
            principalCheckbox.add(new IBehavior[]{new SecurityBehavior(WebPermissionsPage.getModuleName() + ":changePrincipalAssignmentCheckbox")});
            principalRows.add(new Component[]{rowParent.add(new Component[]{principalCheckbox})});
        }
    }

    public static String getModuleName() {
        return "webpermissions";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HasPrincipalModel
    implements IModel<Boolean> {
        private static final long serialVersionUID = 1L;
        private Role role;
        private String principalname;

        public HasPrincipalModel(Role role, String principal) {
            this.role = role;
            this.principalname = principal;
        }

        public Boolean getObject() {
            return this.role.getSwarmPrincipals().contains(this.principalname);
        }

        public void setObject(Boolean hasPrincipal) {
            Set swarmPrincipals = this.role.getSwarmPrincipals();
            if (hasPrincipal.booleanValue()) {
                swarmPrincipals.add(this.principalname);
            } else {
                swarmPrincipals.remove(this.principalname);
            }
            this.role.setSwarmPrincipals(swarmPrincipals);
            WebPermissionsPage.this.userAccess.updateRole(this.role);
            Auditlog.logSoftwareConfiguration((boolean)true, (String)("Role " + this.role + ": WEB right " + this.principalname + " " + (hasPrincipal != false ? " assigned" : "unassigned")));
        }

        public void detach() {
        }
    }
}

