/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.role.assignment;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.security.components.SecureWebPage;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.AETGroup;
import org.dcm4chee.usr.model.Role;
import org.dcm4chee.usr.ui.util.CSSUtils;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.secure.SecurityBehavior;
import org.dcm4chee.web.common.util.Auditlog;

public class AETGroupAssignmentPage
extends SecureWebPage {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    UserAccess userAccess;
    private Role role;

    public AETGroupAssignmentPage(ModalWindow modalWindow, Role role) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
        this.role = role;
        this.setOutputMarkupId(true);
        Component[] componentArray = new Component[1];
        WebMarkupContainer universalmatchRow = new WebMarkupContainer("universalmatch-row");
        componentArray[0] = universalmatchRow;
        this.add(componentArray);
        universalmatchRow.add(new Component[]{new Label("universalmatch-name", (IModel)new ResourceModel("aetgroupassignment.universalmatch.label")).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("aetgroupassignment.universalmatch.description"))}).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(0))))})});
        universalmatchRow.add(new Component[]{new AjaxCheckBox("universalmatch-checkbox", new HasAETGroupModel(role)){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.addComponent((Component)this);
            }

            protected void onComponentTag(ComponentTag tag) {
                super.onComponentTag(tag);
                tag.put("title", (CharSequence)new ResourceModel(((HasAETGroupModel)this.getModel()).getObject() != false ? "aetgroupassignment.has-aet-group-checkbox.remove.tooltip" : "aetgroupassignment.has-aet-group-checkbox.add.tooltip").wrapOnAssignment((Component)this).getObject());
            }
        }}).add(new IBehavior[]{new SecurityBehavior(AETGroupAssignmentPage.getModuleName() + ":changeAETGroupAssignmentCheckbox")});
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.addOrReplace(new Component[]{new Label("rolename", this.role.getRolename()).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)this.role.getDescription())))})});
        RepeatingView aetGroupRows = new RepeatingView("aet-group-rows");
        this.addOrReplace(new Component[]{aetGroupRows});
        List aetGroups = this.userAccess.getAllAETGroups();
        int i = 1;
        for (AETGroup aetGroup : aetGroups) {
            Component[] componentArray = new Component[1];
            WebMarkupContainer rowParent = new WebMarkupContainer(aetGroupRows.newChildId());
            componentArray[0] = rowParent.add(new Component[]{new Label("aetgroupname", aetGroup.getGroupname()).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)aetGroup.getDescription())))})});
            aetGroupRows.add(componentArray);
            rowParent.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(i++))))});
            AjaxCheckBox aetGroupCheckbox = new AjaxCheckBox("aetGroup-checkbox", new HasAETGroupModel(this.role, aetGroup)){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    target.addComponent((Component)this);
                }

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("title", (CharSequence)new ResourceModel(((HasAETGroupModel)this.getModel()).getObject() != false ? "aetgroupassignment.has-aet-group-checkbox.remove.tooltip" : "aetgroupassignment.has-aet-group-checkbox.add.tooltip").wrapOnAssignment((Component)this).getObject());
                }
            };
            aetGroupCheckbox.add(new IBehavior[]{new SecurityBehavior(AETGroupAssignmentPage.getModuleName() + ":changeAETGroupAssignmentCheckbox")});
            aetGroupRows.add(new Component[]{rowParent.add(new Component[]{aetGroupCheckbox})});
        }
    }

    public static String getModuleName() {
        return "aetgroupassignment";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HasAETGroupModel
    implements IModel<Boolean> {
        private static final long serialVersionUID = 1L;
        private Role role;
        private AETGroup aetGroup;

        public HasAETGroupModel(Role role, AETGroup aetGroup) {
            this.role = role;
            this.aetGroup = aetGroup;
        }

        public HasAETGroupModel(Role role) {
            this.role = role;
            this.aetGroup = null;
        }

        public Boolean getObject() {
            return this.aetGroup == null ? this.role.getAETGroups().contains("*") : this.role.getAETGroups().contains(this.aetGroup.getUuid());
        }

        public void setObject(Boolean hasAETGroup) {
            String uuid = this.aetGroup == null ? "*" : this.aetGroup.getUuid();
            Set aetGroups = this.role.getAETGroups();
            if (hasAETGroup.booleanValue()) {
                aetGroups.add(uuid);
            } else {
                aetGroups.remove(uuid);
            }
            this.role.setAETGroups(aetGroups);
            this.role.setAETRole(aetGroups.size() > 0);
            AETGroupAssignmentPage.this.userAccess.updateRole(this.role);
            Auditlog.logSoftwareConfiguration((boolean)true, (String)("Role " + this.role + ": AET role " + (this.role.isAETRole() ? " assigned" : "unassigned")));
        }

        public void detach() {
        }
    }
}

