/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.role.aet;

import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.security.components.SecureWebPage;
import org.apache.wicket.validation.IValidator;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.AETGroup;
import org.dcm4chee.usr.ui.validator.AETGroupValidator;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketApplication;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.markup.BaseForm;
import org.dcm4chee.web.common.util.Auditlog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOrEditAETGroupPage
extends SecureWebPage {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    private static Logger log = LoggerFactory.getLogger(CreateOrEditAETGroupPage.class);
    protected ModalWindow window;

    public CreateOrEditAETGroupPage(ModalWindow window, ListModel<AETGroup> allAETGroupnames, AETGroup aetGroup) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.window = window;
        this.add(new Component[]{new CreateOrEditAETGroupForm("add-aet-group-form", allAETGroupnames, aetGroup)});
        this.add(new Component[]{new WebMarkupContainer("create-aet-group-title").setVisible(aetGroup == null)});
        this.add(new Component[]{new WebMarkupContainer("edit-aet-group-title").setVisible(aetGroup != null)});
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CreateOrEditAETGroupForm
    extends BaseForm {
        private static final long serialVersionUID = 1L;
        private Model<String> groupname;
        private Model<String> description;
        private TextField<String> groupnameTextField;
        private TextField<String> descriptionTextField;

        public CreateOrEditAETGroupForm(String id, final ListModel<AETGroup> allAETGroupnames, final AETGroup aetGroup) {
            super(id);
            this.groupname = new Model();
            this.description = new Model();
            this.groupnameTextField = new TextField("aetgrouplist.add-aet-group-form.groupname.input", this.groupname);
            this.descriptionTextField = new TextField("aetgrouplist.add-aet-group-form.description.input", this.description);
            ((BaseWicketApplication)this.getApplication()).getInitParameter("UserAccessServiceName");
            this.add(new Component[]{this.groupnameTextField.setRequired(true).add((IValidator)new AETGroupValidator(allAETGroupnames, aetGroup == null ? null : aetGroup.getGroupname()))});
            this.add(new Component[]{this.descriptionTextField});
            if (aetGroup != null) {
                this.groupnameTextField.setModelObject((Object)aetGroup.getGroupname());
                this.descriptionTextField.setModelObject((Object)aetGroup.getDescription());
            }
            this.add(new Component[]{new AjaxFallbackButton("add-aet-group-submit", (Form)this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    try {
                        UserAccess userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
                        if (aetGroup == null) {
                            AETGroup newAETGroup = new AETGroup((String)((Object)CreateOrEditAETGroupForm.this.groupname.getObject()));
                            newAETGroup.setDescription((String)((Object)CreateOrEditAETGroupForm.this.description.getObject()));
                            userAccess.addAETGroup(newAETGroup);
                            Auditlog.logSoftwareConfiguration((boolean)true, (String)("AEGroup " + newAETGroup + " created."));
                        } else {
                            StringBuilder sb = new StringBuilder("AEGroup ").append(aetGroup.getGroupname()).append(" updated. ");
                            boolean changed = Auditlog.addChange((StringBuilder)sb, (boolean)false, (String)"group name", (Object)aetGroup.getGroupname(), (Object)CreateOrEditAETGroupForm.this.groupname.getObject());
                            Auditlog.addChange((StringBuilder)sb, (boolean)changed, (String)"description", (Object)aetGroup.getDescription(), (Object)aetGroup.getDescription());
                            aetGroup.setGroupname((String)((Object)CreateOrEditAETGroupForm.this.groupname.getObject()));
                            aetGroup.setDescription((String)((Object)CreateOrEditAETGroupForm.this.description.getObject()));
                            userAccess.updateAETGroup(aetGroup);
                            Auditlog.logSoftwareConfiguration((boolean)true, (String)sb.toString());
                        }
                        allAETGroupnames.setObject((Object)userAccess.getAllAETGroups());
                        CreateOrEditAETGroupPage.this.window.close(target);
                    }
                    catch (Exception e) {
                        log.error(((Object)((Object)this)).getClass().toString() + ": " + "onSubmit: " + e.getMessage());
                        log.debug("Exception: ", (Throwable)e);
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.addComponent(form);
                }
            }});
        }
    }
}

