/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.role.aet;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.dcm4chee.icons.ImageManager;
import org.dcm4chee.icons.behaviours.ImageSizeBehaviour;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.AETGroup;
import org.dcm4chee.usr.ui.config.delegate.UsrCfgDelegate;
import org.dcm4chee.usr.ui.usermanagement.role.aet.AETAssignmentPage;
import org.dcm4chee.usr.ui.usermanagement.role.aet.CreateOrEditAETGroupPage;
import org.dcm4chee.usr.ui.util.CSSUtils;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.behaviours.TooltipBehaviour;
import org.dcm4chee.web.common.markup.ModalWindowLink;
import org.dcm4chee.web.common.markup.modal.ConfirmationWindow;
import org.dcm4chee.web.common.secure.SecurityBehavior;
import org.dcm4chee.web.common.util.Auditlog;

public class AETGroupListPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    UserAccess userAccess;
    private ListModel<AETGroup> allAETGroups = new ListModel();
    private ConfirmationWindow<AETGroup> confirmationWindow;
    private ModalWindow aetGroupWindow;
    private ModalWindow aetAssignmentWindow;
    private Map<String, int[]> windowsizeMap = new LinkedHashMap<String, int[]>();

    public AETGroupListPanel(String id) {
        super(id);
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.windowsizeMap.put("editAETGroup", UsrCfgDelegate.getInstance().getWindowSize("editAETGroup"));
        this.windowsizeMap.put("aetAssignment", UsrCfgDelegate.getInstance().getWindowSize("aetAssignment"));
        this.userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
        this.setOutputMarkupId(true);
        this.allAETGroups.setObject((Object)this.userAccess.getAllAETGroups());
        Component[] componentArray = new Component[1];
        this.aetGroupWindow = new ModalWindow("aet-group-window");
        componentArray[0] = this.aetGroupWindow;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.aetAssignmentWindow = new ModalWindow("aet-assignment-window");
        componentArray2[0] = this.aetAssignmentWindow;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.confirmationWindow = new ConfirmationWindow<AETGroup>("confirmation-window"){
            private static final long serialVersionUID = 1L;

            public void onConfirmation(AjaxRequestTarget target, AETGroup aetGroup) {
                AETGroupListPanel.this.userAccess.removeAETGroup(aetGroup);
                Auditlog.logSoftwareConfiguration((boolean)true, (String)("AEGroup " + aetGroup + " removed."));
                target.addComponent((Component)AETGroupListPanel.this);
                AETGroupListPanel.this.allAETGroups.setObject((Object)AETGroupListPanel.this.userAccess.getAllAETGroups());
            }
        };
        componentArray3[0] = this.confirmationWindow;
        this.add(componentArray3);
        int[] winSize = this.windowsizeMap.get("editAETGroup");
        this.add(new Component[]{new ModalWindowLink("toggle-aet-group-form-link", this.aetGroupWindow, winSize[0], winSize[1]){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                AETGroupListPanel.this.aetGroupWindow.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = 1L;

                    public Page createPage() {
                        return new CreateOrEditAETGroupPage(AETGroupListPanel.this.aetGroupWindow, (ListModel<AETGroup>)AETGroupListPanel.this.allAETGroups, null);
                    }
                });
                super.onClick(target);
            }
        }.add(new Component[]{new Image("toggle-aet-group-form-image", ImageManager.IMAGE_USER_AET_GROUP_ADD).add(new IBehavior[]{new ImageSizeBehaviour("vertical-align: middle;")})}).add(new Component[]{new Label("aetgrouplist.add-aet-group-form.title", (IModel)new ResourceModel("aetgrouplist.add-aet-group-form.title"))}).add(new IBehavior[]{new TooltipBehaviour("aetgrouplist.")}).add(new IBehavior[]{new SecurityBehavior(AETGroupListPanel.getModuleName() + ":newAETGroupLink")})});
        this.add(new Component[]{new Label("groupname", (IModel)new ResourceModel("aetgrouplist.universalmatch.label")).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("aetgrouplist.universalmatch.description"))})});
        this.add(new Component[]{new Label("assigned-aets", (IModel)new ResourceModel("aetgrouplist.universalmatch.text"))});
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.allAETGroups.setObject((Object)this.userAccess.getAllAETGroups());
        RepeatingView aetGroupRows = new RepeatingView("aet-group-rows");
        this.addOrReplace(new Component[]{aetGroupRows});
        for (int i = 0; i < ((List)this.allAETGroups.getObject()).size(); ++i) {
            final AETGroup aetGroup = (AETGroup)((List)this.allAETGroups.getObject()).get(i);
            Component[] componentArray = new Component[1];
            WebMarkupContainer rowParent = new WebMarkupContainer(aetGroupRows.newChildId());
            componentArray[0] = rowParent.add(new Component[]{new Label("groupname", aetGroup.getGroupname()).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)aetGroup.getDescription())))})});
            aetGroupRows.add(componentArray);
            int[] winSize = this.windowsizeMap.get("editAETGroup");
            rowParent.add(new Component[]{new ModalWindowLink("edit-aet-group-link", this.aetGroupWindow, winSize[0], winSize[1]){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    AETGroupListPanel.this.aetGroupWindow.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = 1L;

                        public Page createPage() {
                            return new CreateOrEditAETGroupPage(AETGroupListPanel.this.aetGroupWindow, (ListModel<AETGroup>)AETGroupListPanel.this.allAETGroups, aetGroup);
                        }
                    });
                    super.onClick(target);
                }
            }.add(new Component[]{new Image("aetgrouplist.edit.image", ImageManager.IMAGE_COMMON_DICOM_EDIT).add(new IBehavior[]{new TooltipBehaviour("aetgrouplist.", "edit-aet-group-link", (IModel)new Model((Serializable)((Object)aetGroup.getGroupname())))}).add(new IBehavior[]{new ImageSizeBehaviour("vertical-align: middle;")})}).add(new IBehavior[]{new SecurityBehavior(AETGroupListPanel.getModuleName() + ":editAETGroupLink")})});
            rowParent.add(new Component[]{new AjaxFallbackLink<Object>("remove-aet-group-link"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    AETGroupListPanel.this.confirmationWindow.confirm(target, (IModel)new Model((Serializable)new ResourceModel("aetgrouplist.remove-aet-group-link.confirmation").wrapOnAssignment((Component)this.getParent()).getObject()), (Object)aetGroup);
                }
            }.add(new Component[]{new Image("aetgrouplist.delete.image", ImageManager.IMAGE_COMMON_REMOVE).add(new IBehavior[]{new TooltipBehaviour("aetgrouplist.", "remove-aet-group-link", (IModel)new Model((Serializable)((Object)aetGroup.getGroupname())))})}).add(new IBehavior[]{new ImageSizeBehaviour()}).setVisible(!this.userAccess.getUserRoleName().equals(aetGroup.getGroupname()) && !this.userAccess.getAdminRoleName().equals(aetGroup.getGroupname())).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(i))))}).add(new IBehavior[]{new SecurityBehavior(AETGroupListPanel.getModuleName() + ":removeAETGroupLink")})});
            winSize = this.windowsizeMap.get("aetAssignment");
            rowParent.add(new Component[]{new ModalWindowLink("aetAssignment-link", this.aetAssignmentWindow, winSize[0], winSize[1]){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    AETGroupListPanel.this.aetAssignmentWindow.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = 1L;

                        public Page createPage() {
                            return new AETAssignmentPage(AETGroupListPanel.this.aetAssignmentWindow, aetGroup);
                        }
                    });
                    super.onClick(target);
                }
            }.add(new Component[]{new Image("aetgrouplist.aetAssignment.image", ImageManager.IMAGE_USER_AET_GROUP_AETS).add(new IBehavior[]{new TooltipBehaviour("aetgrouplist.", "aet-assignment-link")})}).add(new IBehavior[]{new SecurityBehavior(AETGroupListPanel.getModuleName() + ":aetAssignmentLink")})});
            StringBuffer assignedAETs = new StringBuffer();
            for (String aet : aetGroup.getAets()) {
                assignedAETs.append(aet).append(", ");
            }
            if (assignedAETs.length() > 0) {
                assignedAETs.delete(assignedAETs.length() - 2, assignedAETs.length() - 1);
            }
            rowParent.add(new Component[]{new Label("assigned-aets", assignedAETs.toString())});
        }
    }

    public static String getModuleName() {
        return "aetgrouplist";
    }
}

