/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.role.aet;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.security.components.SecureWebPage;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.AETGroup;
import org.dcm4chee.usr.ui.util.CSSUtils;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.secure.SecurityBehavior;
import org.dcm4chee.web.common.util.Auditlog;

public class AETAssignmentPage
extends SecureWebPage {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    UserAccess userAccess;
    private AETGroup aetGroup;
    private Set<String> aets = new LinkedHashSet<String>();

    public AETAssignmentPage(ModalWindow modalWindow, AETGroup aetGroup) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
        this.aetGroup = aetGroup;
        this.setOutputMarkupId(true);
        this.aets.addAll(((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).listAETitles());
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.addOrReplace(new Component[]{new Label("groupname", this.aetGroup.getGroupname()).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)this.aetGroup.getDescription())))})});
        RepeatingView aetRows = new RepeatingView("aet-rows");
        this.addOrReplace(new Component[]{aetRows});
        Iterator<String> aetList = this.aets.iterator();
        int i = 0;
        while (aetList.hasNext()) {
            String aet = aetList.next();
            Component[] componentArray = new Component[1];
            WebMarkupContainer rowParent = new WebMarkupContainer(aetRows.newChildId());
            componentArray[0] = rowParent.add(new Component[]{new Label("aetname", aet)});
            aetRows.add(componentArray);
            rowParent.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(i++))))});
            AjaxCheckBox aetCheckbox = new AjaxCheckBox("aet-checkbox", new HasAETModel(this.aetGroup, aet)){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                    target.addComponent((Component)this);
                }

                protected void onComponentTag(ComponentTag tag) {
                    super.onComponentTag(tag);
                    tag.put("title", (CharSequence)new ResourceModel(((HasAETModel)this.getModel()).getObject() != false ? "aetAssignment.has-aet-checkbox.remove.tooltip" : "aetAssignment.has-aet-checkbox.add.tooltip").wrapOnAssignment((Component)this).getObject());
                }
            };
            aetCheckbox.add(new IBehavior[]{new SecurityBehavior(AETAssignmentPage.getModuleName() + ":changeAETAssignmentCheckbox")});
            aetRows.add(new Component[]{rowParent.add(new Component[]{aetCheckbox})});
        }
    }

    public static String getModuleName() {
        return "aetassignment";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HasAETModel
    implements IModel<Boolean> {
        private static final long serialVersionUID = 1L;
        private AETGroup aetGroup;
        private String aet;

        public HasAETModel(AETGroup aetGroup, String aet) {
            this.aetGroup = aetGroup;
            this.aet = aet;
        }

        public Boolean getObject() {
            return this.aetGroup.getAets().contains(this.aet);
        }

        public void setObject(Boolean hasAET) {
            Set aets = this.aetGroup.getAets();
            if (hasAET.booleanValue()) {
                aets.add(this.aet);
            } else {
                aets.remove(this.aet);
            }
            this.aetGroup.setAets(aets);
            AETAssignmentPage.this.userAccess.updateAETGroup(this.aetGroup);
            Auditlog.logSoftwareConfiguration((boolean)true, (String)("AEGroup " + this.aetGroup + ": AET " + this.aet + (hasAET != false ? " added" : " removed")));
        }

        public void detach() {
        }
    }
}

