/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.role;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxFallbackLink;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.util.ListModel;
import org.dcm4chee.icons.ImageManager;
import org.dcm4chee.icons.behaviours.ImageSizeBehaviour;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.Group;
import org.dcm4chee.usr.model.Role;
import org.dcm4chee.usr.ui.config.delegate.UsrCfgDelegate;
import org.dcm4chee.usr.ui.usermanagement.role.CreateOrEditRolePage;
import org.dcm4chee.usr.ui.usermanagement.role.assignment.AETGroupAssignmentPage;
import org.dcm4chee.usr.ui.usermanagement.role.assignment.WebPermissionsPage;
import org.dcm4chee.usr.ui.util.CSSUtils;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.behaviours.TooltipBehaviour;
import org.dcm4chee.web.common.markup.ModalWindowLink;
import org.dcm4chee.web.common.markup.modal.ConfirmationWindow;
import org.dcm4chee.web.common.secure.SecurityBehavior;
import org.dcm4chee.web.common.util.Auditlog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleListPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    UserAccess userAccess;
    private ListModel<Role> allRoles;
    private Map<String, Group> allGroups;
    private List<Group> roleGroups;
    private ConfirmationWindow<Role> confirmationWindow;
    private ModalWindow roleWindow;
    private ModalWindow webroleWindow;
    private ModalWindow aetroleWindow;
    private Map<String, int[]> windowsizeMap = new LinkedHashMap<String, int[]>();
    private String webRoleColor;
    private String dicomRoleColor;
    private String aetRoleColor;

    public RoleListPanel(String id) {
        super(id);
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.windowsizeMap.put("editRole", UsrCfgDelegate.getInstance().getWindowSize("editRole"));
        this.windowsizeMap.put("webPermissions", UsrCfgDelegate.getInstance().getWindowSize("webPermissions"));
        this.windowsizeMap.put("aetGroupAssignment", UsrCfgDelegate.getInstance().getWindowSize("aetGroupAssignment"));
        this.userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
        this.setOutputMarkupId(true);
        this.allRoles = new ListModel(this.getAllRoles());
        this.allGroups = this.getAllGroups();
        this.roleGroups = this.userAccess.getAllGroups();
        Component[] componentArray = new Component[1];
        this.confirmationWindow = new ConfirmationWindow<Role>("confirmation-window"){
            private static final long serialVersionUID = 1L;

            public void onConfirmation(AjaxRequestTarget target, Role role) {
                RoleListPanel.this.userAccess.removeRole(role);
                Auditlog.logSoftwareConfiguration((boolean)true, (String)("Role " + role + " removed."));
                target.addComponent((Component)RoleListPanel.this);
                RoleListPanel.this.allRoles.setObject((Object)RoleListPanel.this.getAllRoles());
            }
        };
        componentArray[0] = this.confirmationWindow;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.roleWindow = new ModalWindow("role-window");
        componentArray2[0] = this.roleWindow;
        this.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.webroleWindow = new ModalWindow("webrole-window");
        componentArray3[0] = this.webroleWindow;
        this.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.aetroleWindow = new ModalWindow("aetrole-window");
        componentArray4[0] = this.aetroleWindow;
        this.add(componentArray4);
        int[] winSize = this.windowsizeMap.get("editRole");
        this.add(new Component[]{new ModalWindowLink("toggle-role-form-link", this.roleWindow, winSize[0], winSize[1]){
            private static final long serialVersionUID = 1L;

            public void onClick(AjaxRequestTarget target) {
                RoleListPanel.this.roleWindow.setPageCreator(new ModalWindow.PageCreator(){
                    private static final long serialVersionUID = 1L;

                    public Page createPage() {
                        return new CreateOrEditRolePage(RoleListPanel.this.roleWindow, (ListModel<Role>)RoleListPanel.this.allRoles, null, RoleListPanel.this.allGroups);
                    }
                });
                super.onClick(target);
            }
        }.add(new Component[]{new Image("toggle-role-form-image", ImageManager.IMAGE_USER_ROLE_ADD).add(new IBehavior[]{new ImageSizeBehaviour("vertical-align: middle;")})}).add(new Component[]{new Label("rolelist.add-role-form.title", (IModel)new ResourceModel("rolelist.add-role-form.title"))}).add(new IBehavior[]{new TooltipBehaviour("rolelist.")}).add(new IBehavior[]{new SecurityBehavior(RoleListPanel.getModuleName() + ":newRoleLink")})});
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
        this.allRoles.setObject(this.getAllRoles());
        this.allGroups = this.getAllGroups();
        this.roleGroups = this.userAccess.getAllGroups();
        for (String uuid : this.allGroups.keySet()) {
            Group group = this.allGroups.get(uuid);
            if (group.getGroupname().equals("Web")) {
                this.webRoleColor = group.getColor();
            }
            if (group.getGroupname().equals("Dicom")) {
                this.dicomRoleColor = group.getColor();
            }
            if (!group.getGroupname().equals("AET")) continue;
            this.aetRoleColor = group.getColor();
        }
        RepeatingView roleRows = new RepeatingView("role-rows");
        this.addOrReplace(new Component[]{roleRows});
        RepeatingView groupHeaderCells = new RepeatingView("group-header-cells");
        this.addOrReplace(new Component[]{groupHeaderCells});
        for (Group group : this.roleGroups) {
            groupHeaderCells.add(new Component[]{new WebMarkupContainer(groupHeaderCells.newChildId()).add(new Component[]{new Label("groupname", group.getGroupname())})});
        }
        for (int i = 0; i < ((List)this.allRoles.getObject()).size(); ++i) {
            final Role role = (Role)((List)this.allRoles.getObject()).get(i);
            Component[] componentArray = new Component[1];
            WebMarkupContainer rowParent = new WebMarkupContainer(roleRows.newChildId());
            componentArray[0] = rowParent.add(new Component[]{new Label("rolename", role.getRolename()).add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new Model((Serializable)((Object)role.getDescription())))})});
            roleRows.add(componentArray);
            rowParent.add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(i))))});
            if (role.isSuperuser()) {
                rowParent.add(new IBehavior[]{new SecurityBehavior(RoleListPanel.getModuleName() + ":superuserRoleRow")});
            }
            int[] winSize = this.windowsizeMap.get("editRole");
            rowParent.add(new Component[]{new ModalWindowLink("edit-role-link", this.roleWindow, winSize[0], winSize[1]){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    RoleListPanel.this.roleWindow.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = 1L;

                        public Page createPage() {
                            return new CreateOrEditRolePage(RoleListPanel.this.roleWindow, (ListModel<Role>)RoleListPanel.this.allRoles, role, RoleListPanel.this.allGroups);
                        }
                    });
                    super.onClick(target);
                }
            }.add(new Component[]{new Image("rolelist.edit.image", ImageManager.IMAGE_COMMON_DICOM_EDIT).add(new IBehavior[]{new TooltipBehaviour("rolelist.", "edit-role-link", (IModel)new Model((Serializable)((Object)role.getRolename())))}).add(new IBehavior[]{new ImageSizeBehaviour("vertical-align: middle;")})}).add(new IBehavior[]{new SecurityBehavior(RoleListPanel.getModuleName() + ":editRoleLink")})});
            rowParent.add(new Component[]{new AjaxFallbackLink<Object>("remove-role-link"){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    RoleListPanel.this.confirmationWindow.confirm(target, (IModel)new Model((Serializable)new ResourceModel("rolelist.remove-role-link.confirmation").wrapOnAssignment((Component)this.getParent()).getObject()), (Object)role);
                }
            }.add(new Component[]{new Image("rolelist.delete.image", ImageManager.IMAGE_COMMON_REMOVE).add(new IBehavior[]{new TooltipBehaviour("rolelist.", "remove-role-link", (IModel)new Model((Serializable)((Object)role.getRolename())))})}).add(new IBehavior[]{new ImageSizeBehaviour()}).setVisible(!this.userAccess.getUserRoleName().equals(role.getRolename()) && !this.userAccess.getAdminRoleName().equals(role.getRolename())).add(new IBehavior[]{new AttributeModifier("class", true, (IModel)new Model((Serializable)((Object)CSSUtils.getRowClass(i))))}).add(new IBehavior[]{new SecurityBehavior(RoleListPanel.getModuleName() + ":removeRoleLink")})});
            winSize = this.windowsizeMap.get("webPermissions");
            WebMarkupContainer webroleCell = new WebMarkupContainer("webrole-cell");
            webroleCell.add(new Component[]{new ModalWindowLink("webrole-link", this.webroleWindow, winSize[0], winSize[1]){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    RoleListPanel.this.webroleWindow.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = 1L;

                        public Page createPage() {
                            return new WebPermissionsPage(RoleListPanel.this.webroleWindow, role);
                        }
                    });
                    super.onClick(target);
                }
            }.add(new Component[]{new Image("rolelist.webrole.image", ImageManager.IMAGE_USER_WEB_PERMISSIONS).add(new IBehavior[]{new TooltipBehaviour("rolelist.", "webrole-link", (IModel)new Model((Serializable)((Object)role.getRolename())))})}).setVisible(role.isWebRole()).add(new IBehavior[]{new SecurityBehavior(RoleListPanel.getModuleName() + ":webroleLink")})});
            if (role.isWebRole()) {
                webroleCell.add(new IBehavior[]{new AttributeAppender("style", (IModel)new Model((Serializable)((Object)("background-color: " + this.webRoleColor))), " ")});
            }
            rowParent.add(new Component[]{webroleCell});
            WebMarkupContainer dicomroleCell = new WebMarkupContainer("dicomrole-cell");
            dicomroleCell.add(new Component[]{new AjaxCheckBox("dicomrole-checkbox", (IModel)new Model((Serializable)Boolean.valueOf(role.isDicomRole()))){
                private static final long serialVersionUID = 1L;

                protected void onUpdate(AjaxRequestTarget target) {
                }
            }.setEnabled(false)});
            if (role.isDicomRole()) {
                dicomroleCell.add(new IBehavior[]{new AttributeAppender("style", (IModel)new Model((Serializable)((Object)("background-color: " + this.dicomRoleColor))), " ")});
            }
            rowParent.add(new Component[]{dicomroleCell});
            winSize = this.windowsizeMap.get("aetGroupAssignment");
            WebMarkupContainer aetroleCell = new WebMarkupContainer("aetrole-cell");
            aetroleCell.add(new Component[]{new ModalWindowLink("aetrole-link", this.aetroleWindow, winSize[0], winSize[1]){
                private static final long serialVersionUID = 1L;

                public void onClick(AjaxRequestTarget target) {
                    RoleListPanel.this.aetroleWindow.setPageCreator(new ModalWindow.PageCreator(){
                        private static final long serialVersionUID = 1L;

                        public Page createPage() {
                            return new AETGroupAssignmentPage(RoleListPanel.this.aetroleWindow, role);
                        }
                    });
                    super.onClick(target);
                }
            }.add(new Component[]{new Image("rolelist.aetrole.image", ImageManager.IMAGE_USER_AET_PERMISSIONS).add(new IBehavior[]{new TooltipBehaviour("rolelist.", "aetrole-link", (IModel)new Model((Serializable)((Object)role.getRolename())))})}).setVisible(role.isAETRole()).add(new IBehavior[]{new SecurityBehavior(RoleListPanel.getModuleName() + ":aetroleLink")})});
            if (role.isAETRole()) {
                aetroleCell.add(new IBehavior[]{new AttributeAppender("style", (IModel)new Model((Serializable)((Object)("background-color: " + this.aetRoleColor))), " ")});
            }
            rowParent.add(new Component[]{aetroleCell});
            RepeatingView groupContentCells = new RepeatingView("group-content-cells");
            rowParent.add(new Component[]{groupContentCells});
            for (Group group : this.roleGroups) {
                if (group.getGroupname().equalsIgnoreCase("Web") || group.getGroupname().equalsIgnoreCase("Dicom") || group.getGroupname().equalsIgnoreCase("AET")) continue;
                CheckBox groupCheckbox = new CheckBox("group-checkbox");
                groupCheckbox.setEnabled(false);
                groupCheckbox.setModel((IModel)new Model((Serializable)Boolean.valueOf(role.getRoleGroups().contains(group.getUuid()))));
                WebMarkupContainer groupContentCell = new WebMarkupContainer(groupContentCells.newChildId());
                groupContentCells.add(new Component[]{groupContentCell.add(new Component[]{groupCheckbox})});
                if (!role.getRoleGroups().contains(group.getUuid())) continue;
                groupContentCell.add(new IBehavior[]{new AttributeAppender("style", (IModel)new Model((Serializable)((Object)("background-color: " + group.getColor()))), " ")});
            }
        }
    }

    private ArrayList<Role> getAllRoles() {
        ArrayList<Role> allRoles = new ArrayList<Role>(2);
        allRoles.addAll(this.userAccess.getAllRoles());
        return allRoles;
    }

    private Map<String, Group> getAllGroups() {
        HashMap<String, Group> groups = new HashMap<String, Group>();
        for (Group group : this.userAccess.getAllGroups()) {
            groups.put(group.getUuid(), group);
        }
        return groups;
    }

    public static String getModuleName() {
        return "rolelist";
    }
}

