/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.role;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.util.ListModel;
import org.apache.wicket.security.components.SecureWebPage;
import org.apache.wicket.validation.IValidator;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.model.Group;
import org.dcm4chee.usr.model.Role;
import org.dcm4chee.usr.ui.validator.RoleValidator;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketApplication;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.markup.BaseForm;
import org.dcm4chee.web.common.secure.SecurityBehavior;
import org.dcm4chee.web.common.util.Auditlog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateOrEditRolePage
extends SecureWebPage {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");
    private static Logger log = LoggerFactory.getLogger(CreateOrEditRolePage.class);
    protected ModalWindow window;

    public CreateOrEditRolePage(ModalWindow window, ListModel<Role> allRolenames, Role role, Map<String, Group> types) {
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.window = window;
        this.add(new Component[]{new CreateOrEditRoleForm("add-role-form", allRolenames, role, types)});
        this.add(new Component[]{new WebMarkupContainer("create-role-title").setVisible(role == null)});
        this.add(new Component[]{new WebMarkupContainer("edit-role-title").setVisible(role != null)});
    }

    public static String getModuleName() {
        return "roletypes";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CreateOrEditRoleForm
    extends BaseForm {
        private static final long serialVersionUID = 1L;
        private Model<String> rolename;
        private Model<String> description;
        private Model<Boolean> superuser;
        private TextField<String> rolenameTextField;
        private TextField<String> descriptionTextField;
        private List<CheckBox> groupCheckboxList;

        public CreateOrEditRoleForm(String id, final ListModel<Role> allRolenames, final Role role, Map<String, Group> types) {
            super(id);
            this.rolename = new Model();
            this.description = new Model();
            this.superuser = new Model();
            this.rolenameTextField = new TextField("rolelist.add-role-form.rolename.input", this.rolename);
            this.descriptionTextField = new TextField("rolelist.add-role-form.description.input", this.description);
            this.setOutputMarkupId(true);
            ((BaseWicketApplication)this.getApplication()).getInitParameter("UserAccessServiceName");
            final UserAccess userAccess = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
            List groups = userAccess.getAllGroups();
            this.add(new Component[]{this.rolenameTextField.setRequired(true).add((IValidator)new RoleValidator(allRolenames, role == null ? null : role.getRolename()))});
            this.add(new Component[]{this.descriptionTextField});
            final CheckBox superuserCheckbox = new CheckBox("superuser-checkbox", this.superuser);
            this.superuser.setObject((Serializable)Boolean.valueOf(role != null && role.isSuperuser()));
            if (role != null) {
                this.rolenameTextField.setModelObject((Object)role.getRolename());
                this.descriptionTextField.setModelObject((Object)role.getDescription());
                superuserCheckbox.setModelObject((Object)role.isSuperuser());
            }
            superuserCheckbox.add(new IBehavior[]{new SecurityBehavior(CreateOrEditRolePage.getModuleName() + ":superuserCheckbox")});
            this.add(new Component[]{superuserCheckbox});
            final StringBuffer webRoleUuid = new StringBuffer();
            final StringBuffer dicomRoleUuid = new StringBuffer();
            final StringBuffer aetRoleUuid = new StringBuffer();
            this.groupCheckboxList = new ArrayList<CheckBox>(groups.size());
            RepeatingView groupRows = new RepeatingView("group-rows");
            this.add(new Component[]{groupRows});
            for (Group group : groups) {
                Component[] componentArray = new Component[1];
                WebMarkupContainer rowParent = new WebMarkupContainer(groupRows.newChildId());
                componentArray[0] = rowParent;
                groupRows.add(componentArray);
                Component[] componentArray2 = new Component[1];
                CheckBox groupCheckbox = new CheckBox("group-checkbox", (IModel)new Model((Serializable)Boolean.valueOf(role != null ? (group.getGroupname().equals("Web") ? role.isWebRole() : (group.getGroupname().equals("Dicom") ? role.isDicomRole() : (group.getGroupname().equals("AET") ? role.isAETRole() : role.getRoleGroups().contains(group.getUuid())))) : false)));
                componentArray2[0] = groupCheckbox.setLabel((IModel)new Model((Serializable)((Object)group.getUuid()))).add(new IBehavior[]{new SecurityBehavior(CreateOrEditRolePage.getModuleName() + ":changeGroupAssignmentCheckbox")});
                rowParent.add(componentArray2);
                rowParent.add(new Component[]{new Label("groupname", (IModel)new Model((Serializable)((Object)group.getGroupname())))});
                this.groupCheckboxList.add(groupCheckbox);
                groupRows.add(new Component[]{rowParent});
                if (group.getGroupname().equals("Web")) {
                    webRoleUuid.append(group.getUuid());
                    continue;
                }
                if (group.getGroupname().equals("Dicom")) {
                    dicomRoleUuid.append(group.getUuid());
                    continue;
                }
                if (!group.getGroupname().equals("AET")) continue;
                aetRoleUuid.append(group.getUuid());
            }
            this.add(new Component[]{new AjaxFallbackButton("add-role-submit", (Form)this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    try {
                        ArrayList<String> groupList = new ArrayList<String>();
                        for (CheckBox checkbox : CreateOrEditRoleForm.this.groupCheckboxList) {
                            if (!((Boolean)checkbox.getModelObject()).booleanValue()) continue;
                            groupList.add((String)checkbox.getLabel().getObject());
                        }
                        HashSet<String> aetGroups = new HashSet<String>();
                        aetGroups.add("*");
                        if (role == null) {
                            Role newRole = new Role((String)((Object)CreateOrEditRoleForm.this.rolename.getObject()));
                            newRole.setDescription((String)((Object)CreateOrEditRoleForm.this.description.getObject()));
                            newRole.setSuperuser(((Boolean)superuserCheckbox.getModelObject()).booleanValue());
                            newRole.setRoleGroups(groupList);
                            newRole.setWebRole(groupList.contains(webRoleUuid.toString()));
                            newRole.setDicomRole(groupList.contains(dicomRoleUuid.toString()));
                            newRole.setAETRole(groupList.contains(aetRoleUuid.toString()));
                            if (newRole.isAETRole()) {
                                newRole.setAETGroups(aetGroups);
                            }
                            userAccess.addRole(newRole);
                            Auditlog.logSoftwareConfiguration((boolean)true, (String)("Role " + newRole + " created."));
                        } else {
                            this.getUpdateInfo(role, groupList, aetGroups);
                            role.setRolename((String)((Object)CreateOrEditRoleForm.this.rolename.getObject()));
                            role.setDescription((String)((Object)CreateOrEditRoleForm.this.description.getObject()));
                            role.setSuperuser(((Boolean)superuserCheckbox.getModelObject()).booleanValue());
                            role.setRoleGroups(groupList);
                            role.setWebRole(groupList.contains(webRoleUuid.toString()));
                            role.setDicomRole(groupList.contains(dicomRoleUuid.toString()));
                            role.setAETRole(groupList.contains(aetRoleUuid.toString()));
                            if (role.isAETRole() && (role.getAETGroups() == null || role.getAETGroups().size() == 0)) {
                                role.setAETGroups(aetGroups);
                            }
                            userAccess.updateRole(role);
                            Auditlog.logSoftwareConfiguration((boolean)true, (String)("Role " + role + " updated."));
                        }
                        allRolenames.setObject((Object)userAccess.getAllRoles());
                        CreateOrEditRolePage.this.window.close(target);
                    }
                    catch (Exception e) {
                        log.error(((Object)((Object)this)).getClass().toString() + ": " + "onSubmit: " + e.getMessage());
                        log.debug("Exception: ", (Throwable)e);
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.addComponent(form);
                }

                private String getUpdateInfo(Role role2, List<String> groupList, Set<String> aetGroups) {
                    StringBuilder sb = new StringBuilder("Role ").append(role2).append(" updated.");
                    boolean changed = Auditlog.addChange((StringBuilder)sb, (boolean)false, (String)"rolename", (Object)role2.getRolename(), (Object)CreateOrEditRoleForm.this.rolename.getObject());
                    Auditlog.addChange((StringBuilder)sb, (boolean)changed, (String)"description", (Object)role2.getDescription(), (Object)CreateOrEditRoleForm.this.description.getObject());
                    Auditlog.addChange((StringBuilder)sb, (boolean)changed, (String)"superuser", (Object)role2.isSuperuser(), (Object)superuserCheckbox.getModelObject());
                    Auditlog.addChange((StringBuilder)sb, (boolean)changed, (String)"WEB role", (Object)role2.isWebRole(), (Object)groupList.contains(webRoleUuid.toString()));
                    Auditlog.addChange((StringBuilder)sb, (boolean)changed, (String)"DICOM role", (Object)role2.isDicomRole(), (Object)groupList.contains(dicomRoleUuid.toString()));
                    Auditlog.addChange((StringBuilder)sb, (boolean)changed, (String)"AET role", (Object)role2.isAETRole(), (Object)groupList.contains(aetRoleUuid.toString()));
                    return sb.toString();
                }
            }});
        }
    }
}

