/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement.markup;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.IHeaderContributor;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorPicker
extends FormComponentPanel<String>
implements IHeaderContributor {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference ColorPickerCSS = new CompressedResourceReference(ColorPicker.class, "js_color_picker_v2.css");
    private TextField<String> colorTextField;
    private Button colorButton;
    private Model<String> colorValue = new Model();

    public ColorPicker(String id, Model<String> model) {
        super(id, model);
        if (ColorPickerCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)ColorPickerCSS)});
        }
        this.colorTextField = new TextField("colorTextField", this.colorValue);
        this.colorButton = new AjaxButton("colorButton"){
            private static final long serialVersionUID = 1L;

            protected String getOnClickScript() {
                return "showColorPicker(this,document.getElementById('colorTextField'))";
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
            }
        };
        this.colorTextField.setMarkupId("colorTextField");
        this.colorButton.add(new Component[]{new Image("colorButtonImage", new ResourceReference(ColorPicker.class, "images/color_swatch.png"))});
        this.colorButton.setDefaultFormProcessing(false);
        this.add(new Component[]{this.colorTextField});
        this.add(new Component[]{this.colorButton});
    }

    public void renderHead(IHeaderResponse response) {
        response.renderJavascriptReference(new ResourceReference(ColorPicker.class, "js_color_picker_v2.js"));
        response.renderJavascriptReference(new ResourceReference(ColorPicker.class, "color_functions.js"));
    }

    public String getColorValue() {
        return (String)((Object)this.colorValue.getObject());
    }

    public void setColorValue(String value) {
        this.colorValue.setObject((Serializable)((Object)value));
    }
}

