/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.usr.ui.usermanagement;

import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxFallbackButton;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.modal.ModalWindow;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.validation.EqualPasswordInputValidator;
import org.apache.wicket.markup.html.form.validation.IFormValidator;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.html.resources.CompressedResourceReference;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.dcm4chee.usr.dao.UserAccess;
import org.dcm4chee.usr.entity.User;
import org.dcm4chee.usr.ui.validator.PasswordValidator;
import org.dcm4chee.usr.util.JNDIUtils;
import org.dcm4chee.web.common.base.BaseWicketPage;
import org.dcm4chee.web.common.markup.BaseForm;
import org.dcm4chee.web.common.secure.SecureSession;
import org.dcm4chee.web.common.util.Auditlog;
import org.dcm4chee.web.common.util.SecurityUtils;

public class ChangePasswordPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference BaseCSS = new CompressedResourceReference(BaseWicketPage.class, "base-style.css");

    public ChangePasswordPanel(String id) {
        this(id, ((SecureSession)RequestCycle.get().getSession()).getUsername(), null, null);
    }

    public ChangePasswordPanel(String id, String userId, User forUser, ModalWindow window) {
        super(id);
        if (BaseCSS != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)BaseCSS)});
        }
        this.add(new Component[]{new ChangePasswordForm("change-password-form", userId, forUser, (Model<String>)new Model(), (Model<String>)new Model(), window)});
    }

    public static String getModuleName() {
        return "change_password";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ChangePasswordForm
    extends BaseForm {
        private static final long serialVersionUID = 1L;
        private User userToChange;
        private Label resultLabel;

        public ChangePasswordForm(String id, String userId, User forUser, Model<String> oldPassword, final Model<String> newPassword, final ModalWindow window) {
            super(id);
            User user = this.userToChange = forUser == null ? ((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).getUser(userId) : forUser;
            if (this.userToChange == null) {
                this.userToChange = ((UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local")).getUserIgnoreCase(userId);
            }
            WebMarkupContainer oldPasswordLabel = new WebMarkupContainer("old-password-label");
            this.add(new Component[]{oldPasswordLabel});
            final PasswordTextField oldPasswordTf = new PasswordTextField("change_password.old_password.input", oldPassword);
            this.add(new Component[]{oldPasswordTf});
            Label forUserLabel = new Label("for-user-label", this.userToChange.getUserID());
            this.add(new Component[]{forUserLabel});
            if (this.userToChange.getUserID().equals(userId)) {
                forUserLabel.setVisible(false);
                this.add((IFormValidator)new PasswordValidator(this.userToChange, (FormComponent<?>)oldPasswordTf));
            } else {
                oldPasswordLabel.setVisible(false);
                oldPasswordTf.setVisible(false);
            }
            final PasswordTextField newPasswordTf1 = new PasswordTextField("change_password.new_password_1.input", newPassword);
            this.add(new Component[]{newPasswordTf1});
            final PasswordTextField newPasswordTf2 = new PasswordTextField("change_password.new_password_2.input", (IModel)new Model((Serializable)((Object)"")));
            this.add(new Component[]{newPasswordTf2});
            this.add((IFormValidator)new EqualPasswordInputValidator((FormComponent)newPasswordTf1, (FormComponent)newPasswordTf2));
            this.add(new Component[]{new AjaxFallbackButton("change-password-submit", (Form)this){
                private static final long serialVersionUID = 1L;

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    UserAccess dao = (UserAccess)JNDIUtils.lookup((String)"dcm4chee-usr-dao/UserAccess/local");
                    String encodedPassword = SecurityUtils.encodePassword((String)((String)((Object)newPassword.getObject())));
                    dao.updateUser(ChangePasswordForm.this.userToChange.getUserID(), encodedPassword);
                    Auditlog.logSoftwareConfiguration((boolean)true, (String)("User " + ChangePasswordForm.this.userToChange.getUserID() + ": password changed."));
                    ChangePasswordForm.this.userToChange.setPassword(encodedPassword);
                    if (window != null) {
                        window.close(target);
                    } else {
                        ChangePasswordForm.this.resultLabel.setVisible(true);
                        target.addComponent((Component)ChangePasswordForm.this.resultLabel);
                        oldPasswordTf.removeAll();
                        newPasswordTf1.removeAll();
                        newPasswordTf2.removeAll();
                        target.addComponent((Component)oldPasswordTf);
                        target.addComponent((Component)newPasswordTf1);
                        target.addComponent((Component)newPasswordTf2);
                    }
                }

                protected void onError(AjaxRequestTarget target, Form<?> form) {
                    target.addComponent(form);
                }
            }});
            Component[] componentArray = new Component[1];
            this.resultLabel = new Label("resultLabel", (IModel)new ResourceModel("change_password.result.success"));
            componentArray[0] = this.resultLabel.setVisible(false).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true);
            this.add(componentArray);
        }
    }
}

