/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.local;

import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.local.LocalManagedConnection;
import org.jboss.resource.adapter.jdbc.local.LocalManagedConnectionFactory;
import org.jboss.util.JBossStringBuilder;

public class HALocalManagedConnectionFactory
extends LocalManagedConnectionFactory {
    private static final long serialVersionUID = -6506610639011749394L;
    private URLSelector urlSelector;
    private String urlDelimiter;

    public String getURLDelimiter() {
        return this.urlDelimiter;
    }

    public void setURLDelimiter(String urlDelimiter) {
        this.urlDelimiter = urlDelimiter;
        if (this.getConnectionURL() != null) {
            this.initUrlSelector();
        }
    }

    public void setConnectionURL(String connectionURL) {
        super.setConnectionURL(connectionURL);
        if (this.urlDelimiter != null) {
            this.initUrlSelector();
        }
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        boolean trace = this.log.isTraceEnabled();
        Properties props = this.getConnectionProperties(subject, cri);
        Properties copy = (Properties)props.clone();
        if (trace) {
            Properties logCopy = copy;
            if (copy.getProperty("password") != null) {
                logCopy = (Properties)props.clone();
                logCopy.setProperty("password", "--hidden--");
            }
            this.log.trace((Object)("Using properties: " + logCopy));
        }
        return this.doCreateManagedConnection(copy, props);
    }

    private ManagedConnection doCreateManagedConnection(Properties copy, Properties props) throws JBossResourceException {
        boolean trace = this.log.isTraceEnabled();
        if (this.urlSelector == null) {
            JBossStringBuilder buffer = new JBossStringBuilder();
            buffer.append("Missing configuration for HA local datasource. ");
            if (this.getConnectionURL() == null) {
                buffer.append("No connection-url. ");
            }
            if (this.urlDelimiter == null) {
                buffer.append("No url-delimiter. ");
            }
            throw new JBossResourceException(buffer.toString());
        }
        for (int i = 0; i < this.urlSelector.getUrlList().size(); ++i) {
            String url = this.urlSelector.getUrl();
            if (trace) {
                this.log.trace((Object)("Trying to create a connection to " + url));
            }
            Connection con = null;
            try {
                Driver d = this.getDriver(url);
                con = d.connect(url, copy);
                if (con != null) {
                    return new LocalManagedConnection((LocalManagedConnectionFactory)this, con, props, this.transactionIsolation, this.preparedStatementCacheSize);
                }
                this.log.warn((Object)("Wrong driver class for this connection URL: " + url));
                this.urlSelector.failedUrl(url);
                continue;
            }
            catch (Exception e) {
                if (con != null) {
                    try {
                        con.close();
                    }
                    catch (Throwable ignored) {
                        // empty catch block
                    }
                }
                this.log.warn((Object)("Failed to create connection for " + url + ": " + e.getMessage()));
                this.urlSelector.failedUrl(url);
            }
        }
        throw new JBossResourceException("Could not create connection using any of the URLs: " + this.urlSelector.getUrlList());
    }

    private void initUrlSelector() {
        String url;
        boolean trace = this.log.isTraceEnabled();
        ArrayList<String> urlsList = new ArrayList<String>();
        String urlsStr = this.getConnectionURL();
        int urlStart = 0;
        int urlEnd = urlsStr.indexOf(this.urlDelimiter);
        while (urlEnd > 0) {
            url = urlsStr.substring(urlStart, urlEnd);
            urlsList.add(url);
            urlStart = ++urlEnd;
            urlEnd = urlsStr.indexOf(this.urlDelimiter, urlEnd);
            if (!trace) continue;
            this.log.trace((Object)("added HA connection url: " + url));
        }
        if (urlStart != urlsStr.length()) {
            url = urlsStr.substring(urlStart, urlsStr.length());
            urlsList.add(url);
            if (trace) {
                this.log.trace((Object)("added HA connection url: " + url));
            }
        }
        this.urlSelector = new URLSelector(urlsList);
    }

    public static class URLSelector {
        private final List urls;
        private int urlIndex;
        private String url;

        public URLSelector(List urls) {
            if (urls == null || urls.size() == 0) {
                throw new IllegalStateException("Expected non-empty list of connection URLs but got: " + urls);
            }
            this.urls = Collections.unmodifiableList(urls);
        }

        public synchronized String getUrl() {
            if (this.url == null) {
                if (this.urlIndex == this.urls.size()) {
                    this.urlIndex = 0;
                }
                this.url = (String)this.urls.get(this.urlIndex++);
            }
            return this.url;
        }

        public synchronized void failedUrl(String url) {
            if (url.equals(this.url)) {
                this.url = null;
            }
        }

        public List getUrlList() {
            return this.urls;
        }
    }
}

