/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.strategies;

import java.io.Serializable;
import java.util.Map;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.Action;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.model.IModel;
import org.apache.wicket.security.WaspApplication;
import org.apache.wicket.security.WaspSession;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.actions.WaspActionFactory;
import org.apache.wicket.security.authentication.LoginException;
import org.apache.wicket.security.checks.ISecurityCheck;
import org.apache.wicket.security.components.ISecureComponent;
import org.apache.wicket.security.components.SecureComponentHelper;
import org.apache.wicket.security.log.AuthorizationErrorKey;
import org.apache.wicket.security.log.AuthorizationMessageSource;
import org.apache.wicket.security.log.IAuthorizationMessageSource;
import org.apache.wicket.security.models.ISecureModel;
import org.apache.wicket.security.strategies.StrategyResolver;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WaspAuthorizationStrategy
implements IAuthorizationStrategy,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(WaspAuthorizationStrategy.class);
    protected static final AuthorizationErrorKey MESSAGE_KEY = new AuthorizationErrorKey();
    private static final ThreadLocal resolver = new ThreadLocal();

    public abstract boolean isComponentAuthorized(Component var1, WaspAction var2);

    public abstract boolean isModelAuthorized(ISecureModel<?> var1, Component var2, WaspAction var3);

    public abstract boolean isClassAuthorized(Class<?> var1, WaspAction var2);

    public abstract boolean isComponentAuthenticated(Component var1);

    public abstract boolean isModelAuthenticated(IModel<?> var1, Component var2);

    public abstract boolean isClassAuthenticated(Class<?> var1);

    public abstract boolean isUserAuthenticated();

    public abstract void login(Object var1) throws LoginException;

    public abstract boolean logoff(Object var1);

    public abstract void destroy();

    public boolean isActionAuthorized(Component component, Action action) {
        if (component != null) {
            ISecurityCheck check = this.getSecurityCheck(component);
            if (check != null) {
                if (check.isActionAuthorized(this.getActionFactory().getAction(action))) {
                    return true;
                }
                IAuthorizationMessageSource message = this.getMessageSource();
                if (message != null) {
                    message.setComponent(component);
                    message.addVariable("wicket.action", action);
                    message.addVariable("wasp.action", this.getActionFactory().getAction(action));
                    this.logMessage(message);
                }
                return false;
            }
            IModel model = component.getDefaultModel();
            if (model instanceof ISecureModel) {
                if (((ISecureModel)model).isAuthorized(component, this.getActionFactory().getAction(action))) {
                    return true;
                }
                IAuthorizationMessageSource message = this.getMessageSource();
                if (message != null) {
                    message.setComponent(component);
                    message.addVariable("wicket.action", action);
                    message.addVariable("wasp.action", this.getActionFactory().getAction(action));
                    this.logMessage(message);
                }
                return false;
            }
        }
        return true;
    }

    protected final void logMessage(IAuthorizationMessageSource message) {
        this.logMessage("authorization.denied", null, message, true);
    }

    protected final void logMessage(String key, Map<String, Object> variables, IAuthorizationMessageSource message, boolean remove) {
        if (message == null || Strings.isEmpty((CharSequence)key)) {
            if (remove) {
                this.removeMessageSource();
            }
            return;
        }
        this.logMessage(key, variables, message);
        if (remove) {
            this.removeMessageSource();
        }
    }

    protected void logMessage(String key, Map<String, Object> variables, IAuthorizationMessageSource message) {
        String msg = message.getMessage(key);
        if (!Strings.isEmpty((CharSequence)msg)) {
            log.debug(message.substitute(msg, variables));
        }
    }

    protected final void removeMessageSource() {
        RequestCycle.get().setMetaData((MetaDataKey)MESSAGE_KEY, null);
    }

    protected final IAuthorizationMessageSource getMessageSource() {
        return this.getMessageSource(false);
    }

    protected final IAuthorizationMessageSource getMessageSource(boolean create) {
        IAuthorizationMessageSource resource = null;
        if (RequestCycle.get() != null) {
            resource = (IAuthorizationMessageSource)RequestCycle.get().getMetaData((MetaDataKey)MESSAGE_KEY);
        }
        if (resource == null && create) {
            resource = this.createMessageSource();
            RequestCycle.get().setMetaData((MetaDataKey)MESSAGE_KEY, (Object)resource);
        }
        return resource;
    }

    protected IAuthorizationMessageSource createMessageSource() {
        return new AuthorizationMessageSource();
    }

    protected boolean logMessages() {
        return log.isDebugEnabled();
    }

    protected final ISecurityCheck getSecurityCheck(Component component) {
        if (component instanceof ISecureComponent) {
            return ((ISecureComponent)component).getSecurityCheck();
        }
        return SecureComponentHelper.getSecurityCheck(component);
    }

    protected final WaspActionFactory getActionFactory() {
        return ((WaspApplication)Application.get()).getActionFactory();
    }

    public static WaspAuthorizationStrategy get() {
        StrategyResolver threadResolver = (StrategyResolver)resolver.get();
        return threadResolver == null ? (WaspAuthorizationStrategy)((WaspSession)Session.get()).getAuthorizationStrategy() : threadResolver.getStrategy();
    }

    public static void setStrategyResolver(StrategyResolver threadResolver) {
        resolver.set(threadResolver);
    }
}

