/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.components;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.security.WaspApplication;
import org.apache.wicket.security.WaspSession;
import org.apache.wicket.security.actions.ActionFactory;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.ISecurityCheck;
import org.apache.wicket.security.checks.WaspKey;
import org.apache.wicket.security.components.ISecureComponent;
import org.apache.wicket.security.models.ISecureModel;
import org.apache.wicket.security.strategies.SecurityException;
import org.apache.wicket.security.strategies.WaspAuthorizationStrategy;
import org.apache.wicket.util.string.PrependingStringBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SecureComponentHelper {
    public static final String PATH_SEPARATOR = ":";

    public static ISecurityCheck getSecurityCheck(Component component) {
        if (component != null) {
            return (ISecurityCheck)component.getMetaData((MetaDataKey)new WaspKey());
        }
        return null;
    }

    public static Component setSecurityCheck(Component component, ISecurityCheck securityCheck) {
        if (component == null) {
            return null;
        }
        component.setMetaData((MetaDataKey)new WaspKey(), (Object)securityCheck);
        return component;
    }

    private static ISecurityCheck saveGetSecurityCheck(Component component) {
        if (component instanceof ISecureComponent) {
            return ((ISecureComponent)component).getSecurityCheck();
        }
        return SecureComponentHelper.getSecurityCheck(component);
    }

    public static boolean hasSecureModel(Component component) {
        return component != null && component.getDefaultModel() instanceof ISecureModel;
    }

    private static ActionFactory getActionFactory() {
        Application application = Application.get();
        if (application instanceof WaspApplication) {
            WaspApplication app = (WaspApplication)application;
            return app.getActionFactory();
        }
        throw new WicketRuntimeException(application + " is not a " + WaspApplication.class);
    }

    private static WaspAuthorizationStrategy getStrategy() {
        Session session = Session.get();
        if (session instanceof WaspSession) {
            return (WaspAuthorizationStrategy)session.getAuthorizationStrategy();
        }
        throw new WicketRuntimeException(session + " is not a " + WaspSession.class);
    }

    public static boolean isActionAuthorized(Component component, String action) {
        if (action == null) {
            return true;
        }
        ISecurityCheck check = SecureComponentHelper.saveGetSecurityCheck(component);
        if (check != null) {
            return check.isActionAuthorized(SecureComponentHelper.getActionFactory().getAction(action));
        }
        if (SecureComponentHelper.hasSecureModel(component)) {
            return ((ISecureModel)component.getDefaultModel()).isAuthorized(component, SecureComponentHelper.getActionFactory().getAction(action));
        }
        return true;
    }

    public static boolean isActionAuthorized(Component component, WaspAction action) {
        if (action == null) {
            return true;
        }
        ISecurityCheck check = SecureComponentHelper.saveGetSecurityCheck(component);
        if (check != null) {
            return check.isActionAuthorized(action);
        }
        if (SecureComponentHelper.hasSecureModel(component)) {
            return ((ISecureModel)component.getDefaultModel()).isAuthorized(component, action);
        }
        return true;
    }

    public static boolean isAuthenticated(Component component) {
        ISecurityCheck check = SecureComponentHelper.saveGetSecurityCheck(component);
        if (check != null) {
            return check.isAuthenticated();
        }
        if (SecureComponentHelper.hasSecureModel(component)) {
            return ((ISecureModel)component.getDefaultModel()).isAuthenticated(component);
        }
        return SecureComponentHelper.getStrategy().isUserAuthenticated();
    }

    public static String alias(Component component) {
        if (component == null) {
            throw new SecurityException("Specified component is null");
        }
        Page page = null;
        try {
            page = component.getPage();
        }
        catch (IllegalStateException e) {
            throw new SecurityException("Unable to create alias for component: " + component, e);
        }
        String alias = SecureComponentHelper.alias(page.getClass());
        String relative = component.getPageRelativePath();
        if (relative == null || "".equals(relative)) {
            return alias;
        }
        return alias + PATH_SEPARATOR + relative;
    }

    public static String alias(Class<?> class1) {
        if (class1 == null) {
            throw new SecurityException("Specified class is null");
        }
        return class1.getName();
    }

    public static String containerAlias(MarkupContainer container) {
        if (container == null) {
            throw new SecurityException("specified markupcontainer is null");
        }
        PrependingStringBuffer buffer = new PrependingStringBuffer(150);
        for (MarkupContainer parent = container; parent != null; parent = parent.getParent()) {
            if (buffer.length() > 0) {
                buffer.prepend(PATH_SEPARATOR);
            }
            buffer.prepend(parent.getClass().getName());
        }
        return buffer.toString();
    }

    public static String[] containerAliasses(Component component) {
        if (component == null) {
            throw new SecurityException("specified component is null");
        }
        MarkupContainer parent = null;
        parent = component instanceof MarkupContainer ? (MarkupContainer)component : component.getParent();
        if (parent == null) {
            return new String[0];
        }
        String alias = SecureComponentHelper.containerAlias(parent);
        String[] split = alias.split(PATH_SEPARATOR);
        String[] result = new String[split.length + (split.length - 1)];
        PrependingStringBuffer buffer = new PrependingStringBuffer(200);
        int index = result.length - 1;
        for (int i = split.length - 1; i >= 0; --i) {
            if (i < split.length - 1) {
                result[index] = split[i];
                --index;
                buffer.prepend(PATH_SEPARATOR);
            }
            buffer.prepend(split[i]);
            result[index] = buffer.toString();
            --index;
        }
        return result;
    }
}

