/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.checks;

import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.AbstractSecurityCheck;
import org.apache.wicket.security.checks.ISecurityCheck;

public class SecurityChecks {
    public static ISecurityCheck and(ISecurityCheck[] checks) {
        return new AndSecurityCheck(checks);
    }

    public static ISecurityCheck and(ISecurityCheck check1, ISecurityCheck check2) {
        return new AndSecurityCheck(new ISecurityCheck[]{check1, check2});
    }

    public static ISecurityCheck or(ISecurityCheck[] checks) {
        return new OrSecurityCheck(checks);
    }

    public static ISecurityCheck or(ISecurityCheck check1, ISecurityCheck check2) {
        return new OrSecurityCheck(new ISecurityCheck[]{check1, check2});
    }

    private static class OrSecurityCheck
    extends AbstractSecurityCheck {
        private static final long serialVersionUID = 1L;
        private ISecurityCheck[] checks;

        private OrSecurityCheck(ISecurityCheck[] checks) {
            this.checks = checks;
            if (checks == null) {
                this.checks = new ISecurityCheck[0];
            }
        }

        public boolean isActionAuthorized(WaspAction action) {
            if (this.checks.length == 0) {
                return true;
            }
            boolean containsChecks = false;
            for (int i = 0; i < this.checks.length; ++i) {
                ISecurityCheck check = this.checks[i];
                if (check == null) continue;
                containsChecks = true;
                if (!check.isActionAuthorized(action)) continue;
                return true;
            }
            return !containsChecks;
        }

        public boolean isAuthenticated() {
            if (this.checks.length == 0) {
                return true;
            }
            boolean containsChecks = false;
            for (int i = 0; i < this.checks.length; ++i) {
                ISecurityCheck check = this.checks[i];
                if (check == null) continue;
                containsChecks = true;
                if (!check.isAuthenticated()) continue;
                return true;
            }
            return !containsChecks;
        }
    }

    private static class AndSecurityCheck
    extends AbstractSecurityCheck {
        private static final long serialVersionUID = 1L;
        private ISecurityCheck[] checks;

        private AndSecurityCheck(ISecurityCheck[] checks) {
            this.checks = checks;
            if (checks == null) {
                this.checks = new ISecurityCheck[0];
            }
        }

        public boolean isActionAuthorized(WaspAction action) {
            for (int i = 0; i < this.checks.length; ++i) {
                ISecurityCheck check = this.checks[i];
                if (check == null || check.isActionAuthorized(action)) continue;
                return false;
            }
            return true;
        }

        public boolean isAuthenticated() {
            for (int i = 0; i < this.checks.length; ++i) {
                ISecurityCheck check = this.checks[i];
                if (check == null || check.isAuthenticated()) continue;
                return false;
            }
            return true;
        }
    }
}

