/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.checks;

import org.apache.wicket.Component;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.security.actions.Enable;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.ComponentSecurityCheck;
import org.apache.wicket.security.components.SecureComponentHelper;
import org.apache.wicket.security.models.ISecureModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkSecurityCheck
extends ComponentSecurityCheck {
    private static final long serialVersionUID = 1L;
    private final Class<?> clickTarget;
    private boolean useAlternativeRenderCheck = false;

    public LinkSecurityCheck(Component component, Class<?> clickTarget) {
        super(component);
        this.clickTarget = clickTarget;
        if (clickTarget == null) {
            throw new IllegalArgumentException("A clickTarget is mandatory.");
        }
    }

    public LinkSecurityCheck(AbstractLink component, Class<?> clickTarget, boolean checkSecureModelIfExists) {
        super((Component)component, checkSecureModelIfExists);
        this.clickTarget = clickTarget;
        if (clickTarget == null) {
            throw new IllegalArgumentException("A clickTarget is mandatory.");
        }
    }

    public final Class<?> getClickTarget() {
        return this.clickTarget;
    }

    @Override
    public boolean isActionAuthorized(WaspAction action) {
        if (this.isUseAlternativeRenderCheck() && !action.implies(this.getActionFactory().getAction(Enable.class))) {
            return super.isActionAuthorized(action);
        }
        boolean result = this.getStrategy().isClassAuthorized(this.getClickTarget(), action);
        if (result && this.checkSecureModel() && SecureComponentHelper.hasSecureModel(this.getComponent())) {
            return ((ISecureModel)this.getComponent().getDefaultModel()).isAuthorized(this.getComponent(), action);
        }
        return result;
    }

    public final boolean isUseAlternativeRenderCheck() {
        return this.useAlternativeRenderCheck;
    }

    public final LinkSecurityCheck setUseAlternativeRenderCheck(boolean useAlternativeRenderCheck) {
        this.useAlternativeRenderCheck = useAlternativeRenderCheck;
        return this;
    }
}

