/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.checks;

import org.apache.wicket.Component;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.AbstractSecurityCheck;
import org.apache.wicket.security.components.SecureComponentHelper;
import org.apache.wicket.security.models.ISecureModel;

public class ComponentSecurityCheck
extends AbstractSecurityCheck {
    private static final long serialVersionUID = 1L;
    private Component component;
    private boolean checkModel;

    public ComponentSecurityCheck(Component component) {
        this(component, false);
    }

    public ComponentSecurityCheck(Component component, boolean checkSecureModelIfExists) {
        this.checkModel = checkSecureModelIfExists;
        if (component == null) {
            throw new IllegalArgumentException("component must be specified.");
        }
        this.component = component;
    }

    public boolean isAuthenticated() {
        boolean result = this.getStrategy().isComponentAuthenticated(this.getComponent());
        if (result && this.checkSecureModel() && SecureComponentHelper.hasSecureModel(this.getComponent())) {
            return ((ISecureModel)this.getComponent().getDefaultModel()).isAuthenticated(this.getComponent());
        }
        return result;
    }

    protected final Component getComponent() {
        return this.component;
    }

    public boolean isActionAuthorized(WaspAction action) {
        if (!this.isAuthenticated()) {
            throw new RestartResponseAtInterceptPageException(this.getLoginPage());
        }
        boolean result = this.getStrategy().isComponentAuthorized(this.getComponent(), action);
        if (result && this.checkSecureModel() && SecureComponentHelper.hasSecureModel(this.getComponent())) {
            return ((ISecureModel)this.getComponent().getDefaultModel()).isAuthorized(this.getComponent(), action);
        }
        return result;
    }

    protected final boolean checkSecureModel() {
        return this.checkModel;
    }
}

