/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security.checks;

import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.security.actions.WaspAction;
import org.apache.wicket.security.checks.AbstractSecurityCheck;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassSecurityCheck
extends AbstractSecurityCheck {
    private static final long serialVersionUID = 1L;
    private Class<?> clazz;

    public ClassSecurityCheck(Class<?> clazz) {
        this.clazz = clazz;
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    @Override
    public boolean isActionAuthorized(WaspAction action) {
        if (this.getClazz() == this.getLoginPage()) {
            return true;
        }
        if (this.isAuthenticated()) {
            return this.getStrategy().isClassAuthorized(this.getClazz(), action);
        }
        throw new RestartResponseAtInterceptPageException(this.getLoginPage());
    }

    @Override
    public boolean isAuthenticated() {
        return this.getStrategy().isClassAuthenticated(this.getClazz());
    }
}

