/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security;

import org.apache.wicket.Page;
import org.apache.wicket.Request;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Response;
import org.apache.wicket.Session;
import org.apache.wicket.authorization.AuthorizationException;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebRequest;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.security.WaspApplication;
import org.apache.wicket.security.WaspSession;
import org.apache.wicket.security.actions.WaspActionFactory;
import org.apache.wicket.security.strategies.StrategyFactory;

public abstract class WaspWebApplication
extends WebApplication
implements WaspApplication {
    private static final long serialVersionUID = 1L;

    protected void init() {
        this.setupActionFactory();
        this.setupStrategyFactory();
    }

    public Session newSession(Request request, Response response) {
        return new WaspSession(this, request);
    }

    protected abstract void setupStrategyFactory();

    protected abstract void setupActionFactory();

    protected void onDestroy() {
        WaspActionFactory factory2;
        StrategyFactory factory = this.getStrategyFactory();
        if (factory != null) {
            factory.destroy();
        }
        if ((factory2 = this.getActionFactory()) != null) {
            factory2.destroy();
        }
    }

    public RequestCycle newRequestCycle(Request request, Response response) {
        return new WebRequestCycle(this, (WebRequest)request, (Response)((WebResponse)response)){

            public Page onRuntimeException(Page page, RuntimeException e) {
                try {
                    if (e instanceof AuthorizationException) {
                        return (Page)WaspWebApplication.this.getApplicationSettings().getAccessDeniedPage().newInstance();
                    }
                    for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
                        if (!(t instanceof AuthorizationException)) continue;
                        try {
                            return (Page)WaspWebApplication.this.getApplicationSettings().getAccessDeniedPage().newInstance();
                        }
                        catch (InstantiationException e1) {
                            super.onRuntimeException(page, new RuntimeException("Exception while creating access denied page", e1));
                            continue;
                        }
                        catch (IllegalAccessException e1) {
                            super.onRuntimeException(page, new RuntimeException("Exception while creating access denied page", e1));
                        }
                    }
                }
                catch (InstantiationException e1) {
                    super.onRuntimeException(page, new RuntimeException("Exception while creating access denied page", e1));
                }
                catch (IllegalAccessException e1) {
                    super.onRuntimeException(page, new RuntimeException("Exception while creating access denied page", e1));
                }
                return super.onRuntimeException(page, e);
            }
        };
    }
}

