/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.security;

import org.apache.wicket.Request;
import org.apache.wicket.authorization.IAuthorizationStrategy;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.security.WaspApplication;
import org.apache.wicket.security.authentication.LoginException;
import org.apache.wicket.security.strategies.WaspAuthorizationStrategy;

public class WaspSession
extends WebSession {
    private static final long serialVersionUID = 1L;
    private WaspAuthorizationStrategy securityStrategy;

    public WaspSession(WaspApplication application, Request request) {
        super(request);
        this.securityStrategy = application.getStrategyFactory().newStrategy();
    }

    public IAuthorizationStrategy getAuthorizationStrategy() {
        return this.securityStrategy;
    }

    public void login(Object context) throws LoginException {
        this.securityStrategy.login(context);
        if (this.isTemporary()) {
            this.bind();
        } else {
            this.dirty();
        }
    }

    public boolean logoff(Object context) {
        if (this.securityStrategy != null && this.securityStrategy.logoff(context)) {
            if (this.securityStrategy.isUserAuthenticated()) {
                this.dirty();
            } else {
                this.invalidateNow();
            }
            return true;
        }
        return false;
    }

    public boolean isUserAuthenticated() {
        return this.securityStrategy.isUserAuthenticated();
    }

    public void invalidateNow() {
        this.securityStrategy.destroy();
        super.invalidateNow();
    }

    protected void detach() {
        if (this.isTemporary() && this.securityStrategy.isUserAuthenticated()) {
            this.bind();
        }
        super.detach();
    }
}

