/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4che2.soundex;

import org.dcm4che2.soundex.FuzzyStr;

public class Soundex
implements FuzzyStr {
    private final boolean encodeFirst;
    private final int codeLength;
    private final int padLength;

    public Soundex() {
        this(false, 4, 4);
    }

    public Soundex(boolean encodeFirst, int codeLength, int padLength) {
        this.encodeFirst = encodeFirst;
        this.codeLength = codeLength;
        this.padLength = padLength;
    }

    public String toFuzzy(String s) {
        if (s == null || s.length() == 0) {
            return "";
        }
        char[] in = s.toUpperCase().toCharArray();
        char[] out = in.length < this.padLength ? new char[this.padLength] : in;
        int i = 0;
        int j = 0;
        if (!this.encodeFirst) {
            while (!Character.isLetter(in[i])) {
                if (++i < in.length) continue;
                return "";
            }
            out[j++] = in[i++];
        }
        int prevout = 0;
        int curout = 0;
        while (i < in.length && j < this.codeLength) {
            block15: {
                switch (in[i]) {
                    case 'A': 
                    case 'E': 
                    case 'H': 
                    case 'I': 
                    case 'O': 
                    case 'U': 
                    case 'W': 
                    case 'Y': 
                    case '\u00c0': 
                    case '\u00c1': 
                    case '\u00c2': 
                    case '\u00c3': 
                    case '\u00c4': 
                    case '\u00c5': 
                    case '\u00c6': 
                    case '\u00c8': 
                    case '\u00c9': 
                    case '\u00ca': 
                    case '\u00cb': 
                    case '\u00cc': 
                    case '\u00cd': 
                    case '\u00ce': 
                    case '\u00cf': 
                    case '\u00d2': 
                    case '\u00d3': 
                    case '\u00d4': 
                    case '\u00d5': 
                    case '\u00d6': 
                    case '\u00d8': 
                    case '\u00d9': 
                    case '\u00da': 
                    case '\u00db': 
                    case '\u00dc': 
                    case '\u00dd': {
                        prevout = 48;
                        break block15;
                    }
                    case 'B': 
                    case 'F': 
                    case 'P': 
                    case 'V': {
                        curout = 49;
                        break;
                    }
                    case 'C': 
                    case 'G': 
                    case 'J': 
                    case 'K': 
                    case 'Q': 
                    case 'S': 
                    case 'X': 
                    case 'Z': 
                    case '\u00c7': 
                    case '\u00df': {
                        curout = 50;
                        break;
                    }
                    case 'D': 
                    case 'T': {
                        curout = 51;
                        break;
                    }
                    case 'L': {
                        curout = 52;
                        break;
                    }
                    case 'M': 
                    case 'N': {
                        curout = 53;
                        break;
                    }
                    case 'R': {
                        curout = 54;
                        break;
                    }
                    default: {
                        break block15;
                    }
                }
                if (prevout != curout) {
                    out[j++] = prevout = curout;
                }
            }
            ++i;
        }
        while (j < this.padLength) {
            out[j++] = 48;
        }
        return new String(out, 0, j);
    }

    public static void main(String[] args) {
        Soundex inst = new Soundex();
        for (String arg : args) {
            System.out.println(inst.toFuzzy(arg));
        }
    }
}

