/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.JChannel;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.protocols.TP;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.util.Util;

public class MessageBundlingTest
extends TestCase {
    private JChannel ch1;
    private JChannel ch2;
    private MyReceiver r2;
    private static final long LATENCY = 30L;
    private static final boolean BUNDLING = true;

    public void setUp() throws Exception {
        super.setUp();
        this.ch1 = new JChannel("udp.xml");
        this.setBundling(this.ch1, true, 64000, 30L);
        this.ch1.setReceiver(new NullReceiver());
        this.ch1.connect("x");
        this.ch2 = new JChannel("udp.xml");
        this.setBundling(this.ch2, true, 64000, 30L);
        this.r2 = new MyReceiver();
        this.ch2.setReceiver(this.r2);
        this.ch2.connect("x");
    }

    public void tearDown() throws Exception {
        this.closeChannel(this.ch2);
        this.closeChannel(this.ch1);
        super.tearDown();
    }

    protected boolean useBlocking() {
        return false;
    }

    public void testLatencyWithoutMessageBundling() throws ChannelClosedException, ChannelNotConnectedException {
        Message tmp = new Message();
        this.setBundling(this.ch1, false, 20000, 30L);
        long time = System.currentTimeMillis();
        this.ch1.send(tmp);
        System.out.println("sent message at " + new Date());
        Util.sleep(40L);
        List list = this.r2.getTimes();
        MessageBundlingTest.assertEquals((int)1, (int)list.size());
        Long time2 = (Long)list.get(0);
        long diff = time2 - time;
        System.out.println("latency=" + diff + " ms");
        MessageBundlingTest.assertTrue((String)("latency (" + diff + "ms) should be less than the bundling timeout"), (diff < 30L ? 1 : 0) != 0);
    }

    public void testLatencyWithMessageBundling() throws ChannelClosedException, ChannelNotConnectedException {
        Message tmp = new Message();
        long time = System.currentTimeMillis();
        this.ch1.send(tmp);
        System.out.println("sent message at " + new Date());
        Util.sleep(40L);
        List list = this.r2.getTimes();
        MessageBundlingTest.assertEquals((int)1, (int)list.size());
        Long time2 = (Long)list.get(0);
        long diff = time2 - time;
        System.out.println("latency=" + diff + " ms");
        MessageBundlingTest.assertTrue((String)("latency (" + diff + "ms) should be more than the bundling timeout (" + 30L + "ms), but less than 2 times the LATENCY (" + 60L + ")"), (diff > 30L && diff < 60L ? 1 : 0) != 0);
    }

    private void setBundling(JChannel ch, boolean enabled, int max_bytes, long timeout) {
        ProtocolStack stack = ch.getProtocolStack();
        Vector prots = stack.getProtocols();
        TP transport = (TP)prots.lastElement();
        transport.setEnableBundling(enabled);
        transport.setMaxBundleSize(max_bytes);
        transport.setMaxBundleTimeout(timeout);
    }

    private void closeChannel(Channel c) {
        if (c != null && (c.isOpen() || c.isConnected())) {
            c.close();
        }
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{MessageBundlingTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    private static class MyReceiver
    extends ReceiverAdapter {
        private final List times = new LinkedList();

        private MyReceiver() {
        }

        public List getTimes() {
            return this.times;
        }

        public void receive(Message msg) {
            this.times.add(new Long(System.currentTimeMillis()));
            System.out.println("received message from " + msg.getSrc() + " at " + new Date());
        }
    }

    private static class NullReceiver
    extends ReceiverAdapter {
        private NullReceiver() {
        }

        public void receive(Message msg) {
        }
    }
}

