/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.util;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import javax.ejb.EJBHome;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.dcm4chex.archive.util.HomeFactoryException;

public class EJBHomeFactory {
    private static final String EJB_JNDI_PROPERTIES = "ejb-jndi.properties";
    private static EJBHomeFactory factory;
    private Hashtable homes = new Hashtable();
    private Context ctx;

    public static EJBHomeFactory getFactory() throws HomeFactoryException {
        if (factory == null) {
            try {
                factory = new EJBHomeFactory();
            }
            catch (Exception e) {
                throw new HomeFactoryException(e);
            }
        }
        return factory;
    }

    private EJBHomeFactory() throws NamingException, IOException {
        Properties env = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        env.load(cl.getResourceAsStream(EJB_JNDI_PROPERTIES));
        this.ctx = new InitialContext(env);
    }

    public EJBHome lookup(Class homeClass, String jndiName) throws HomeFactoryException {
        EJBHome home = (EJBHome)this.homes.get(homeClass);
        if (home == null) {
            try {
                home = (EJBHome)PortableRemoteObject.narrow((Object)this.ctx.lookup(jndiName), (Class)homeClass);
            }
            catch (ClassCastException e) {
                throw new HomeFactoryException(e);
            }
            catch (NamingException e) {
                throw new HomeFactoryException(e);
            }
            this.homes.put(homeClass, home);
        }
        return home;
    }
}

