/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.conf;

import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.parsers.SAXParserFactory;
import org.dcm4che.dict.VRs;
import org.dcm4che2.soundex.FuzzyStr;
import org.dcm4chex.archive.ejb.conf.AttributeFilter;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributeFilterLoader
extends DefaultHandler {
    private static final int[] INST_SUPPL_TAGS = new int[]{524372, 524374, 8913200, 8913216};
    private final ArrayList<String> tagList = new ArrayList();
    private final ArrayList<String> vrList = new ArrayList();
    private final ArrayList<String> noCoerceList = new ArrayList();
    private final ArrayList<String> iCaseList = new ArrayList();
    private final ArrayList<String> fieldTagList = new ArrayList();
    private final ArrayList<String> fieldList = new ArrayList();
    private AttributeFilter filter;

    AttributeFilterLoader() {
    }

    public static void loadFrom(String url) throws ConfigurationException {
        AttributeFilterLoader h = new AttributeFilterLoader();
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(url, (DefaultHandler)h);
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to load attribute filter from " + url, e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("attr")) {
            String tag = attributes.getValue("tag");
            if (tag != null) {
                if (attributes.getValue("seq") == null) {
                    this.tagList.add(tag);
                    String field = attributes.getValue("field");
                    if (field != null) {
                        this.fieldTagList.add(tag);
                        this.fieldList.add(field);
                    }
                    if ("false".equalsIgnoreCase(attributes.getValue("coerce"))) {
                        this.noCoerceList.add(tag);
                    }
                }
                if ("false".equalsIgnoreCase(attributes.getValue("case-sensitive"))) {
                    this.iCaseList.add(tag);
                }
            } else {
                String vr = attributes.getValue("vr");
                if (vr != null) {
                    this.vrList.add(vr);
                }
            }
        } else {
            if (qName.equals("instance")) {
                String cuid = attributes.getValue("cuid");
                if (AttributeFilter.instanceFilters.containsKey(cuid)) {
                    throw new SAXException("more than one instance element with cuid=" + cuid);
                }
                this.filter = this.makeFilter(attributes);
                AttributeFilter.instanceFilters.put(cuid, this.filter);
                String s = attributes.getValue("content-item-text-value-max-length");
                try {
                    this.filter.setContentItemTextValueMaxLength(Integer.parseInt(s));
                }
                catch (IllegalArgumentException e) {
                    throw new SAXException("illegal content-item-text-value-max-length: " + s);
                }
            }
            if (qName.equals("series")) {
                if (AttributeFilter.seriesFilter != null) {
                    throw new SAXException("more than one series element");
                }
                AttributeFilter.seriesFilter = this.filter = this.makeFilter(attributes);
            } else if (qName.equals("study")) {
                if (AttributeFilter.studyFilter != null) {
                    throw new SAXException("more than one study element");
                }
                AttributeFilter.studyFilter = this.filter = this.makeFilter(attributes);
            } else if (qName.equals("patient")) {
                if (AttributeFilter.patientFilter != null) {
                    throw new SAXException("more than one patient element");
                }
                AttributeFilter.patientFilter = this.filter = this.makeFilter(attributes);
            } else if (qName.equals("exclude-patient")) {
                if (AttributeFilter.excludePatientFilter != null) {
                    throw new SAXException("more than one exclude-patient element");
                }
                AttributeFilter.excludePatientFilter = this.filter = this.makeFilter(attributes);
            } else if (qName.equals("soundex")) {
                String clazz = attributes.getValue("class");
                try {
                    AttributeFilter.soundex = (FuzzyStr)Class.forName(clazz).newInstance();
                    AttributeFilter.soundexWithTrailingWildCard = "true".equalsIgnoreCase(attributes.getValue("trailing-wildcard"));
                }
                catch (Exception e) {
                    throw new SAXException("Failed to instantiate Soundex implementation: " + clazz, e);
                }
            }
        }
    }

    private AttributeFilter makeFilter(Attributes attributes) {
        String strategy = attributes.getValue("update-strategy");
        return new AttributeFilter(attributes.getValue("tsuid"), "true".equalsIgnoreCase(attributes.getValue("exclude")), "true".equalsIgnoreCase(attributes.getValue("excludePrivate")), strategy.startsWith("overwrite"), strategy.endsWith("merge"));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("attr")) {
            return;
        }
        boolean inst = qName.equals("instance");
        if (inst || qName.equals("series") || qName.equals("study") || qName.equals("patient") || qName.equals("exclude-patient")) {
            int[] tags = AttributeFilterLoader.parseInts(this.tagList, true);
            int[] vrs = AttributeFilterLoader.parseVRs(this.vrList);
            if (inst && this.filter.isExclude()) {
                if (AttributeFilter.patientFilter == null) {
                    throw new SAXException("missing patient before instance element");
                }
                if (AttributeFilter.studyFilter == null) {
                    throw new SAXException("missing study before instance element");
                }
                if (AttributeFilter.seriesFilter == null) {
                    throw new SAXException("missing series before instance element");
                }
                tags = this.merge(INST_SUPPL_TAGS, AttributeFilter.patientFilter.getTags(), AttributeFilter.studyFilter.getTags(), AttributeFilter.seriesFilter.getTags(), tags);
                vrs = this.merge(new int[0], AttributeFilter.patientFilter.getVRs(), AttributeFilter.studyFilter.getVRs(), AttributeFilter.seriesFilter.getVRs(), vrs);
            }
            this.filter.setTags(tags);
            this.filter.setFieldTags(AttributeFilterLoader.parseInts(this.fieldTagList, false));
            this.filter.setFields(this.fieldList.toArray(new String[0]));
            this.filter.setNoCoercion(AttributeFilterLoader.parseInts(this.noCoerceList, true));
            this.filter.setICase(AttributeFilterLoader.parseInts(this.iCaseList, true));
            this.filter.setVRs(vrs);
            this.tagList.clear();
            this.fieldTagList.clear();
            this.fieldList.clear();
            this.noCoerceList.clear();
            this.vrList.clear();
            this.filter = null;
        }
    }

    private int[] merge(int[] a, int[] b, int[] c, int[] d, int[] e) {
        int[] dst = new int[a.length + b.length + c.length + d.length + e.length];
        System.arraycopy(a, 0, dst, 0, a.length);
        System.arraycopy(b, 0, dst, a.length, b.length);
        System.arraycopy(c, 0, dst, a.length + b.length, c.length);
        System.arraycopy(d, 0, dst, a.length + b.length + c.length, d.length);
        System.arraycopy(e, 0, dst, a.length + b.length + c.length + d.length, e.length);
        Arrays.sort(dst);
        return dst;
    }

    private static int[] parseInts(ArrayList<String> list, boolean sort) {
        int[] array = new int[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = Integer.parseInt(list.get(i), 16);
        }
        if (sort) {
            Arrays.sort(array);
        }
        return array;
    }

    private static int[] parseVRs(ArrayList<String> list) {
        int[] array = new int[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = VRs.valueOf((String)list.get(i));
        }
        return array;
    }

    @Override
    public void endDocument() throws SAXException {
        if (AttributeFilter.excludePatientFilter == null) {
            throw new SAXException("missing exclude-patient element");
        }
        if (AttributeFilter.patientFilter == null) {
            throw new SAXException("missing patient element");
        }
        if (AttributeFilter.studyFilter == null) {
            throw new SAXException("missing study element");
        }
        if (AttributeFilter.seriesFilter == null) {
            throw new SAXException("missing series element");
        }
        if (AttributeFilter.instanceFilters.get(null) == null) {
            throw new SAXException("missing instance element");
        }
    }
}

