/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.ejb.conf;

import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.HashMap;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.PersonName;
import org.dcm4che2.soundex.FuzzyStr;
import org.dcm4chex.archive.ejb.conf.AttributeFilterLoader;
import org.dcm4chex.archive.exceptions.ConfigurationException;

public final class AttributeFilter {
    private static final String CONFIG_URL = "resource:dcm4chee-attribute-filter.xml";
    private static final int MIN_CONTENT_ITEM_TEXT_VALUE_MAX_LENGTH = 250;
    static FuzzyStr soundex = null;
    static boolean soundexWithTrailingWildCard;
    static int contentItemTextLength;
    static AttributeFilter excludePatientFilter;
    static AttributeFilter patientFilter;
    static AttributeFilter studyFilter;
    static AttributeFilter seriesFilter;
    static HashMap<String, AttributeFilter> instanceFilters;
    private int[] tags = new int[0];
    private int[] noCoercion = new int[0];
    private int[] iCase = new int[0];
    private int[] vrs = new int[0];
    private int[] fieldTags = new int[0];
    private String[] fields = new String[0];
    private final String tsuid;
    private final boolean exclude;
    private final boolean excludePrivate;
    private final boolean overwrite;
    private final boolean merge;
    private boolean noFilter = false;
    private int contentItemTextValueMaxLength;

    public static void main(String[] args) {
        AttributeFilterLoader.loadFrom(args[0]);
    }

    public static void reload() {
        soundex = null;
        excludePatientFilter = null;
        patientFilter = null;
        studyFilter = null;
        seriesFilter = null;
        instanceFilters.clear();
        AttributeFilterLoader.loadFrom(CONFIG_URL);
    }

    public static long lastModified() {
        URLConnection conn;
        try {
            conn = new URL(CONFIG_URL).openConnection();
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
        return conn.getLastModified();
    }

    public static AttributeFilter getExcludePatientAttributeFilter() {
        return excludePatientFilter;
    }

    public static AttributeFilter getPatientAttributeFilter() {
        return patientFilter;
    }

    public static AttributeFilter getStudyAttributeFilter() {
        return studyFilter;
    }

    public static AttributeFilter getSeriesAttributeFilter() {
        return seriesFilter;
    }

    public static AttributeFilter getInstanceAttributeFilter(String cuid) {
        AttributeFilter filter = instanceFilters.get(cuid);
        return filter == null ? instanceFilters.get(null) : filter;
    }

    AttributeFilter(String tsuid, boolean exclude, boolean excludePrivate, boolean overwrite, boolean merge) {
        this.tsuid = tsuid;
        this.exclude = exclude;
        this.excludePrivate = excludePrivate;
        this.overwrite = overwrite;
        this.merge = merge;
    }

    final void setNoCoercion(int[] noCoercion) {
        this.noCoercion = noCoercion;
    }

    final void setICase(int[] iCase) {
        this.iCase = iCase;
    }

    final void setTags(int[] tags) {
        this.tags = tags;
    }

    final int[] getTags() {
        return this.tags;
    }

    final void setFields(String[] fields) {
        if (!this.exclude) {
            this.fields = fields;
        }
    }

    final String[] getFields() {
        return this.fields;
    }

    public boolean hasTag(int tag) {
        int index = Arrays.binarySearch(this.tags, tag);
        return index >= 0;
    }

    final void setFieldTags(int[] fieldTags) {
        this.fieldTags = fieldTags;
    }

    public final int[] getFieldTags() {
        return this.fieldTags;
    }

    public String getField(int tag) {
        for (int i = 0; i < this.fieldTags.length; ++i) {
            if (this.fieldTags[i] != tag) continue;
            return this.fields[i];
        }
        return null;
    }

    final void setVRs(int[] vrs) {
        this.vrs = vrs;
    }

    final int[] getVRs() {
        return this.vrs;
    }

    public final boolean isNoFilter() {
        return this.noFilter;
    }

    final void setNoFilter(boolean noFilter) {
        this.noFilter = noFilter;
    }

    final boolean isExclude() {
        return this.exclude;
    }

    public boolean isCoercionForbidden(int tag) {
        return Arrays.binarySearch(this.noCoercion, tag) >= 0;
    }

    public boolean isICase(int tag) {
        return Arrays.binarySearch(this.iCase, tag) >= 0;
    }

    public final String getTransferSyntaxUID() {
        return this.tsuid;
    }

    public final boolean isOverwrite() {
        return this.overwrite;
    }

    public final boolean isMerge() {
        return this.merge;
    }

    public final int getContentItemTextValueMaxLength() {
        return this.contentItemTextValueMaxLength;
    }

    public final void setContentItemTextValueMaxLength(int len) {
        if (len < 250) {
            throw new IllegalArgumentException();
        }
        this.contentItemTextValueMaxLength = len;
    }

    public Dataset filter(Dataset ds) {
        return ds.subSet(this.tags, this.vrs, this.exclude, this.excludePrivate);
    }

    public String[] getStrings(Dataset ds, int tag) {
        return this.getStrings(ds, tag, tag);
    }

    public String[] getStrings(Dataset ds, int tag, int icasetag) {
        String[] ss = ds.getStrings(tag);
        if (ss != null && this.isICase(icasetag)) {
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = AttributeFilter.toUpperCase(ss[i]);
            }
        }
        return ss;
    }

    public String getString(Dataset ds, int tag) {
        return this.toUpperCase(ds.getString(tag), tag);
    }

    public String toUpperCase(String s, int tag) {
        return s != null && this.isICase(tag) ? s.toUpperCase() : s;
    }

    public static String toUpperCase(String s) {
        return s != null ? s.toUpperCase() : s;
    }

    public static boolean isSoundexEnabled() {
        return soundex != null;
    }

    public static boolean isSoundexWithTrailingWildCardEnabled() {
        return soundexWithTrailingWildCard;
    }

    public static String toSoundex(PersonName pn, int field, String defval) {
        String fuzzy;
        if (soundex == null) {
            throw new IllegalStateException("Soundex disabled");
        }
        if (pn != null && (fuzzy = soundex.toFuzzy(pn.get(field))).length() > 0) {
            return fuzzy;
        }
        return defval;
    }

    public static String toSoundexWithLike(PersonName pn, int field) {
        String s;
        if (soundex == null) {
            throw new IllegalStateException("Soundex disabled");
        }
        if (pn != null && (s = pn.get(field)) != null) {
            if (s.indexOf(63) != -1) {
                throw new IllegalArgumentException("Unsupported Wildcard with fuzzy matching");
            }
            int wc = s.indexOf(42);
            if (wc != -1) {
                int endIndex = s.length() - 1;
                if (!soundexWithTrailingWildCard || wc != endIndex) {
                    throw new IllegalArgumentException("Unsupported Wildcard with fuzzy matching");
                }
                String fuzzy = soundex.toFuzzy(s.substring(0, endIndex));
                if (fuzzy.length() > 0) {
                    return fuzzy + '%';
                }
            } else {
                String fuzzy = soundex.toFuzzy(s);
                if (fuzzy.length() > 0) {
                    return fuzzy;
                }
            }
        }
        return null;
    }

    static {
        instanceFilters = new HashMap();
        AttributeFilter.reload();
    }
}

