/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.common;

import java.io.Serializable;
import javax.management.Notification;
import javax.management.NotificationFilter;
import org.dcm4che.data.Dataset;

public class SeriesStored
implements Serializable {
    private static final long serialVersionUID = -3119250046425862896L;
    public static final NotificationFilter NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = 7625954422409724162L;

        public boolean isNotificationEnabled(Notification notif) {
            return SeriesStored.class.getName().equals(notif.getType());
        }
    };
    private final Dataset patAttrs;
    private final Dataset studyAttrs;
    private final Dataset seriesAttrs;
    private final String sourceAET;
    private final String retrieveAET;
    private final Dataset ian;

    public SeriesStored(String sourceAET, String retrieveAET, Dataset patient, Dataset study, Dataset series, Dataset ian) {
        if (patient == null) {
            throw new NullPointerException("patient");
        }
        if (study == null) {
            throw new NullPointerException("study");
        }
        if (series == null) {
            throw new NullPointerException("series");
        }
        if (ian == null) {
            throw new NullPointerException("ian");
        }
        this.sourceAET = sourceAET;
        this.retrieveAET = retrieveAET;
        this.patAttrs = patient;
        this.studyAttrs = study;
        this.seriesAttrs = series;
        this.ian = ian;
    }

    public String toString() {
        return "SeriesStored[sourceAET=" + this.getSourceAET() + ", retrieveAET=" + this.getRetrieveAET() + ", modality=" + this.getModality() + ", numOfInst=" + this.getNumberOfInstances() + ", study-iuid=" + this.getStudyInstanceUID() + ", series-iuid=" + this.getSeriesInstanceUID() + "]";
    }

    public final String getSourceAET() {
        return this.sourceAET;
    }

    public final String getRetrieveAET() {
        return this.retrieveAET;
    }

    public final Dataset getPatientAttrs() {
        return this.patAttrs;
    }

    public final Dataset getStudyAttrs() {
        return this.studyAttrs;
    }

    public final Dataset getSeriesAttrs() {
        return this.seriesAttrs;
    }

    public final Dataset getIAN() {
        return this.ian;
    }

    public String getPatientID() {
        return this.patAttrs.getString(0x100020);
    }

    public String getPatientName() {
        return this.patAttrs.getString(0x100010);
    }

    public String getStudyInstanceUID() {
        return this.studyAttrs.getString(0x20000D);
    }

    public String getAccessionNumber() {
        return this.studyAttrs.getString(524368);
    }

    public String getStudyID() {
        return this.studyAttrs.getString(0x200010);
    }

    public String getSeriesInstanceUID() {
        return this.seriesAttrs.getString(0x20000E);
    }

    public String getModality() {
        return this.seriesAttrs.getString(524384);
    }

    public int getNumberOfInstances() {
        return this.ian.getItem(528661).get(528793).countItems();
    }
}

