/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.common;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatientMatching
implements Serializable {
    private static final long serialVersionUID = -5066423063497788483L;
    private static final String PID = "pid";
    private static final String ISSUER = "issuer";
    private static final String FAMILYNAME = "familyname";
    private static final String GIVENNAME = "givenname";
    private static final String MIDDLENAME = "middlename";
    private static final String NAMEPREFIX = "nameprefix";
    private static final String NAMESUFFIX = "namesuffix";
    private static final String BIRTHDATE = "birthdate";
    private static final String SEX = "sex";
    private static final String INITIAL = "(1)";
    private static final String IGNORE = "ignore";
    private final boolean trustPatientIDWithIssuer;
    private final boolean unknownPatientIDAlwaysMatch;
    private final boolean unknownIssuerAlwaysMatch;
    private final boolean familyNameMustMatch;
    private final boolean familyNameInitialMatch;
    private final boolean unknownFamilyNameAlwaysMatch;
    private final boolean givenNameMustMatch;
    private final boolean givenNameInitialMatch;
    private final boolean unknownGivenNameAlwaysMatch;
    private final boolean middleNameMustMatch;
    private final boolean middleNameInitialMatch;
    private final boolean unknownMiddleNameAlwaysMatch;
    private final boolean namePrefixMustMatch;
    private final boolean namePrefixInitialMatch;
    private final boolean unknownNamePrefixAlwaysMatch;
    private final boolean nameSuffixMustMatch;
    private final boolean nameSuffixInitialMatch;
    private final boolean unknownNameSuffixAlwaysMatch;
    private final boolean birthDateMustMatch;
    private final boolean unknownBirthDateAlwaysMatch;
    private final boolean sexMustMatch;
    private final boolean unknownSexAlwaysMatch;
    private final Pattern ignore;
    private PatientMatching altDemographicsMatch;

    public PatientMatching(String s) {
        this(PatientMatching.indexOf(s, PID), PatientMatching.indexOf(s, ISSUER), s);
    }

    private PatientMatching(int pid, int issuer, String s) {
        boolean trust = s.charAt(s.length() - 1) == ']';
        int alt = this.indexOfAlt(s);
        if (alt != -1) {
            this.altDemographicsMatch = new PatientMatching(pid, issuer, s.substring(alt + 1));
            s = s.substring(0, alt);
        }
        int familyName = PatientMatching.indexOf(s, FAMILYNAME);
        int givenName = PatientMatching.indexOf(s, GIVENNAME);
        int middleName = PatientMatching.indexOf(s, MIDDLENAME);
        int namePrefix = PatientMatching.indexOf(s, NAMEPREFIX);
        int nameSuffix = PatientMatching.indexOf(s, NAMESUFFIX);
        int birthdate = PatientMatching.indexOf(s, BIRTHDATE);
        int sex = PatientMatching.indexOf(s, SEX);
        if (pid == -1 || issuer == -1 || this.initialMatch(s, pid, PID) || this.initialMatch(s, issuer, ISSUER) || this.initialMatch(s, birthdate, BIRTHDATE) || this.initialMatch(s, sex, SEX)) {
            throw new IllegalArgumentException(s);
        }
        this.familyNameMustMatch = familyName != -1;
        this.givenNameMustMatch = givenName != -1;
        this.middleNameMustMatch = middleName != -1;
        this.namePrefixMustMatch = namePrefix != -1;
        this.nameSuffixMustMatch = nameSuffix != -1;
        this.birthDateMustMatch = birthdate != -1;
        this.sexMustMatch = sex != -1;
        this.unknownPatientIDAlwaysMatch = this.unknownAlwaysMatch(s, pid, PID, false);
        this.unknownIssuerAlwaysMatch = this.unknownAlwaysMatch(s, issuer, ISSUER, false);
        this.familyNameInitialMatch = this.initialMatch(s, familyName, FAMILYNAME);
        this.unknownFamilyNameAlwaysMatch = this.unknownAlwaysMatch(s, familyName, FAMILYNAME, this.familyNameInitialMatch);
        this.givenNameInitialMatch = this.initialMatch(s, givenName, GIVENNAME);
        this.unknownGivenNameAlwaysMatch = this.unknownAlwaysMatch(s, givenName, GIVENNAME, this.givenNameInitialMatch);
        this.middleNameInitialMatch = this.initialMatch(s, middleName, MIDDLENAME);
        this.unknownMiddleNameAlwaysMatch = this.unknownAlwaysMatch(s, middleName, MIDDLENAME, this.middleNameInitialMatch);
        this.namePrefixInitialMatch = this.initialMatch(s, namePrefix, NAMEPREFIX);
        this.unknownNamePrefixAlwaysMatch = this.unknownAlwaysMatch(s, namePrefix, NAMEPREFIX, this.namePrefixInitialMatch);
        this.nameSuffixInitialMatch = this.initialMatch(s, nameSuffix, NAMESUFFIX);
        this.unknownNameSuffixAlwaysMatch = this.unknownAlwaysMatch(s, nameSuffix, NAMESUFFIX, this.nameSuffixInitialMatch);
        this.unknownBirthDateAlwaysMatch = this.unknownAlwaysMatch(s, birthdate, BIRTHDATE, false);
        this.unknownSexAlwaysMatch = this.unknownAlwaysMatch(s, sex, SEX, false);
        this.ignore = this.ignorePattern(s);
        boolean bl = this.trustPatientIDWithIssuer = trust || !this.familyNameMustMatch && !this.givenNameMustMatch && !this.middleNameMustMatch && !this.namePrefixMustMatch && !this.nameSuffixMustMatch && !this.birthDateMustMatch && !this.sexMustMatch;
        if (this.unknownPatientIDAlwaysMatch && !this.familyNameMustMatch) {
            throw new IllegalArgumentException(s);
        }
    }

    private int indexOfAlt(String s) {
        int ignore = s.indexOf(IGNORE);
        int alt = -1;
        while ((alt = s.indexOf(124, alt + 1)) != -1) {
            if (ignore != -1 && ignore <= alt && s.indexOf("\")", ignore + 2) >= alt) continue;
            return alt;
        }
        return -1;
    }

    public final boolean isTrustPatientIDWithIssuer() {
        return this.trustPatientIDWithIssuer;
    }

    public boolean isUnknownIssuerAlwaysMatch() {
        return this.unknownIssuerAlwaysMatch;
    }

    public final PatientMatching getAltDemographicsMatch() {
        return this.altDemographicsMatch;
    }

    public final void setAltDemographicsMatch(PatientMatching altDemographicsMatch) {
        this.altDemographicsMatch = altDemographicsMatch;
    }

    private boolean isUnknownPersonNameAlwaysMatch() {
        return this.unknownFamilyNameAlwaysMatch && this.unknownGivenNameAlwaysMatch && this.unknownMiddleNameAlwaysMatch && this.unknownNamePrefixAlwaysMatch && this.unknownNameSuffixAlwaysMatch;
    }

    private boolean initialMatch(String s, int index, String substr) {
        return index != -1 && s.startsWith(INITIAL, index + substr.length());
    }

    private boolean unknownAlwaysMatch(String s, int index, String substr, boolean initialMatch) {
        if (index == -1) {
            return true;
        }
        int after = index + substr.length();
        if (initialMatch) {
            after += INITIAL.length();
        }
        return after < s.length() && s.charAt(after) == '?';
    }

    private Pattern ignorePattern(String s) {
        int end;
        int index = s.indexOf(IGNORE);
        if (index == -1) {
            return null;
        }
        int after = index + IGNORE.length();
        int begin = after + 2;
        if (!s.startsWith("(\"", after) || (end = s.indexOf("\")", begin)) == -1) {
            throw new IllegalArgumentException(s);
        }
        String regex = s.substring(begin, end);
        return Pattern.compile(regex);
    }

    private static int indexOf(String str, String substr) {
        int after;
        int index = str.indexOf(substr);
        if (index != -1 && (index > 0 && " ,[".indexOf(str.charAt(index - 1)) == -1 || (after = index + substr.length()) < str.length() && " ,]?(".indexOf(str.charAt(after)) == -1)) {
            throw new IllegalArgumentException(str);
        }
        return index;
    }

    public String toString() {
        return this.toStringBuilder(new StringBuilder()).toString();
    }

    public StringBuilder toStringBuilder(StringBuilder sb) {
        sb.append(PID);
        if (this.unknownPatientIDAlwaysMatch) {
            sb.append('?');
        }
        sb.append(',').append(ISSUER);
        if (this.unknownIssuerAlwaysMatch) {
            sb.append('?');
        }
        if (this.familyNameMustMatch || this.givenNameMustMatch || this.middleNameMustMatch || this.namePrefixMustMatch || this.nameSuffixMustMatch || this.birthDateMustMatch || this.sexMustMatch) {
            sb.append(',');
            if (this.trustPatientIDWithIssuer) {
                sb.append('[');
            }
            this.appendDemographicsMatch(sb);
            PatientMatching m = this.altDemographicsMatch;
            while (m != null) {
                m.appendDemographicsMatch(sb.append('|'));
                m = m.altDemographicsMatch;
            }
            if (this.trustPatientIDWithIssuer) {
                sb.append(']');
            }
        }
        return sb;
    }

    private void appendDemographicsMatch(StringBuilder sb) {
        int count = 0;
        if (this.ignore != null) {
            ++count;
            sb.append(IGNORE).append("(\"").append(this.ignore).append("\")");
        }
        if (this.familyNameMustMatch) {
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(FAMILYNAME);
            if (this.familyNameInitialMatch) {
                sb.append(INITIAL);
            }
            if (this.unknownFamilyNameAlwaysMatch) {
                sb.append('?');
            }
        }
        if (this.givenNameMustMatch) {
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(GIVENNAME);
            if (this.givenNameInitialMatch) {
                sb.append(INITIAL);
            }
            if (this.unknownGivenNameAlwaysMatch) {
                sb.append('?');
            }
        }
        if (this.middleNameMustMatch) {
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(MIDDLENAME);
            if (this.middleNameInitialMatch) {
                sb.append(INITIAL);
            }
            if (this.unknownMiddleNameAlwaysMatch) {
                sb.append('?');
            }
        }
        if (this.namePrefixMustMatch) {
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(NAMEPREFIX);
            if (this.namePrefixInitialMatch) {
                sb.append(INITIAL);
            }
            if (this.unknownNamePrefixAlwaysMatch) {
                sb.append('?');
            }
        }
        if (this.nameSuffixMustMatch) {
            if (count++ > 0) {
                sb.append(',');
            }
            sb.append(NAMESUFFIX);
            if (this.nameSuffixInitialMatch) {
                sb.append(INITIAL);
            }
            if (this.unknownNameSuffixAlwaysMatch) {
                sb.append('?');
            }
        }
        if (this.birthDateMustMatch) {
            if (count > 0) {
                sb.append(',');
            }
            sb.append(BIRTHDATE);
            if (this.unknownBirthDateAlwaysMatch) {
                sb.append('?');
            }
        }
        if (this.sexMustMatch) {
            if (count > 0) {
                sb.append(',');
            }
            sb.append(SEX);
            if (this.unknownSexAlwaysMatch) {
                sb.append('?');
            }
        }
    }

    public List<Pattern> compilePNPatterns(String familyName, String givenName, String middleName, String namePrefix, String nameSuffix) {
        LinkedList<Pattern> list = new LinkedList<Pattern>();
        PatientMatching m = this;
        while (m != null) {
            list.add(m.compilePNPattern(familyName, givenName, middleName, namePrefix, nameSuffix));
            m = m.altDemographicsMatch;
        }
        return list;
    }

    public Pattern compilePNPattern(String familyName, String givenName, String middleName, String namePrefix, String nameSuffix) {
        if (this.allMatchesFor(familyName, givenName, middleName, namePrefix, nameSuffix)) {
            return null;
        }
        boolean appendNameSuffix = this.nameSuffixMustMatch && nameSuffix != null;
        boolean appendNamePrefix = appendNameSuffix || this.namePrefixMustMatch && namePrefix != null;
        boolean appendMiddleName = appendNamePrefix || this.middleNameMustMatch && middleName != null;
        boolean appendGivenName = appendMiddleName || this.givenNameMustMatch && givenName != null;
        boolean appendFamilyName = appendGivenName || this.familyNameMustMatch && familyName != null;
        StringBuilder regex = new StringBuilder();
        if (appendFamilyName) {
            PatientMatching.appendRegex(regex, this.ignore(familyName), this.familyNameMustMatch, this.familyNameInitialMatch, this.unknownFamilyNameAlwaysMatch);
            regex.append("\\^");
            if (appendGivenName) {
                PatientMatching.appendRegex(regex, this.ignore(givenName), this.givenNameMustMatch, this.givenNameInitialMatch, this.unknownGivenNameAlwaysMatch);
                regex.append("\\^");
                if (appendMiddleName) {
                    PatientMatching.appendRegex(regex, this.ignore(middleName), this.middleNameMustMatch, this.middleNameInitialMatch, this.unknownMiddleNameAlwaysMatch);
                    regex.append("\\^");
                    if (appendNamePrefix) {
                        PatientMatching.appendRegex(regex, this.ignore(namePrefix), this.namePrefixMustMatch, this.namePrefixInitialMatch, this.unknownNamePrefixAlwaysMatch);
                        regex.append("\\^");
                        if (appendNameSuffix) {
                            PatientMatching.appendRegex(regex, this.ignore(nameSuffix), this.nameSuffixMustMatch, this.nameSuffixInitialMatch, this.unknownNameSuffixAlwaysMatch);
                        }
                    }
                }
            }
        }
        if (!appendNameSuffix) {
            regex.append(".*");
        }
        return Pattern.compile(regex.toString());
    }

    public String ignore(String s) {
        return this.ignore == null || s == null ? s : this.ignore.matcher(s).replaceAll("");
    }

    private static void appendRegex(StringBuilder regex, String value, boolean mustMatch, boolean initialMatch, boolean unknownAlwaysMatch) {
        if (!mustMatch || value == null || value.length() == 0) {
            regex.append("[^\\^]*");
        } else if (initialMatch) {
            regex.append(unknownAlwaysMatch ? "(\\Q" : "\\Q").append(value.charAt(0)).append(unknownAlwaysMatch ? "\\E[^\\^]*)?" : "\\E[^\\^]*");
        } else {
            regex.append(unknownAlwaysMatch ? "(\\Q" : "\\Q").append(value).append(unknownAlwaysMatch ? "\\E)?" : "\\E");
        }
    }

    public boolean noMatchesFor(String pid, String issuer, String familyName, String givenName, String middleName, String namePrefix, String nameSuffix, String birthdate, String sex) {
        return !this.unknownPatientIDAlwaysMatch && pid == null || !this.unknownIssuerAlwaysMatch && issuer == null || (!this.trustPatientIDWithIssuer || pid == null || issuer == null) && this.noMatchesFor(familyName, givenName, middleName, namePrefix, nameSuffix, birthdate, sex);
    }

    public boolean noMatchesFor(String familyName, String givenName, String middleName, String namePrefix, String nameSuffix, String birthdate, String sex) {
        return (!this.unknownFamilyNameAlwaysMatch && familyName == null || !this.unknownGivenNameAlwaysMatch && givenName == null || !this.unknownMiddleNameAlwaysMatch && middleName == null || !this.unknownNamePrefixAlwaysMatch && namePrefix == null || !this.unknownNameSuffixAlwaysMatch && nameSuffix == null || !this.unknownBirthDateAlwaysMatch && birthdate == null || !this.unknownSexAlwaysMatch && sex == null) && (this.altDemographicsMatch == null || this.altDemographicsMatch.noMatchesFor(familyName, givenName, middleName, namePrefix, nameSuffix, birthdate, sex));
    }

    private boolean allMatchesFor(String familyName, String givenName, String middleName, String namePrefix, String nameSuffix) {
        return (!this.familyNameMustMatch || this.unknownFamilyNameAlwaysMatch && familyName == null) && (!this.givenNameMustMatch || this.unknownGivenNameAlwaysMatch && givenName == null) && (!this.middleNameMustMatch || this.unknownMiddleNameAlwaysMatch && middleName == null) && (!this.namePrefixMustMatch || this.unknownNamePrefixAlwaysMatch && namePrefix == null) && (!this.nameSuffixMustMatch || this.unknownNameSuffixAlwaysMatch && nameSuffix == null);
    }

    public boolean allMatchesFor(String familyName, String givenName, String middleName, String namePrefix, String nameSuffix, String birthdate, String sex) {
        return this.allMatchesFor(familyName, givenName, middleName, namePrefix, nameSuffix) && (!this.birthDateMustMatch || this.unknownBirthDateAlwaysMatch && birthdate == null) && (!this.sexMustMatch || this.unknownSexAlwaysMatch && sex == null) || this.altDemographicsMatch != null && this.altDemographicsMatch.allMatchesFor(familyName, givenName, middleName, namePrefix, nameSuffix, birthdate, sex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(String pn, String birthdate, String sex, Iterator<Pattern> pnPatternIter, String birthdate2, String sex2) {
        Pattern pnPattern = pnPatternIter.next();
        if ((pnPattern == null || (pn == null ? this.isUnknownPersonNameAlwaysMatch() : pnPattern.matcher(this.ignore(pn)).matches())) && (!this.birthDateMustMatch || birthdate == null || birthdate2 == null ? this.unknownBirthDateAlwaysMatch : birthdate.equals(birthdate2))) {
            if (!this.sexMustMatch) return true;
            if (sex == null || sex2 == null) {
                if (this.unknownSexAlwaysMatch) {
                    return true;
                }
            } else if (sex.equals(sex2)) return true;
        }
        if (this.altDemographicsMatch == null) return false;
        if (!this.altDemographicsMatch.matches(pn, birthdate, sex, pnPatternIter, birthdate2, sex2)) return false;
        return true;
    }

    public static void main(String[] args) {
        for (String s : args) {
            System.out.println(s);
            System.out.println(new PatientMatching(s));
            System.out.println();
        }
    }
}

