/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.common;

import java.io.Serializable;
import org.dcm4chex.archive.common.BaseJmsOrder;

public class DeleteStudyOrder
extends BaseJmsOrder
implements Serializable {
    private static final long serialVersionUID = 2395940827585137279L;
    private final long sofPk;
    private final long studyPk;
    private final long fsPk;
    private final long accessTime;
    private final String studyIUID;
    private final String externalRetrieveAET;
    private int externalRetrieveAvailability = 3;

    public DeleteStudyOrder(long sofPk, long studyPk, long fsPk, long accessTime, String externalRetrieveAET, String studyIUID) {
        this.sofPk = sofPk;
        this.studyPk = studyPk;
        this.fsPk = fsPk;
        this.accessTime = accessTime;
        this.studyIUID = studyIUID;
        this.externalRetrieveAET = externalRetrieveAET;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("\tStudyOnFS PK: ").append(this.sofPk).append("\n");
        sb.append("\tStudy PK: ").append(this.studyPk).append("\n");
        sb.append("\tFileSystem PK: ").append(this.fsPk).append("\n");
        return sb.toString();
    }

    public long getSoFsPk() {
        return this.sofPk;
    }

    public long getFsPk() {
        return this.fsPk;
    }

    public long getStudyPk() {
        return this.studyPk;
    }

    public long getAccessTime() {
        return this.accessTime;
    }

    public String getStudyIUID() {
        return this.studyIUID;
    }

    public String getExternalRetrieveAET() {
        return this.externalRetrieveAET;
    }

    public int getExternalRetrieveAvailability() {
        return this.externalRetrieveAvailability;
    }

    public void setExternalRetrieveAvailability(int availability) {
        this.externalRetrieveAvailability = availability;
    }

    public void processOrderProperties(Object ... properties) {
        String studyInstanceUID = properties != null && properties.length == 1 ? (String)properties[0] : null;
        this.setOrderProperty("StudyInstanceUID", studyInstanceUID);
    }
}

