/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4cheri.util.StringUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DatasetUtils {
    private static final Logger log = Logger.getLogger(DatasetUtils.class);

    public static void putRetrieveAET(Dataset ds, String iAETs, String eAET) {
        if (iAETs != null) {
            ds.putAE(524372, StringUtils.split((String)(eAET != null ? iAETs + '\\' + eAET : iAETs), (char)'\\'));
        } else {
            ds.putAE(524372, eAET);
        }
    }

    public static Dataset fromByteArray(byte[] data) {
        return DatasetUtils.fromByteArray(data, null);
    }

    public static Dataset fromByteArray(byte[] data, Dataset ds) {
        if (data == null) {
            return DcmObjectFactory.getInstance().newDataset();
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        if (ds == null) {
            ds = DcmObjectFactory.getInstance().newDataset();
        }
        try {
            ds.readFile((InputStream)bin, null, -1);
            ds.setFileMetaInfo(null);
        }
        catch (IOException e) {
            log.warn((Object)"Attributes truncated! (Maybe BLOB size not sufficient to store Attributes correctly)! Return empty dataset", (Throwable)e);
        }
        return ds;
    }

    public static byte[] toByteArray(Dataset ds) {
        if (ds == null) {
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream(ds.calcLength(DcmEncodeParam.EVR_LE));
        try {
            ds.writeDataset((OutputStream)bos, DcmEncodeParam.EVR_LE);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("" + e);
        }
        return bos.toByteArray();
    }

    public static byte[] toByteArray(Dataset ds, String tsuid) {
        if (ds == null) {
            return null;
        }
        if (tsuid == null) {
            return DatasetUtils.toByteArray(ds);
        }
        FileMetaInfo fmi = DcmObjectFactory.getInstance().newFileMetaInfo();
        fmi.setPreamble(null);
        fmi.putUI(131088, tsuid);
        DcmEncodeParam encodeParam = DcmEncodeParam.valueOf((String)tsuid);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(fmi.length() + ds.calcLength(encodeParam));
        FileMetaInfo prevfmi = ds.getFileMetaInfo();
        ds.setFileMetaInfo(fmi);
        try {
            ds.writeFile((OutputStream)bos, encodeParam);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("" + e);
        }
        finally {
            ds.setFileMetaInfo(prevfmi);
        }
        return bos.toByteArray();
    }

    private static SAXParser getSAXParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Dataset fromXML(InputSource is) throws SAXException, IOException {
        Dataset ds = DcmObjectFactory.getInstance().newDataset();
        DatasetUtils.getSAXParser().parse(is, ds.getSAXHandler2(null));
        return ds;
    }

    public static Dataset fromXML(InputStream is) throws SAXException, IOException {
        return DatasetUtils.fromXML(new InputSource(is));
    }

    public static Dataset fromXML(Reader r) throws SAXException, IOException {
        return DatasetUtils.fromXML(new InputSource(r));
    }

    public static Dataset fromXML(String s) throws SAXException, IOException {
        return DatasetUtils.fromXML(new StringReader(s));
    }

    private DatasetUtils() {
    }
}

