/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.archive.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public abstract class BaseJmsOrder
implements Serializable {
    private static final long serialVersionUID = -2427617218391383019L;
    protected static long counter = 0L;
    private String id = new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()) + counter++;
    private int failureCount = 0;
    private Throwable throwable = null;
    private String origQueueName = null;
    private Properties orderProperties = new Properties();
    public static final char PROPERTY_DELIMITER = ';';
    public static final char PROPERTY_DELIMITER_ESCAPE = '\\';
    private final int MAX_PROPERTIES_SIZE = 1000;
    private int propertiesSize = 0;

    public final int getFailureCount() {
        return this.failureCount;
    }

    public final void setFailureCount(int failureCount) {
        this.failureCount = failureCount;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public String toIdString() {
        return this.getClass().getName() + "@" + this.id + "@" + Integer.toHexString(this.hashCode());
    }

    protected String getOrderDetails() {
        return "";
    }

    public void copyOrderPropertiesTo(Properties p) {
        if (p != null) {
            p.putAll((Map<?, ?>)this.orderProperties);
        }
    }

    public void processOrderProperties(Object ... properties) {
    }

    public boolean setOrderProperty(String name, String property) {
        if (this.propertiesSize >= 1000) {
            return false;
        }
        String propDelim = String.valueOf(';');
        String propEscape = String.valueOf('\\');
        if (name != null && property != null) {
            String delimitedProperty = propDelim + property.replace(propDelim, propEscape + propDelim) + propDelim;
            int size = name.length() + delimitedProperty.length();
            if (this.propertiesSize + size >= 1000) {
                return false;
            }
            this.propertiesSize += size;
            this.orderProperties.setProperty(name, delimitedProperty);
            return true;
        }
        return false;
    }

    public boolean setOrderMultiProperty(String name, String ... properties) {
        if (this.propertiesSize >= 1000) {
            return false;
        }
        String propDelim = String.valueOf(';');
        String propEscape = String.valueOf('\\');
        if (name != null && properties != null && properties.length > 0) {
            String property;
            String delimitedProperty;
            int combinedPropertiesSize = name.length() + 1;
            StringBuffer sb = new StringBuffer();
            sb.append(';');
            String[] arr$ = properties;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && this.propertiesSize + (combinedPropertiesSize += (delimitedProperty = (property = arr$[i$]).replace(propDelim, propEscape + propDelim) + propDelim).length()) < 1000; ++i$) {
                sb.append(delimitedProperty);
            }
            this.propertiesSize += combinedPropertiesSize;
            this.orderProperties.setProperty(name, sb.toString());
            return true;
        }
        return false;
    }

    public void setQueueName(String queueName) {
        if (this.origQueueName == null) {
            this.origQueueName = queueName;
        }
    }

    public String getQueueName() {
        return this.origQueueName;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.toIdString() + "[");
        String orderDetails = this.getOrderDetails();
        if (orderDetails.length() > 0) {
            sb.append(orderDetails);
        }
        sb.append(", failures=").append(this.failureCount);
        sb.append("]");
        return sb.toString();
    }

    public String toLongString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\tInternal ID: ").append(this.toIdString()).append("\n");
        String orderDetails = this.getOrderDetails();
        if (orderDetails.length() > 0) {
            sb.append("\tDetails: ").append(orderDetails).append("\n");
        }
        sb.append("\tOriginal queue name: ").append(this.origQueueName).append("\n");
        if (this.orderProperties.size() > 0) {
            sb.append("\tOrder properties: ");
            Enumeration<?> names = this.orderProperties.propertyNames();
            while (names.hasMoreElements()) {
                String key = (String)names.nextElement();
                String property = this.orderProperties.getProperty(key);
                property = property.substring(1, property.length() - 1);
                sb.append(key).append("=").append(property).append(", ");
            }
            sb.setCharAt(sb.length() - 2, '\n');
        }
        sb.append("\tFailure count: ").append(this.failureCount).append("\n");
        if (this.throwable != null) {
            StringWriter sw = new StringWriter();
            this.throwable.printStackTrace(new PrintWriter(sw));
            sb.append("\tException caught: ").append(sw.toString()).append("\n");
        }
        return sb.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.orderProperties == null) {
            this.orderProperties = new Properties();
        }
    }
}

