/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.audit.login;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.UserAuthenticationMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditLoginModule
implements LoginModule {
    private static final String WEB_REQUEST_KEY = "javax.servlet.http.HttpServletRequest";
    private static final Logger auditlog = Logger.getLogger((String)"auditlog");
    private static final Logger log = Logger.getLogger(AuditLoginModule.class);
    private CallbackHandler cbh;

    @Override
    public void initialize(Subject subject, CallbackHandler cbh, Map<String, ?> sharedState, Map<String, ?> options) {
        this.cbh = cbh;
    }

    @Override
    public boolean login() throws LoginException {
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        this.auditUserAuth(UserAuthenticationMessage.LOGIN);
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.auditUserAuthFailure(AuditEvent.OutcomeIndicator.MINOR_FAILURE);
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        this.auditUserAuth(UserAuthenticationMessage.LOGOUT);
        return false;
    }

    private void auditUserAuth(AuditEvent.TypeCode typeCode) {
        UserAuthenticationMessage userAuth = new UserAuthenticationMessage(typeCode);
        userAuth.addUserPerson(this.getUserID(), null, null, this.getHostname());
        auditlog.info((Object)userAuth);
    }

    private void auditUserAuthFailure(AuditEvent.OutcomeIndicator failure) {
        UserAuthenticationMessage msg = new UserAuthenticationMessage(UserAuthenticationMessage.LOGIN);
        msg.setOutcomeIndicator(failure);
        msg.addUserPerson(this.getUserID(), null, null, this.getHostname());
        auditlog.warn((Object)msg);
    }

    private String getUserID() {
        NameCallback nc = new NameCallback("prompt");
        try {
            this.cbh.handle(new Callback[]{nc});
        }
        catch (Exception e) {
            log.error((Object)"Failed to identify user:", (Throwable)e);
            return "UNKOWN_USER";
        }
        return nc.getName();
    }

    private HttpServletRequest getHttpServletRequest() throws PolicyContextException {
        return (HttpServletRequest)PolicyContext.getContext((String)WEB_REQUEST_KEY);
    }

    private String getHostname() {
        try {
            return this.getHttpServletRequest().getRemoteHost();
        }
        catch (PolicyContextException e) {
            log.warn((Object)"Failed to identify user host:", (Throwable)e);
            return null;
        }
    }
}

