/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.wado.mbean.xml;

import java.util.Iterator;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.xml.transform.sax.TransformerHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLUtil {
    AbstractButton v;
    public static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    private TransformerHandler th = null;
    private String nameSpacePrefix = null;

    public XMLUtil(TransformerHandler handle) {
        this.th = handle;
    }

    public XMLUtil(TransformerHandler handle, String nameSpacePrefix) {
        this.th = handle;
        this.setNameSpace(nameSpacePrefix);
    }

    public void setNameSpace(String ns) {
        if (ns != null && !ns.endsWith(":")) {
            ns = ns + ":";
        }
        this.nameSpacePrefix = ns;
    }

    public void startElement(String name, Attributes attr) throws SAXException {
        if (this.nameSpacePrefix != null) {
            name = this.nameSpacePrefix + name;
        }
        if (attr == null) {
            attr = EMPTY_ATTRIBUTES;
        }
        this.th.startElement("", name, name, attr);
    }

    public void startElement(String name, String attrName, String attrValue) throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        this.addAttribute(attr, attrName, attrValue);
        this.startElement(name, attr);
    }

    public void endElement(String name) throws SAXException {
        if (this.nameSpacePrefix != null) {
            name = this.nameSpacePrefix + name;
        }
        this.th.endElement("", name, name);
    }

    public void singleElement(String name, Attributes attr, String value) throws SAXException {
        this.startElement(name, attr);
        this.addValue(value);
        this.endElement(name);
    }

    public AttributesImpl newAttribute(String name, String value) {
        AttributesImpl attr = new AttributesImpl();
        this.addAttribute(attr, name, value);
        return attr;
    }

    public void addAttribute(AttributesImpl attr, String name, String value) {
        if (value == null) {
            return;
        }
        attr.addAttribute("", name, name, "", value);
    }

    public void addAttributes(AttributesImpl attr, Properties props) {
        if (props != null) {
            Iterator<Object> iter = props.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                this.addAttribute(attr, key, props.getProperty(key));
            }
        }
    }

    public void addValue(String value) throws SAXException {
        if (value != null) {
            this.th.characters(value.toCharArray(), 0, value.length());
        }
    }
}

