/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.wado.mbean.cache;

import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.config.DeleterThresholds;
import org.dcm4chex.archive.exceptions.ConfigurationException;
import org.dcm4chex.archive.util.CacheJournal;
import org.dcm4chex.archive.util.FileSystemUtils;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.wado.mbean.cache.WADOCache;
import org.dcm4chex.wado.mbean.cache.WADOCacheImplSun;

public class WADOCacheImpl
implements WADOCache {
    private static final int[] EMPTY_INTS = new int[0];
    public static final String DEFAULT_IMAGE_QUALITY = "75";
    private static final int BUF_LEN = 65536;
    private static WADOCacheImpl singletonWADO = null;
    protected static Logger log = Logger.getLogger((String)WADOCacheImpl.class.getName());
    private String dataRootDir;
    private String journalRootDir;
    private CacheJournal journal = new CacheJournal();
    private int[] numberOfStudyBags = EMPTY_INTS;
    private DeleterThresholds deleterThresholds = new DeleterThresholds("23:50MB", true);
    private boolean clientRedirect = false;
    private boolean redirectCaching = true;
    private String imageQuality = "75";
    protected String imageWriterClass;

    protected WADOCacheImpl() {
    }

    public String getDataRootDir() {
        return this.dataRootDir;
    }

    public void setDataRootDir(String dataRootDir) {
        this.journal.setDataRootDir(FileUtils.resolve((File)new File(dataRootDir)));
        this.dataRootDir = dataRootDir;
    }

    public String getJournalRootDir() {
        return this.journalRootDir;
    }

    public void setJournalRootDir(String journalRootDir) {
        this.journal.setJournalRootDir(FileUtils.resolve((File)new File(journalRootDir)));
        this.journalRootDir = journalRootDir;
    }

    public String getJournalFilePathFormat() {
        return this.journal.getJournalFilePathFormat();
    }

    public void setJournalFilePathFormat(String journalFilePathFormat) {
        this.journal.setJournalFilePathFormat(journalFilePathFormat);
    }

    public String getNumberOfStudyBags() {
        if (this.numberOfStudyBags.length == 0) {
            return "1";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.numberOfStudyBags[0]);
        for (int i = 1; i < this.numberOfStudyBags.length; ++i) {
            sb.append('*').append(this.numberOfStudyBags[i]);
        }
        return sb.toString();
    }

    public static int leastPrimeAsLargeAs(int target) {
        int prime = target;
        while (!WADOCacheImpl.isPrime(prime)) {
            ++prime;
        }
        return prime;
    }

    public static boolean isPrime(int candidate) {
        int sqrt = (int)Math.sqrt(candidate) + 1;
        for (int i = 2; i <= sqrt; ++i) {
            if (candidate % i != 0) continue;
            return false;
        }
        return true;
    }

    public void setNumberOfStudyBags(String s) {
        if (s.trim().equals("1")) {
            this.numberOfStudyBags = EMPTY_INTS;
            return;
        }
        StringTokenizer tokens = new StringTokenizer(s, "* ");
        int[] tmp = new int[tokens.countTokens()];
        if (tmp.length == 0) {
            throw new IllegalArgumentException(s);
        }
        for (int i = 0; i < tmp.length; ++i) {
            int v;
            try {
                v = Integer.parseInt(tokens.nextToken());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(s);
            }
            if (v <= 1) {
                throw new IllegalArgumentException(s);
            }
            v = WADOCacheImpl.leastPrimeAsLargeAs(v);
            for (int j = 0; j < i; ++j) {
                if (v != tmp[j]) continue;
                v = WADOCacheImpl.leastPrimeAsLargeAs(v + 1);
                j = -1;
            }
            tmp[i] = v;
        }
        this.numberOfStudyBags = tmp;
    }

    public final String getImageQuality() {
        return this.imageQuality;
    }

    public final void setImageQuality(String imageQuality) {
        int intval = Integer.parseInt(imageQuality);
        if (intval <= 0 || intval > 100) {
            throw new IllegalArgumentException("imageQuality: " + imageQuality + " not between 1 and 100.");
        }
        this.imageQuality = imageQuality;
    }

    public final String getImageWriterClass() {
        return this.imageWriterClass;
    }

    public void setImageWriterClass(String imageWriterClass) {
        this.getImageWriterWriter(imageWriterClass).dispose();
        this.imageWriterClass = imageWriterClass;
    }

    private static WADOCacheImpl createWADOCache() {
        try {
            Class.forName("com.sun.image.codec.jpeg.JPEGImageEncoder");
            return new WADOCacheImplSun();
        }
        catch (ClassNotFoundException e) {
            log.info((Object)"com.sun.image.codec.jpeg.JPEGImageEncoder not available");
            return new WADOCacheImpl();
        }
    }

    public static WADOCache getWADOCache() {
        if (singletonWADO == null) {
            singletonWADO = WADOCacheImpl.createWADOCache();
        }
        return singletonWADO;
    }

    public File getImageFile(String studyUID, String seriesUID, String instanceUID, String rows, String columns, String region, String windowWidth, String windowCenter, String imageQuality, String suffix) {
        File file = this._getImageFile(rows + "-" + columns + "-" + region + "-" + windowWidth + "-" + windowCenter + "-" + WADOCacheImpl.maskNull(imageQuality, this.imageQuality), studyUID, seriesUID, instanceUID, suffix, null);
        if (log.isDebugEnabled()) {
            log.debug((Object)("check cache file(exist:" + file.exists() + "):" + file));
        }
        if (file.exists()) {
            try {
                this.journal.record(file);
            }
            catch (IOException e) {
                log.warn((Object)"Failed to record access to cache file: ", (Throwable)e);
            }
            return file;
        }
        return null;
    }

    private static String maskNull(String val, String defval) {
        return val != null ? val : defval;
    }

    public File putImage(BufferedImage image, String studyUID, String seriesUID, String instanceUID, String rows, String columns, String region, String windowWidth, String windowCenter, String imageQuality, String suffix) throws IOException {
        imageQuality = WADOCacheImpl.maskNull(imageQuality, this.imageQuality);
        File file = this._getImageFile(rows + "-" + columns + "-" + region + "-" + windowWidth + "-" + windowCenter + "-" + imageQuality, studyUID, seriesUID, instanceUID, suffix, null);
        this._writeImageFile(image, file, imageQuality);
        try {
            this.journal.record(file);
        }
        catch (IOException e) {
            file.delete();
            throw e;
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File putStream(InputStream stream, String studyUID, String seriesUID, String instanceUID, String rows, String columns, String region, String windowWidth, String windowCenter, String imageQuality, String suffix) throws IOException {
        File file = this._getImageFile(rows + "-" + columns + "-" + region + "-" + windowWidth + "-" + windowCenter + "-" + WADOCacheImpl.maskNull(imageQuality, imageQuality), studyUID, seriesUID, instanceUID, suffix, null);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        byte[] buf = new byte[65536];
        try {
            int len = stream.read(buf);
            while (len > 0) {
                out.write(buf, 0, len);
                len = stream.read(buf);
            }
        }
        finally {
            stream.close();
            out.flush();
            out.close();
        }
        try {
            this.journal.record(file);
        }
        catch (IOException e) {
            file.delete();
            throw e;
        }
        return file;
    }

    public void clearCache() {
        this.journal.clearCache();
    }

    public boolean isEmpty() {
        return this.journal.isEmpty();
    }

    public void freeDiskSpace(boolean background) throws IOException {
        long sizeToDel;
        long currFree = this.showFreeSpace();
        long minFree = this.getMinFreeSpace();
        if (log.isDebugEnabled()) {
            log.debug((Object)("WADOCache.freeDiskSpace: free:" + currFree + " minFreeSpace:" + minFree));
        }
        if ((sizeToDel = minFree - currFree) > 0L) {
            if (background) {
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            WADOCacheImpl.this.journal.free(sizeToDel);
                        }
                        catch (IOException e) {
                            log.error((Object)"Failed to free disk space: ", (Throwable)e);
                        }
                    }
                });
                t.start();
            } else {
                this.journal.free(sizeToDel);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"WADOCache.freeDiskSpace: nothing todo");
        }
    }

    public void purgeStudy(String studyIUID) {
        log.info((Object)("Delete WADO CACHE Entries for Study:" + studyIUID));
        File f = this.getStudyDir(studyIUID);
        if (f.exists()) {
            CacheJournal.deleteFileOrDirectory((File)f);
        }
    }

    public String getDeleterThresholds() {
        return this.deleterThresholds.toString();
    }

    public void setDeleterThresholds(String s) {
        this.deleterThresholds = new DeleterThresholds(s, false);
    }

    public long getMinFreeSpace() {
        return this.deleterThresholds.getDeleterThreshold(Calendar.getInstance()).getFreeSize(0L);
    }

    public long showFreeSpace() throws IOException {
        File dir = this.journal.getDataRootDir();
        long free = FileSystemUtils.freeSpace((String)dir.getPath());
        log.info((Object)("getFreeDiskSpace from :" + dir + " free:" + free));
        return free;
    }

    public boolean isClientRedirect() {
        return this.clientRedirect;
    }

    public void setClientRedirect(boolean clientRedirect) {
        this.clientRedirect = clientRedirect;
    }

    public boolean isRedirectCaching() {
        return this.redirectCaching;
    }

    public void setRedirectCaching(boolean redirectCaching) {
        this.redirectCaching = redirectCaching;
    }

    private File _getImageFile(String subdir, String studyUID, String seriesUID, String instanceUID, String suffix, String contentType) {
        String ext;
        if (contentType == null) {
            contentType = "image/jpg";
        }
        File file = this.getStudyDir(studyUID);
        file = new File(file, Integer.toHexString(seriesUID.hashCode()));
        file = new File(file, Integer.toHexString(instanceUID.hashCode()));
        if (subdir != null) {
            file = new File(file, subdir);
        }
        if ((ext = this.getFileExtension(contentType)).length() < 1) {
            file = new File(file, contentType.replace('/', '_'));
        }
        if (suffix != null) {
            instanceUID = instanceUID + suffix;
        }
        file = new File(file, instanceUID + ext);
        return file;
    }

    private File getStudyDir(String studyUID) {
        File dir = this.journal.getDataRootDir();
        int hashCode = studyUID.hashCode();
        for (int prime : this.numberOfStudyBags) {
            dir = new File(dir, Integer.toString(hashCode % prime));
        }
        return new File(dir, Integer.toHexString(hashCode));
    }

    private String getFileExtension(String contentType) {
        int pos = contentType.indexOf("/");
        String ext = "";
        if (pos != -1) {
            ext = contentType.substring(pos + 1);
            if (ext.equalsIgnoreCase("jpeg")) {
                ext = "jpg";
            } else if (ext.equalsIgnoreCase("svg+xml")) {
                ext = "svg";
            }
            ext = "." + ext;
        }
        return ext.toLowerCase();
    }

    private void _writeImageFile(BufferedImage bi, File file, String imageQuality) throws IOException {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new IOException("Can not create directory:" + file.getParentFile());
        }
        try {
            log.debug((Object)("Create JPEG (" + imageQuality + " quality) for WADO request. file: " + file));
            this.createJPEG(bi, file, Float.parseFloat(imageQuality) / 100.0f);
        }
        catch (Throwable x) {
            log.error((Object)("Can not create JPEG for WADO request. file:" + file));
            if (file.exists()) {
                file.delete();
                log.error((Object)("Cache File removed:" + file));
            }
            if (x instanceof IOException) {
                throw (IOException)x;
            }
            IOException ioe = new IOException("Failed to write image file (" + file + ")! Reason:" + x.getMessage());
            ioe.initCause(x);
            throw ioe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createJPEG(BufferedImage bi, File file, float quality) throws IOException {
        ImageWriter writer = this.getImageWriterWriter(this.imageWriterClass);
        ImageOutputStream out = ImageIO.createImageOutputStream(file);
        try {
            writer.setOutput(out);
            ImageWriteParam iwparam = writer.getDefaultWriteParam();
            iwparam.setCompressionMode(2);
            String[] compressionTypes = iwparam.getCompressionTypes();
            if (compressionTypes != null && compressionTypes.length > 0) {
                for (int i = 0; i < compressionTypes.length; ++i) {
                    if (compressionTypes[i].compareToIgnoreCase("jpeg") != 0) continue;
                    iwparam.setCompressionType(compressionTypes[i]);
                    break;
                }
            }
            iwparam.setCompressionQuality(quality);
            writer.write(null, new IIOImage(bi, null, null), iwparam);
        }
        finally {
            out.close();
            writer.dispose();
        }
    }

    private ImageWriter getImageWriterWriter(String imageWriterClass) {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("JPEG");
        while (writers.hasNext()) {
            ImageWriter writer = writers.next();
            if (!writer.getClass().getName().equals(imageWriterClass)) continue;
            return writer;
        }
        throw new ConfigurationException("No such ImageWriter - " + imageWriterClass);
    }
}

