/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.wado.mbean;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmObject;
import org.dcm4che.data.DcmObjectFactory;
import org.dcm4che.data.DcmParser;
import org.dcm4che.data.DcmParserFactory;
import org.dcm4che.data.FileMetaInfo;
import org.dcm4che.dict.DictionaryFactory;
import org.dcm4che.dict.TagDictionary;
import org.dcm4che.dict.UIDs;
import org.dcm4che.imageio.plugins.DcmMetadata;
import org.dcm4che.net.DataSource;
import org.dcm4cheri.imageio.plugins.DcmImageReadParamImpl;
import org.dcm4cheri.imageio.plugins.SimpleYBRColorSpace;
import org.dcm4cheri.util.StringUtils;
import org.dcm4chex.archive.codec.DecompressCmd;
import org.dcm4chex.archive.ejb.interfaces.AEDTO;
import org.dcm4chex.archive.ejb.interfaces.ContentManager;
import org.dcm4chex.archive.ejb.interfaces.ContentManagerHome;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionManager;
import org.dcm4chex.archive.ejb.interfaces.StudyPermissionManagerHome;
import org.dcm4chex.archive.ejb.jdbc.QueryCmd;
import org.dcm4chex.archive.exceptions.UnknownAETException;
import org.dcm4chex.archive.util.EJBHomeFactory;
import org.dcm4chex.archive.util.FileDataSource;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.wado.common.WADORequestObject;
import org.dcm4chex.wado.common.WADOResponseObject;
import org.dcm4chex.wado.mbean.WADODatasourceResponseObjectImpl;
import org.dcm4chex.wado.mbean.WADOImageResponseObjectImpl;
import org.dcm4chex.wado.mbean.WADOStreamResponseObjectImpl;
import org.dcm4chex.wado.mbean.WADOTransformResponseObjectImpl;
import org.dcm4chex.wado.mbean.cache.WADOCache;
import org.dcm4chex.wado.mbean.cache.WADOCacheImpl;
import org.dcm4chex.wado.mbean.xml.DatasetXMLResponseObject;
import org.jboss.mx.util.MBeanServerLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WADOSupport
implements NotificationListener {
    public static final String NONE = "NONE";
    private static final String REDIRECT_PARAM = "redir";
    public static final String CONTENT_TYPE_JPEG = "image/jpeg";
    public static final String CONTENT_TYPE_DICOM = "application/dicom";
    public static final String CONTENT_TYPE_DICOM_XML = "application/dicom+xml";
    public static final String CONTENT_TYPE_HTML = "text/html";
    private static final String CONTENT_TYPE_XHTML = "application/xhtml+xml";
    public static final String CONTENT_TYPE_XML = "text/xml";
    public static final String CONTENT_TYPE_PLAIN = "text/plain";
    public static final String CONTENT_TYPE_MPEG = "video/mpeg";
    private static final String SUBJECT_CONTEXT_KEY = "javax.security.auth.Subject.container";
    private static final String[] COMPRESSED_TRANSFER_SYNTAXES = new String[]{"1.2.840.10008.1.2.4.50", "1.2.840.10008.1.2.4.51", "1.2.840.10008.1.2.4.57", "1.2.840.10008.1.2.4.70", "1.2.840.10008.1.2.4.80", "1.2.840.10008.1.2.4.81", "1.2.840.10008.1.2.4.90", "1.2.840.10008.1.2.4.91", "1.2.840.10008.1.2.5"};
    private static final String ERROR_INVALID_SIMPLE_FRAME_LIST = "Error: simpleFrameList parameter is invalid! Must be a comma separated list of positive integer strings in ascending order.";
    private static final String ERROR_INVALID_CALCULATED_FRAME_LIST = "Error: calculatedFrameList parameter is invalid! Must be a comma separated list of triples of integer strings, defining non-overlapping ranges of frame numbers.";
    private static final String ERROR_SIMPLE_AND_CALCULATED_FRAME_LIST = "Error: use of simpleFrameList and calculatedFrameList parameter are mutually exclusive.";
    public static final String EVENT_TYPE_OBJECT_STORED = "org.dcm4chex.archive.dcm.storescp";
    public static final NotificationFilter NOTIF_FILTER = new NotificationFilter(){
        private static final long serialVersionUID = -7557458153348143439L;

        public boolean isNotificationEnabled(Notification notif) {
            return WADOSupport.EVENT_TYPE_OBJECT_STORED.equals(notif.getType());
        }
    };
    private static final Logger log = LoggerFactory.getLogger(WADOSupport.class);
    private static final DcmObjectFactory dof = DcmObjectFactory.getInstance();
    private ObjectName queryRetrieveScpName = null;
    private ObjectName moveScuServiceName = null;
    private ObjectName auditLogName = null;
    private ObjectName storeScpServiceName = null;
    private Set disabledAuditLogHosts;
    private boolean useTransferSyntaxOfFileAsDefault = true;
    private boolean disableDNS = false;
    private Map textSopCuids = null;
    private Map imageSopCuids = null;
    private Map videoSopCuids = new TreeMap();
    private Map encapsSopCuids = new TreeMap();
    private static MBeanServer server;
    private static TagDictionary dict;
    private String htmlXslURL = "resource:xsl/sr_html.xsl";
    private String xhtmlXslURL = "resource:xsl/sr_html.xsl";
    private String xmlXslURL = "resource:xsl/sr_xml_style.xsl";
    private String dicomXslURL = "resource:xsl/dicom_html.xsl";
    private String contentTypeDicomXML;
    private Map mapTemplates = new HashMap();
    private String srImageRows;
    private boolean disableCache;
    private boolean renderOverlays = false;
    private static final Map<String, String> waitIUIDs;
    private static final Map<String, List<String>> moveSeriesIUIDs;
    private long fetchTimeout;
    private String destAET;
    private boolean useSeriesLevelFetch;
    private boolean forceRGB;
    private static final byte[] icmColorValues;
    private static final byte[] bitSwapLut;

    public boolean isRenderOverlays() {
        return this.renderOverlays;
    }

    public void setRenderOverlays(boolean renderOverlays) {
        this.renderOverlays = renderOverlays;
    }

    public boolean isForceRGB() {
        return this.forceRGB;
    }

    public void setForceRGB(boolean forceRGB) {
        this.forceRGB = forceRGB;
    }

    public WADOSupport(MBeanServer mbServer) {
        server = server != null ? mbServer : MBeanServerLocator.locate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WADOResponseObject getWADOObject(WADORequestObject req) throws Exception {
        WADOResponseObject scResp;
        log.info("Get WADO object for " + req.getObjectUID());
        Dataset objectDs = null;
        QueryCmd cmd = null;
        log.debug("isStudyPermissionCheckDisabled:" + req.isStudyPermissionCheckDisabled());
        if (!this.hasPermission(req)) {
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 401, "Permission denied for:" + req.getObjectUID());
        }
        if (!this.disableCache && req.getContentTypes() != null && req.getContentTypes().contains(CONTENT_TYPE_JPEG) && (scResp = this.tryToShortCircuitIconCacheLookup(req)) != null) {
            return scResp;
        }
        try {
            Dataset dsQ = dof.newDataset();
            dsQ.putUI(524312, req.getObjectUID());
            dsQ.putUI(524310);
            dsQ.putLO(0x100020);
            dsQ.putPN(0x100010);
            dsQ.putUI(0x20000D);
            dsQ.putUI(0x20000E);
            dsQ.putUI(4325394);
            dsQ.putCS(524370, "IMAGE");
            cmd = QueryCmd.create((Dataset)dsQ, null, (boolean)true, (boolean)false, (boolean)true, (boolean)false, null);
            cmd.execute();
            if (cmd.next()) {
                objectDs = cmd.getDataset();
            }
        }
        catch (SQLException x) {
            log.error("Cant get DICOM Object file reference for " + req.getObjectUID(), (Throwable)x);
        }
        finally {
            if (cmd != null) {
                cmd.close();
            }
        }
        log.debug("Found object:" + req.getObjectUID() + ":");
        log.trace("ObjectDS: {}", objectDs);
        if (objectDs == null) {
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 404, "DICOM object not found! objectUID:" + req.getObjectUID());
        }
        String contentType = this.getPrefContentType(req, objectDs);
        log.debug("preferred ContentType:" + contentType);
        WADOResponseObject resp = null;
        if (contentType == null) {
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_HTML, 406, "Requested object can not be served as requested content type! Requested contentType(s):" + req.getRequest().getParameter("contentType"));
        }
        req.setObjectInfo(objectDs);
        if (CONTENT_TYPE_JPEG.equals(contentType)) {
            return this.handleJpg(req);
        }
        if (CONTENT_TYPE_DICOM.equals(contentType)) {
            return this.handleDicom(req);
        }
        File file = null;
        try {
            file = this.getDICOMFile(req.getStudyUID(), req.getSeriesUID(), req.getObjectUID());
            if (file == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Dicom object not found: " + req);
                }
                return new WADOStreamResponseObjectImpl(null, contentType, 404, "DICOM object not found!");
            }
        }
        catch (IOException x) {
            log.error("Exception in getWADOObject: " + x.getMessage(), (Throwable)x);
            return new WADOStreamResponseObjectImpl(null, contentType, 500, "Unexpected error! Cant get file");
        }
        catch (NeedRedirectionException nre) {
            return this.handleNeedRedirectException(req, contentType, nre);
        }
        String sopCuid = objectDs.getString(524310);
        if (CONTENT_TYPE_DICOM_XML.equals(contentType)) {
            if (dict == null) {
                dict = DictionaryFactory.getInstance().getDefaultTagDictionary();
            }
            resp = this.handleTextTransform(req, file, this.contentTypeDicomXML, this.getDicomXslURL(), dict);
        } else if (this.getEncapsulatedSopCuids().containsValue(sopCuid)) {
            resp = this.handleEncaps(file, contentType);
        } else if (this.getVideoSopCuids().containsValue(sopCuid)) {
            resp = this.handleVideo(file);
        } else if (CONTENT_TYPE_HTML.equals(contentType)) {
            resp = this.handleTextTransform(req, file, contentType, this.getHtmlXslURL(), null);
        } else if (CONTENT_TYPE_XHTML.equals(contentType)) {
            resp = this.handleTextTransform(req, file, contentType, this.getXHtmlXslURL(), null);
        } else if (CONTENT_TYPE_XML.equals(contentType)) {
            resp = this.handleTextTransform(req, file, CONTENT_TYPE_XML, this.getXmlXslURL(), null);
        } else {
            log.debug("Content type not supported! :" + contentType + "\nrequested contentType(s):" + req.getContentTypes() + " SOP Class UID:" + objectDs.getString(524310));
            resp = new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_DICOM, 501, "This method is not implemented for requested (preferred) content type!" + contentType);
        }
        return resp;
    }

    private WADOResponseObject tryToShortCircuitIconCacheLookup(WADORequestObject req) {
        try {
            File file;
            int frame;
            log.debug("trying to short-circuit icon cache lookup!");
            String frameNumber = req.getFrameNumber();
            String suffix = null;
            if (frameNumber != null && (frame = Integer.parseInt(frameNumber) - 1) > 0) {
                suffix = "-" + frame;
            }
            if ((file = WADOCacheImpl.getWADOCache().getImageFile(req.getStudyUID(), req.getSeriesUID(), req.getObjectUID(), req.getRows(), req.getColumns(), req.getRegion(), req.getWindowWidth(), req.getWindowCenter(), req.getImageQuality(), suffix)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("short-circuit sucessful!: " + file);
                }
                return new WADOStreamResponseObjectImpl(new FileInputStream(file), CONTENT_TYPE_JPEG, 200, null);
            }
            log.debug("no luck trying to short circuit icon lookup, following regular procedure");
        }
        catch (Exception scEx) {
            log.debug("Caught trying to shortcircuit Icon Wado Response:", (Throwable)scEx);
        }
        return null;
    }

    private WADOResponseObject handleNeedRedirectException(WADORequestObject req, String contentType, NeedRedirectionException nre) {
        if (nre.getExternalRetrieveAET() == null) {
            return new WADOStreamResponseObjectImpl(null, contentType, 500, nre.getMessage());
        }
        if (req.getRequest().getParameter(REDIRECT_PARAM) != null) {
            log.warn("WADO request is already redirected! Return 'NOT FOUND' to avoid circular redirect!\n(Maybe a filesystem was removed from filesystem management but already exists in database!)");
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_JPEG, 404, "Object not found (Circular redirect found)!");
        }
        if (!WADOCacheImpl.getWADOCache().isClientRedirect()) {
            return this.getRemoteWADOObject(nre.getExternalRetrieveAET(), req);
        }
        return new WADOStreamResponseObjectImpl(null, contentType, 307, this.getRedirectURL(nre.getExternalRetrieveAET(), req).toString());
    }

    private boolean hasPermission(WADORequestObject req) throws PolicyContextException, RemoteException, Exception {
        if (req.getRemoteUser() == null || req.isStudyPermissionCheckDisabled()) {
            log.debug("StudyPermission check disabled!");
            return true;
        }
        Subject subject = (Subject)PolicyContext.getContext((String)SUBJECT_CONTEXT_KEY);
        return this.getStudyPermissionManager().hasPermission(req.getStudyUID(), "R", subject);
    }

    private String getPrefContentType(WADORequestObject req, Dataset objectDs) {
        List contentTypes = req.getContentTypes();
        List supportedContentTypes = this.getSupportedContentTypes(objectDs);
        if (log.isDebugEnabled()) {
            log.debug("Requested content Types:" + contentTypes);
            log.debug("supported content Types:" + supportedContentTypes);
        }
        if (contentTypes == null) {
            return supportedContentTypes.get(0).toString();
        }
        contentTypes.retainAll(supportedContentTypes);
        if (!contentTypes.isEmpty()) {
            return contentTypes.get(0).toString();
        }
        return null;
    }

    private List getSupportedContentTypes(Dataset objectDs) {
        ArrayList<String> types = new ArrayList<String>();
        String sopCuid = objectDs.getString(524310);
        if (this.getTextSopCuids().containsValue(sopCuid)) {
            types.add(CONTENT_TYPE_HTML);
            types.add(CONTENT_TYPE_XHTML);
            types.add(CONTENT_TYPE_XML);
            types.add(CONTENT_TYPE_PLAIN);
        } else if (this.getImageSopCuids().containsValue(sopCuid)) {
            types.add(CONTENT_TYPE_JPEG);
        } else if (this.getEncapsulatedSopCuids().containsValue(sopCuid)) {
            String mime = objectDs.getString(4325394);
            if (mime == null) {
                mime = "application/octet-stream";
            }
            log.info("Mime type of encapsulated document:" + mime);
            types.add(mime);
        } else if (this.getVideoSopCuids().containsValue(sopCuid)) {
            types.add(CONTENT_TYPE_MPEG);
        }
        types.add(CONTENT_TYPE_DICOM);
        if (!NONE.equals(this.contentTypeDicomXML)) {
            types.add(CONTENT_TYPE_DICOM_XML);
        }
        return types;
    }

    public WADOResponseObject handleDicom(WADORequestObject req) {
        File file = null;
        try {
            file = this.getDICOMFile(req.getStudyUID(), req.getSeriesUID(), req.getObjectUID());
            if (file == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Dicom object not found: " + req);
                }
                return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_DICOM, 404, "DICOM object not found!");
            }
        }
        catch (IOException x) {
            log.error("Exception in handleDicom: " + x.getMessage(), (Throwable)x);
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_DICOM, 500, "Unexpected error! Cant get dicom object");
        }
        catch (NeedRedirectionException nre) {
            return this.handleNeedRedirectException(req, CONTENT_TYPE_DICOM, nre);
        }
        if ("true".equals(req.getRequest().getParameter("useOrig"))) {
            try {
                WADOStreamResponseObjectImpl resp = new WADOStreamResponseObjectImpl(new FileInputStream(file), CONTENT_TYPE_DICOM, 200, null);
                log.info("Original Dicom object file retrieved (useOrig=true) objectUID:" + req.getObjectUID());
                Dataset ds = req.getObjectInfo();
                ds.putPN(0x100010, ds.getString(0x100010) + " (orig)");
                resp.setPatInfo(ds);
                return resp;
            }
            catch (FileNotFoundException e) {
                log.error("Dicom File not found (useOrig=true)! file:" + file);
                return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_DICOM, 500, "Unexpected error! Cant get dicom object");
            }
        }
        return this.getUpdatedInstance(req, this.checkTransferSyntax(req.getTransferSyntax()));
    }

    private WADOResponseObject handleEncaps(File file, String contentType) {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            DataInputStream dis = new DataInputStream(is);
            DcmParser parser = DcmParserFactory.getInstance().newDcmParser((InputStream)dis);
            parser.parseDcmFile(null, 4325393);
            long len = parser.getReadLength();
            log.debug("read length of encapsulated document:" + len);
            return new WADOStreamResponseObjectImpl(is, len, contentType, 200, null);
        }
        catch (Exception x) {
            log.error("Cant get content from encapsulated DICOM storage object! file:" + file);
            return new WADOStreamResponseObjectImpl(null, contentType, 500, "Unexpected error! Cant get content from encapsulated DICOM storage object!");
        }
    }

    private WADOResponseObject handleVideo(File file) {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            DataInputStream dis = new DataInputStream(is);
            DcmParser parser = DcmParserFactory.getInstance().newDcmParser((InputStream)dis);
            parser.parseDcmFile(null, 2145386512);
            parser.parseHeader();
            int offsetTableLen = parser.getReadLength();
            if (offsetTableLen != 0) {
                log.warn("OffsetTable len is not 0!");
            }
            parser.parseHeader();
            long len = parser.getReadLength();
            log.debug("read length of mpeg2 data:" + len);
            return new WADOStreamResponseObjectImpl(is, len, CONTENT_TYPE_MPEG, 200, null);
        }
        catch (Exception x) {
            log.error("Cant get mpeg2 data! file:" + file);
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_MPEG, 500, "Unexpected error! Cant get mpeg2 data!");
        }
    }

    private String checkTransferSyntax(String transferSyntax) {
        if (transferSyntax == null) {
            if (!this.useTransferSyntaxOfFileAsDefault) {
                return "1.2.840.10008.1.2.1";
            }
            return null;
        }
        if (!UIDs.isValid((String)transferSyntax)) {
            log.warn("WADO parameter transferSyntax is not a valid UID! Use Explicit VR little endian instead! transferSyntax:" + transferSyntax);
            return "1.2.840.10008.1.2.1";
        }
        if (transferSyntax.equals("1.2.840.10008.1.2") || transferSyntax.equals("1.2.840.10008.1.2.2")) {
            log.warn("WADO parameter transferSyntax should neither Implicit VR, nor Big Endian! Use Explicit VR little endian instead! transferSyntax:" + transferSyntax);
            return "1.2.840.10008.1.2.1";
        }
        return transferSyntax;
    }

    private static int[] parseInts(String s) {
        if (s == null) {
            return null;
        }
        String[] ss = s.split(",");
        if (ss.length == 0) {
            throw new IllegalArgumentException();
        }
        int[] frameList = new int[ss.length];
        for (int i = 0; i < frameList.length; ++i) {
            frameList[i] = Integer.parseInt(ss[i].trim());
        }
        return frameList;
    }

    private WADOResponseObject getUpdatedInstance(WADORequestObject req, String transferSyntax) {
        String iuid = req.getObjectUID();
        FileDataSource ds = null;
        try {
            ds = (FileDataSource)server.invoke(this.queryRetrieveScpName, "getDatasourceOfInstance", new Object[]{iuid}, new String[]{String.class.getName()});
            Dataset d = ds.getMergeAttrs();
            ds.setWriteFile(true);
            ds.setExcludePrivate(req.isExcludePrivate());
            try {
                ds.setSimpleFrameList(WADOSupport.parseInts(req.getSimpleFrameList()));
            }
            catch (IllegalArgumentException iae) {
                return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_DICOM, 400, ERROR_INVALID_SIMPLE_FRAME_LIST);
            }
            try {
                ds.setCalculatedFrameList(WADOSupport.parseInts(req.getCalculatedFrameList()));
            }
            catch (IllegalStateException ise) {
                return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_DICOM, 400, ERROR_SIMPLE_AND_CALCULATED_FRAME_LIST);
            }
            catch (IllegalArgumentException iae) {
                return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_DICOM, 400, ERROR_INVALID_CALCULATED_FRAME_LIST);
            }
            WADODatasourceResponseObjectImpl resp = new WADODatasourceResponseObjectImpl((DataSource)ds, transferSyntax, CONTENT_TYPE_DICOM, 200, null);
            resp.setPatInfo(d);
            return resp;
        }
        catch (Exception e) {
            log.error("Failed to get updated DICOM file", (Throwable)e);
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_DICOM, 500, "Unexpected error! Cant get updated dicom object");
        }
    }

    public WADOResponseObject handleJpg(WADORequestObject req) {
        String studyUID = req.getStudyUID();
        String seriesUID = req.getSeriesUID();
        String instanceUID = req.getObjectUID();
        String rows = req.getRows();
        String columns = req.getColumns();
        String frameNumber = req.getFrameNumber();
        String region = req.getRegion();
        String windowWidth = req.getWindowWidth();
        String windowCenter = req.getWindowCenter();
        String imageQuality = req.getImageQuality();
        try {
            int frame = 0;
            if (frameNumber != null) {
                frame = Integer.parseInt(frameNumber) - 1;
            }
            if (this.disableCache) {
                BufferedImage bi = this.getBufferedImage(studyUID, seriesUID, instanceUID, rows, columns, frame, region, windowWidth, windowCenter);
                return new WADOImageResponseObjectImpl(bi, CONTENT_TYPE_JPEG, 200, "Info: Caching disabled!");
            }
            File file = this.getJpg(studyUID, seriesUID, instanceUID, rows, columns, frame, region, windowWidth, windowCenter, imageQuality);
            if (file != null) {
                WADOStreamResponseObjectImpl resp = new WADOStreamResponseObjectImpl(new FileInputStream(file), CONTENT_TYPE_JPEG, 200, null);
                resp.setPatInfo(req.getObjectInfo());
                return resp;
            }
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_JPEG, 404, "DICOM object not found!");
        }
        catch (NeedRedirectionException nre) {
            return this.handleNeedRedirectException(req, CONTENT_TYPE_JPEG, nre);
        }
        catch (NoImageException x1) {
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_JPEG, 500, "Cant get jpeg from requested object");
        }
        catch (ImageCachingException x1) {
            return new WADOImageResponseObjectImpl(x1.getImage(), CONTENT_TYPE_JPEG, 200, "Warning: Caching failed!");
        }
        catch (Exception x) {
            log.error("Exception in handleJpg: " + x.getMessage(), (Throwable)x);
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_JPEG, 500, "Unexpected error! Cant get jpeg");
        }
    }

    public File getJpg(String studyUID, String seriesUID, String instanceUID, String rows, String columns, int frame, String region, String windowWidth, String windowCenter, String imageQuality) throws IOException, NeedRedirectionException, NoImageException, ImageCachingException {
        WADOCache cache = WADOCacheImpl.getWADOCache();
        BufferedImage bi = null;
        String suffix = null;
        if (frame > 0) {
            suffix = "-" + frame;
        } else {
            frame = 0;
        }
        File file = cache.getImageFile(studyUID, seriesUID, instanceUID, rows, columns, region, windowWidth, windowCenter, imageQuality, suffix);
        if (file == null) {
            bi = this.getBufferedImage(studyUID, seriesUID, instanceUID, rows, columns, frame, region, windowWidth, windowCenter);
            if (bi != null) {
                try {
                    file = cache.putImage(bi, studyUID, seriesUID, instanceUID, rows, columns, region, windowWidth, windowCenter, imageQuality, suffix);
                }
                catch (Exception x) {
                    log.warn("Error caching image file! Return image without caching (Enable DEBUG for stacktrace)!");
                    log.debug("Stacktrace for caching error:", (Throwable)x);
                    throw new ImageCachingException(bi);
                }
            } else {
                throw new NoImageException();
            }
        }
        return file;
    }

    private BufferedImage getBufferedImage(String studyUID, String seriesUID, String instanceUID, String rows, String columns, int frame, String region, String windowWidth, String windowCenter) throws IOException, NeedRedirectionException {
        File dicomFile = this.getDICOMFile(studyUID, seriesUID, instanceUID);
        if (dicomFile != null) {
            return this.getImage(dicomFile, frame, rows, columns, region, windowWidth, windowCenter);
        }
        return null;
    }

    private WADOResponseObject handleTextTransform(WADORequestObject req, File file, String contentType, String xslURL, TagDictionary dict) {
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            DcmParser parser = DcmParserFactory.getInstance().newDcmParser((InputStream)in);
            Dataset ds = dof.newDataset();
            parser.setDcmHandler(ds.getDcmHandler());
            parser.parseDcmFile(null, 2145386512);
            Dataset dsCoerce = null;
            if (!"true".equals(req.getRequest().getParameter("useOrig"))) {
                dsCoerce = this.getContentManager().getInstanceInfo(req.getObjectUID(), true);
                ds.putAll((DcmObject)dsCoerce);
            }
            if (log.isDebugEnabled()) {
                log.debug("Dataset for XSLT Transformation: {}", (Object)ds);
                log.debug("Use XSLT stylesheet:" + xslURL);
            }
            TransformerHandler th = this.getTransformerHandler(xslURL);
            if (this.srImageRows != null) {
                Transformer t = th.getTransformer();
                t.setParameter("srImageRows", this.srImageRows);
            }
            DatasetXMLResponseObject res = new DatasetXMLResponseObject(ds, th, dict);
            WADOTransformResponseObjectImpl resp = new WADOTransformResponseObjectImpl(res, contentType, 200, null);
            resp.setPatInfo(dsCoerce != null ? dsCoerce : ds);
            return resp;
        }
        catch (Exception e) {
            log.error("Failed to get DICOM file", (Throwable)e);
            return new WADOStreamResponseObjectImpl(null, contentType, 500, "Unexpected error! Cant get dicom object");
        }
    }

    public String getSrImageRows() {
        return this.srImageRows;
    }

    public void setSrImageRows(String srImageRows) {
        if (srImageRows != null) {
            Integer.parseInt(srImageRows);
        }
        this.srImageRows = srImageRows;
    }

    public String getHtmlXslURL() {
        return this.htmlXslURL;
    }

    public void setHtmlXslURL(String htmlXslURL) {
        this.htmlXslURL = htmlXslURL;
    }

    public String getXHtmlXslURL() {
        return this.xhtmlXslURL;
    }

    public void setXHtmlXslURL(String xslURL) {
        this.xhtmlXslURL = xslURL;
    }

    public String getXmlXslURL() {
        return this.xmlXslURL;
    }

    public void setXmlXslURL(String xmlXslURL) {
        this.xmlXslURL = xmlXslURL;
    }

    public String getDicomXslURL() {
        return this.dicomXslURL;
    }

    public void setDicomXslURL(String dicomXslURL) {
        this.dicomXslURL = dicomXslURL;
    }

    public String getContentTypeDicomXML() {
        return this.contentTypeDicomXML;
    }

    public void setContentTypeDicomXML(String contentTypeDicomXML) {
        this.contentTypeDicomXML = contentTypeDicomXML;
    }

    private TransformerHandler getTransformerHandler(String xslt) throws TransformerConfigurationException {
        TransformerHandler th;
        SAXTransformerFactory tf = (SAXTransformerFactory)TransformerFactory.newInstance();
        if (xslt != null && !xslt.equalsIgnoreCase(NONE)) {
            Templates stylesheet = (Templates)this.mapTemplates.get(xslt);
            if (stylesheet == null) {
                String xsltUrl;
                try {
                    xsltUrl = xslt.indexOf(58) < 2 ? FileUtils.resolve((File)new File(xslt)).toURL().toString() : (xslt.startsWith("file:") ? FileUtils.resolve((File)new File(xslt.substring(5))).toURL().toString() : xslt);
                }
                catch (MalformedURLException x) {
                    log.warn("Invalid XSL URL:" + xslt);
                    xsltUrl = xslt;
                }
                stylesheet = tf.newTemplates(new StreamSource(xsltUrl));
                this.mapTemplates.put(xslt, stylesheet);
            }
            th = tf.newTransformerHandler(stylesheet);
        } else {
            th = tf.newTransformerHandler();
        }
        return th;
    }

    public void clearTemplateCache() {
        this.mapTemplates.clear();
    }

    public File getDICOMFile(String studyUID, String seriesUID, String instanceUID) throws IOException, NeedRedirectionException {
        Object dicomObject = null;
        try {
            dicomObject = server.invoke(this.queryRetrieveScpName, "locateInstance", new Object[]{instanceUID, studyUID}, new String[]{String.class.getName(), String.class.getName()});
        }
        catch (Exception e) {
            if (e.getCause() instanceof UnknownAETException) {
                throw new NeedRedirectionException("Can't redirect WADO request to external retrieve AET! Unknown AET:" + e.getCause().getMessage(), null);
            }
            log.error("Failed to get DICOM file:" + instanceUID, (Throwable)e);
        }
        if (dicomObject == null) {
            return null;
        }
        if (dicomObject instanceof File) {
            return (File)dicomObject;
        }
        if (dicomObject instanceof AEDTO) {
            AEDTO ae = (AEDTO)dicomObject;
            if ("DICOM_QR_ONLY".equals(ae.getWadoURL())) {
                return this.fetchFromExternalRetrieveAET(ae, studyUID, seriesUID, instanceUID);
            }
            throw new NeedRedirectionException(null, (AEDTO)dicomObject);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File fetchFromExternalRetrieveAET(AEDTO ae, String studyUID, String seriesUID, String iuid) throws IOException, NeedRedirectionException {
        try {
            Dataset ds = this.getContentManager().getInstanceInfo(iuid, true);
            studyUID = ds.getString(0x20000D);
            seriesUID = ds.getString(0x20000E);
        }
        catch (Exception x) {
            log.warn("Failed to get StudyIUID and SeriesIUID for instance:" + iuid, (Throwable)x);
        }
        log.info("Fetch series of instance(" + iuid + ") from external retrieve AET (stated as 'DICOM_QR_ONLY'):" + ae + " studyIUID:" + studyUID + " seriesIUID:" + seriesUID);
        if (waitIUIDs.isEmpty()) {
            log.debug("Add ObjectStored Notification listener!");
            try {
                server.addNotificationListener(this.getStoreScpServiceName(), this, NOTIF_FILTER, null);
            }
            catch (InstanceNotFoundException x) {
                log.warn("Add ObjectStoredNotificationListener failed! Schedule move request anyway.");
            }
        }
        waitIUIDs.put(iuid, iuid);
        List<String> iuids = moveSeriesIUIDs.get(seriesUID);
        if (iuids == null) {
            iuids = new ArrayList<String>();
            moveSeriesIUIDs.put(seriesUID, iuids);
            this.scheduleMove(ae == null ? null : ae.getTitle(), studyUID, seriesUID);
        }
        iuids.add(iuid);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Wait for receive instance! iuid:" + iuid);
            }
            String string = iuid;
            synchronized (string) {
                iuid.wait(this.fetchTimeout);
            }
            if (log.isDebugEnabled()) {
                log.debug("Finished waiting for receive instance! iuid:" + iuid);
            }
            if (waitIUIDs.remove(iuid) != null) {
                log.warn("Waiting for receive instance timed out!");
                throw new NeedRedirectionException("Requested object is not locally available and waiting for fetched object has timed out! Please try again!", null);
            }
            File f = this.getDICOMFile(studyUID, seriesUID, iuid);
            if (log.isDebugEnabled()) {
                log.debug("File of fetched object:" + f.getName());
            }
            File file = f;
            return file;
        }
        catch (InterruptedException x) {
            log.warn("Wait for fetching instance (" + iuid + ") interrupted!", (Throwable)x);
            throw new NeedRedirectionException("Requested object is not locally available and waiting for fetched object was interrupted! Please try again!", null);
        }
        finally {
            if (waitIUIDs.isEmpty()) {
                log.debug("Remove ObjectStored Notification listener!");
                try {
                    server.removeNotificationListener(this.getStoreScpServiceName(), this, NOTIF_FILTER, null);
                }
                catch (Exception x) {
                    log.warn("Remove ObjectStoredNotificationListener failed!");
                }
                moveSeriesIUIDs.clear();
            } else {
                iuids.remove(iuid);
                if (iuids.isEmpty()) {
                    moveSeriesIUIDs.remove(iuids);
                }
            }
        }
    }

    private void scheduleMove(String retrAET, String studyUID, String seriesUID) throws NeedRedirectionException {
        if (log.isDebugEnabled()) {
            log.debug("Schedule C-MOVE request for series" + seriesUID + " useSeriesLevel:" + this.useSeriesLevelFetch);
        }
        String[] iuids = this.useSeriesLevelFetch ? null : this.getIUIDsToFetch(seriesUID, retrAET);
        try {
            server.invoke(this.getMoveScuServiceName(), "scheduleMove", new Object[]{retrAET, this.destAET, 0, null, studyUID, seriesUID, iuids, 0}, new String[]{String.class.getName(), String.class.getName(), Integer.TYPE.getName(), String.class.getName(), String.class.getName(), String.class.getName(), String[].class.getName(), Long.TYPE.getName()});
        }
        catch (Exception x) {
            log.warn("Scheduling C-MOVE failed!", (Throwable)x);
            throw new NeedRedirectionException("Requested object is not locally available and can't be fetched from remote system!", null);
        }
    }

    private String[] getIUIDsToFetch(String seriesUID, String retrAET) {
        ArrayList iuids = new ArrayList();
        try {
            Map map = (Map)server.invoke(this.queryRetrieveScpName, "locateInstancesOfSeries", new Object[]{seriesUID, null}, new String[]{String.class.getName(), String.class.getName()});
            for (Map.Entry entry : map.entrySet()) {
                if (!(entry.getValue() instanceof String) || !retrAET.equals(entry.getValue())) continue;
                iuids.add(entry.getKey());
            }
        }
        catch (Exception e) {
            log.warn("Can't get IUIDs for series to fetch object from external retrieve AET! Force SERIES level fetching");
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("Found instances to fetch from AE " + retrAET + " iuids:" + iuids);
        }
        return iuids.isEmpty() ? null : iuids.toArray(new String[iuids.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectReceived(Dataset ds) throws IOException, NeedRedirectionException {
        String iuid = waitIUIDs.remove(ds.getString(524312));
        if (log.isDebugEnabled()) {
            log.debug("Object received! iuid:" + ds.getString(524312) + ", is waiting? :" + (iuid != null));
        }
        if (iuid != null) {
            String string = iuid;
            synchronized (string) {
                iuid.notifyAll();
            }
        }
    }

    private URL getRedirectURL(AEDTO aedto, WADORequestObject req) {
        URL url = null;
        try {
            URL reqURL = new URL(req.getRequestURL());
            if (aedto.getWadoURL() != null) {
                URL baseURL = new URL(aedto.getWadoURL());
                StringBuffer sbQuery = new StringBuffer();
                sbQuery.append('?').append(REDIRECT_PARAM).append("=true");
                sbQuery.append('&').append(reqURL.getQuery());
                String baseQuery = baseURL.getQuery();
                if (baseQuery != null && !baseQuery.equals("requestType=WADO")) {
                    sbQuery.append('&').append(baseQuery);
                }
                url = new URL(baseURL.getProtocol(), baseURL.getHost(), baseURL.getPort(), baseURL.getPath() + sbQuery);
            } else {
                url = new URL(reqURL.getProtocol(), aedto.getHostName(), reqURL.getPort(), reqURL.getFile());
            }
        }
        catch (MalformedURLException e) {
            log.error("Malformed redirect URL to remote AET:" + aedto + " wadoURL:" + aedto.getWadoURL(), (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug("redirect url:" + url);
        }
        return url;
    }

    private WADOResponseObject getRemoteWADOObject(AEDTO aedto, WADORequestObject req) {
        if (log.isInfoEnabled()) {
            log.info("WADO request redirected to aedto:" + aedto.getHostName() + " WADO URL:" + aedto.getWadoURL());
        }
        URL url = null;
        try {
            url = this.getRedirectURL(aedto, req);
            if (log.isDebugEnabled()) {
                log.debug("redirect url:" + url);
            }
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            String authHeader = (String)req.getRequestHeaders().get("Authorization");
            if (authHeader != null) {
                conn.addRequestProperty("Authorization", authHeader);
            }
            conn.connect();
            if (log.isDebugEnabled()) {
                log.debug("conn.getResponseCode():" + conn.getResponseCode());
            }
            if (conn.getResponseCode() != 200) {
                if (log.isInfoEnabled()) {
                    log.info("Remote WADO server responses with:" + conn.getResponseMessage());
                }
                return new WADOStreamResponseObjectImpl(null, conn.getContentType(), conn.getResponseCode(), conn.getResponseMessage());
            }
            InputStream is = conn.getInputStream();
            if (WADOCacheImpl.getWADOCache().isRedirectCaching() && CONTENT_TYPE_JPEG.equals(conn.getContentType())) {
                String suffix = req.getFrameNumber();
                if (suffix != null && suffix.equals("0")) {
                    suffix = null;
                }
                File file = WADOCacheImpl.getWADOCache().putStream(is, req.getStudyUID(), req.getSeriesUID(), req.getObjectUID(), req.getRows(), req.getColumns(), req.getRegion(), req.getWindowWidth(), req.getWindowCenter(), req.getImageQuality(), suffix);
                is = new FileInputStream(file);
            }
            return new WADOStreamResponseObjectImpl(is, conn.getContentType(), 200, null);
        }
        catch (Exception e) {
            log.error("Can't connect to remote WADO service:" + url, (Throwable)e);
            return new WADOStreamResponseObjectImpl(null, CONTENT_TYPE_JPEG, 404, "Redirect to find requested object failed! (Can't connect to remote WADO service:" + url + ")!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getImage(File file, int frame, String rows, String columns, String region, String windowWidth, String windowCenter) throws IOException {
        ImageReader reader = this.getDicomImageReader();
        if (reader == null) {
            return null;
        }
        FileImageInputStream in = new FileImageInputStream(file);
        boolean semaphoreAquired = false;
        try {
            reader.setInput(in, false);
            BufferedImage bi = null;
            Rectangle regionRectangle = null;
            try {
                ImageReadParam param = reader.getDefaultReadParam();
                int totWidth = reader.getWidth(0);
                int totHeight = reader.getHeight(0);
                if (region != null) {
                    String[] ss = StringUtils.split((String)region, (char)',');
                    int topX = (int)Math.round(Double.parseDouble(ss[0]) * (double)totWidth);
                    int topY = (int)Math.round(Double.parseDouble(ss[1]) * (double)totHeight);
                    int botX = (int)Math.round(Double.parseDouble(ss[2]) * (double)totWidth);
                    int botY = (int)Math.round(Double.parseDouble(ss[3]) * (double)totHeight);
                    int w = botX - topX;
                    int h = botY - topY;
                    regionRectangle = new Rectangle(topX, topY, w, h);
                    param.setSourceRegion(regionRectangle);
                }
                Dataset data = ((DcmMetadata)reader.getStreamMetadata()).getDataset();
                if (windowWidth != null && windowCenter != null) {
                    data.putDS(2625617, windowWidth);
                    data.putDS(2625616, windowCenter);
                }
                DcmImageReadParamImpl dcmParam = (DcmImageReadParamImpl)param;
                if (WADOSupport.isCompressed(data)) {
                    semaphoreAquired = DecompressCmd.acquireSemaphore();
                    log.info("start decompression of image: " + totHeight + "x" + totWidth + " (current codec tasks: compress&decompress:" + DecompressCmd.getNrOfConcurrentCodec() + " compress:" + DecompressCmd.getNrOfConcurrentDecompress() + ")");
                }
                bi = reader.read(frame, (ImageReadParam)dcmParam);
            }
            catch (Exception x) {
                log.error("Can't read image:", (Throwable)x);
                BufferedImage bufferedImage = null;
                if (semaphoreAquired) {
                    DecompressCmd.finished();
                    log.info("finished decompression. (remaining codec tasks: compress&decompress:" + DecompressCmd.getNrOfConcurrentCodec() + " decompress:" + DecompressCmd.getNrOfConcurrentDecompress() + ")");
                    DecompressCmd.releaseSemaphore();
                }
                in.close();
                return bufferedImage;
            }
            if (this.renderOverlays) {
                this.mergeOverlays(bi, reader, frame);
            }
            BufferedImage bufferedImage = this.resize(bi, rows, columns, reader.getAspectRatio(frame));
            return bufferedImage;
        }
        finally {
            if (semaphoreAquired) {
                DecompressCmd.finished();
                log.info("finished decompression. (remaining codec tasks: compress&decompress:" + DecompressCmd.getNrOfConcurrentCodec() + " decompress:" + DecompressCmd.getNrOfConcurrentDecompress() + ")");
                DecompressCmd.releaseSemaphore();
            }
            in.close();
        }
    }

    private static boolean isCompressed(Dataset data) {
        FileMetaInfo fmi = data.getFileMetaInfo();
        if (fmi == null) {
            return false;
        }
        String tsuid = fmi.getTransferSyntaxUID();
        for (String ctsuid : COMPRESSED_TRANSFER_SYNTAXES) {
            if (!ctsuid.equals(tsuid)) continue;
            return true;
        }
        return false;
    }

    private ImageReader getDicomImageReader() {
        Iterator<ImageReader> it = ImageIO.getImageReadersByFormatName("DICOM");
        while (it.hasNext()) {
            ImageReader reader = it.next();
            if (!reader.getClass().getName().equals("org.dcm4cheri.imageio.plugins.DcmImageReader")) continue;
            return reader;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage resize(BufferedImage bi, String rows, String columns, float aspectRatio) {
        boolean rescale;
        int h = 0;
        int w = 0;
        if (rows == null && columns == null) {
            h = bi.getHeight();
            w = bi.getWidth();
        } else {
            if (rows != null) {
                h = Integer.parseInt(rows);
            }
            if (columns != null) {
                w = Integer.parseInt(columns);
            }
        }
        if (h == 0 || w != 0 && (float)h * aspectRatio > (float)w) {
            h = (int)((float)w / aspectRatio + 0.5f);
        } else {
            w = (int)((float)h * aspectRatio + 0.5f);
        }
        boolean needRGB = bi.getColorModel().getColorSpace() instanceof SimpleYBRColorSpace || this.forceRGB && bi.getColorModel().getPixelSize() > 8;
        boolean bl = rescale = w != bi.getWidth() || h != bi.getHeight();
        if (!needRGB && !rescale) {
            return bi;
        }
        if (needRGB || bi.getSampleModel() instanceof BandedSampleModel) {
            log.debug("Convert BufferedImage to TYPE_INT_RGB!");
            BufferedImage tmp = new BufferedImage(bi.getWidth(), bi.getHeight(), 1);
            Graphics2D g = tmp.createGraphics();
            try {
                g.drawImage((Image)bi, 0, 0, null);
            }
            finally {
                g.dispose();
            }
            bi = tmp;
        }
        if (!rescale) {
            return bi;
        }
        AffineTransform scale = AffineTransform.getScaleInstance((double)w / (double)bi.getWidth(), (double)h / (double)bi.getHeight());
        AffineTransformOp scaleOp = new AffineTransformOp(scale, 1);
        BufferedImage biDest = scaleOp.filter(bi, null);
        return biDest;
    }

    private void mergeOverlays(BufferedImage bi, ImageReader reader, int frame) throws IOException {
        Dataset ds = ((DcmMetadata)reader.getStreamMetadata()).getDataset();
        long t1 = System.currentTimeMillis();
        ArrayList<Integer> oldStyleOverlayPlanes = new ArrayList<Integer>();
        for (int group = 0; group < 32; group += 2) {
            try {
                int oBitPosition = WADOSupport.getInt(ds, group, 1610612994, -1);
                int oRows = WADOSupport.getInt(ds, group, 0x60000010, -1);
                int oCols = WADOSupport.getInt(ds, group, 0x60000011, -1);
                int[] oOrigin = WADOSupport.getInts(ds, group, 0x60000050);
                int oBitsAllocated = WADOSupport.getInt(ds, group, 0x60000100, -1);
                String oType = WADOSupport.getString(ds, group, 0x60000040);
                int oNumberOfFrames = WADOSupport.getInt(ds, group, 1610612757, 1);
                int oFrameStart = WADOSupport.getInt(ds, group, 1610612817, 1) - 1;
                int oFrameEnd = oFrameStart + oNumberOfFrames;
                if (oBitPosition == -1 && oBitsAllocated == -1 && oRows == -1 && oCols == -1) {
                    log.trace("No overlay data associated with image for group {}", (Object)group);
                    continue;
                }
                if ("R".equals(oType)) {
                    log.debug("Overlay ROI bitmap, not doing anything");
                    continue;
                }
                if (oBitsAllocated != 1 && oBitPosition != 0) {
                    log.debug("Overlay: {}  OldStyle bitPostion {}", (Object)group, (Object)oBitPosition);
                    oldStyleOverlayPlanes.add(oBitPosition);
                    continue;
                }
                if ("GR".indexOf(oType) < 0) {
                    log.warn("mergeOverlays(): Overlay Type {} not supported", (Object)oType);
                    continue;
                }
                int oX1 = 0;
                int oY1 = 0;
                if (oOrigin != null) {
                    oX1 = oOrigin[1] - 1;
                    oY1 = oOrigin[0] - 1;
                }
                log.debug("Overlay: {} OverlayType: {}", (Object)group, (Object)oType);
                log.debug("Overlay: {} OverlayRows: {}", (Object)group, (Object)oRows);
                log.debug("Overlay: {} OverlayColumns: {}", (Object)group, (Object)oCols);
                log.debug("Overlay: {} OverlayOrigin: {} {}", new Object[]{group, oX1, oY1});
                log.debug("Overlay: {} for Frames: [{}, {})", new Object[]{group, oFrameStart, oFrameEnd});
                if (oFrameStart > frame || frame >= oFrameEnd) {
                    log.debug("Overlay: frame {} not in range, skipping", (Object)frame);
                    continue;
                }
                int oFrameOffset = frame - oFrameStart;
                int bitOffset = oFrameOffset * oRows * oCols;
                int byteOffset = bitOffset / 8;
                int numBits = oRows * oCols;
                int numBytes = (numBits + 7) / 8;
                log.debug("Overlay: {} bitOffset: {}", (Object)group, (Object)bitOffset);
                log.debug("Overlay: {} byteOffset: {}", (Object)group, (Object)byteOffset);
                log.debug("Overlay: {} numBits: {}", (Object)group, (Object)numBits);
                log.debug("Overlay: {} numBytes: {}", (Object)group, (Object)numBytes);
                ByteBuffer bb = ds.get(WADOSupport.groupedTag(group, 0x60003000)).getByteBuffer();
                if (bb.limit() == 0) {
                    log.warn("Overlay: {} Missing overlay data! Skipped.", (Object)group);
                    continue;
                }
                log.debug("Overlay: {} ByteBuffer: {}", (Object)group, (Object)bb);
                log.debug("Overlay: {} ByteBuffer ByteOrder: {}", (Object)group, (Object)(bb.order() == ByteOrder.BIG_ENDIAN ? "BigEndian" : "LittleEndian"));
                IndexColorModel icm = new IndexColorModel(1, 2, icmColorValues, icmColorValues, icmColorValues, 0);
                BufferedImage overBi = new BufferedImage(oCols, oRows, 12, icm);
                DataBufferByte dataBufferByte = (DataBufferByte)overBi.getRaster().getDataBuffer();
                byte[] dest = dataBufferByte.getData();
                int packedRowBits = oCols + 7 & 0xFFFFFFF8;
                log.debug("packed row bits: {}", (Object)packedRowBits);
                if (packedRowBits == oCols) {
                    for (int i = 0; i < numBytes; ++i) {
                        int idx = bb.get(byteOffset + i) & 0xFF;
                        dest[i] = bitSwapLut[idx];
                    }
                } else {
                    int packedRowBytes = packedRowBits / 8;
                    for (int y = 0; y < oRows; ++y) {
                        int b1;
                        int inOffset;
                        int i;
                        int size;
                        int rowBitOffset = bitOffset + y * oCols;
                        int rowByteOffset = rowBitOffset / 8;
                        int packedRowByteOffset = y * packedRowBytes;
                        int bitsToMove = rowBitOffset % 8;
                        if (bitsToMove != 0) {
                            size = packedRowBytes - 1;
                            for (i = 0; i < size; ++i) {
                                inOffset = rowByteOffset + i;
                                b1 = bb.get(inOffset) & 0xFF;
                                int b2 = bb.get(inOffset + 1) & 0xFF;
                                int rc = b1 >> bitsToMove ^ b2 << 8 - bitsToMove & 0xFF;
                                dest[packedRowByteOffset + i] = bitSwapLut[rc];
                            }
                            continue;
                        }
                        size = packedRowBytes - 1;
                        for (i = 0; i < size; ++i) {
                            inOffset = rowByteOffset + i;
                            b1 = bb.get(inOffset) & 0xFF;
                            dest[packedRowByteOffset + i] = bitSwapLut[b1];
                        }
                    }
                }
                log.debug("Overlay: {} BufferedImage: {}", (Object)group, (Object)overBi);
                Graphics2D gBi = bi.createGraphics();
                gBi.drawImage((Image)overBi, oX1, oY1, null);
                continue;
            }
            catch (Exception x) {
                log.warn("Render overlay failed! skipped frame:" + frame + " group:" + group + "!  Enable DEBUG log level to get stacktrace");
                log.debug("Reason for skipped overlay:", (Throwable)x);
            }
        }
        log.debug("Overlay: done combining overlays");
        if (oldStyleOverlayPlanes.size() > 0) {
            try {
                int bitsStored = ds.getInt(2621697, -1);
                short overlayValue = (short)((1 << bitsStored) - 1);
                DataBuffer _buffer = bi.getRaster().getDataBuffer();
                if (_buffer.getDataType() == 2 || _buffer.getDataType() == 1) {
                    int mask = 0;
                    int size = oldStyleOverlayPlanes.size();
                    for (int i = 0; i < size; ++i) {
                        int bit = (Integer)oldStyleOverlayPlanes.get(i);
                        mask |= 1 << bit;
                    }
                    DcmImageReadParamImpl param = (DcmImageReadParamImpl)reader.getDefaultReadParam();
                    param.setMaskPixelData(false);
                    param.setAutoWindowing(false);
                    BufferedImage oBi = reader.read(frame, (ImageReadParam)param);
                    DataBufferUShort oDataBuffer = (DataBufferUShort)oBi.getRaster().getDataBuffer();
                    short[] src = oDataBuffer.getData();
                    DataBufferUShort dataBuffer = (DataBufferUShort)bi.getRaster().getDataBuffer();
                    short[] dest = dataBuffer.getData();
                    log.debug("mergeOverlays(): setting oldStyleOverlays, mask used 0x" + Integer.toHexString(mask));
                    int size2 = dest.length;
                    for (int i = 0; i < size2; ++i) {
                        if ((src[i] & mask) == 0) continue;
                        dest[i] = overlayValue;
                    }
                } else {
                    log.warn("mergeOverlays(): data buffer type {} not supported", (Object)_buffer.getDataType());
                }
            }
            catch (Exception e) {
                log.error("mergeOverlays(): ERROR", (Throwable)e);
            }
        }
        long t2 = System.currentTimeMillis();
        log.info("mergeOverlays(): {}ms", (Object)(t2 - t1));
    }

    private static final byte[] makeBitSwapLut() {
        byte[] rc = new byte[256];
        for (int i = 0; i < 256; ++i) {
            rc[i] = WADOSupport.byte_reverse(i);
        }
        return rc;
    }

    private static final byte byte_reverse(int b) {
        int out = 0;
        for (int i = 0; i < 8; ++i) {
            out = out << 1 | b >> i & 1;
        }
        return (byte)out;
    }

    private static final int groupedTag(int group, int tag) {
        int x = group << 16;
        return tag + x;
    }

    private static final int getInt(Dataset ds, int group, int tag, int def) {
        return ds.getInt(WADOSupport.groupedTag(group, tag), def);
    }

    private static final int[] getInts(Dataset ds, int group, int tag) {
        return ds.getInts(WADOSupport.groupedTag(group, tag));
    }

    private static final String getString(Dataset ds, int group, int tag) {
        return ds.getString(WADOSupport.groupedTag(group, tag));
    }

    public ObjectName getQueryRetrieveScpName() {
        return this.queryRetrieveScpName;
    }

    public void setQueryRetrieveScpName(ObjectName name) {
        this.queryRetrieveScpName = name;
    }

    public void setAuditLoggerName(ObjectName name) {
        this.auditLogName = name;
    }

    public ObjectName getAuditLoggerName() {
        return this.auditLogName;
    }

    public ObjectName getStoreScpServiceName() {
        return this.storeScpServiceName;
    }

    public void setStoreScpServiceName(ObjectName storeScpServiceName) {
        this.storeScpServiceName = storeScpServiceName;
    }

    public ObjectName getMoveScuServiceName() {
        return this.moveScuServiceName;
    }

    public void setMoveScuServiceName(ObjectName moveScuServiceName) {
        this.moveScuServiceName = moveScuServiceName;
    }

    public boolean isAuditLogEnabled(WADORequestObject req) {
        return this.disabledAuditLogHosts == null ? false : !this.disabledAuditLogHosts.contains(req.getRemoteHost());
    }

    public void setDisabledAuditLogHosts(Set disabledLogHosts) {
        this.disabledAuditLogHosts = disabledLogHosts;
    }

    public Set getDisabledAuditLogHosts() {
        return this.disabledAuditLogHosts;
    }

    public boolean isDisableDNS() {
        return this.disableDNS;
    }

    public void setDisableDNS(boolean disableDNS) {
        this.disableDNS = disableDNS;
    }

    public boolean isDisableCache() {
        return this.disableCache;
    }

    public void setDisableCache(boolean disableCache) {
        this.disableCache = disableCache;
    }

    public boolean isUseTransferSyntaxOfFileAsDefault() {
        return this.useTransferSyntaxOfFileAsDefault;
    }

    public void setUseTransferSyntaxOfFileAsDefault(boolean useTransferSyntaxOfFileAsDefault) {
        this.useTransferSyntaxOfFileAsDefault = useTransferSyntaxOfFileAsDefault;
    }

    public Map getImageSopCuids() {
        if (this.imageSopCuids == null) {
            try {
                this.imageSopCuids = this.uidsString2map((String)server.getAttribute(this.storeScpServiceName, "AcceptedImageSOPClasses"));
            }
            catch (Exception x) {
                log.error("Cant get list of image SOP Class UIDs!", (Throwable)x);
            }
        }
        return this.imageSopCuids;
    }

    public Map getTextSopCuids() {
        if (this.textSopCuids == null) {
            this.setDefaultTextSopCuids();
        }
        return this.textSopCuids;
    }

    public void setTextSopCuids(String sopCuids) {
        if (sopCuids != null && sopCuids.trim().length() > 0) {
            this.textSopCuids = this.uidsString2map(sopCuids);
        } else {
            this.setDefaultTextSopCuids();
        }
    }

    public Map getEncapsulatedSopCuids() {
        return this.encapsSopCuids;
    }

    public void setEncapsulatedSopCuids(String sopCuids) {
        if (sopCuids != null && !NONE.equalsIgnoreCase(sopCuids.trim())) {
            this.encapsSopCuids = this.uidsString2map(sopCuids);
        } else {
            this.encapsSopCuids.clear();
        }
    }

    public Map getVideoSopCuids() {
        return this.videoSopCuids;
    }

    public void setVideoSopCuids(String sopCuids) {
        if (sopCuids != null && !NONE.equalsIgnoreCase(sopCuids.trim())) {
            this.videoSopCuids = this.uidsString2map(sopCuids);
        } else {
            this.videoSopCuids.clear();
        }
    }

    private void setDefaultTextSopCuids() {
        if (this.textSopCuids == null) {
            this.textSopCuids = new TreeMap();
        } else {
            this.textSopCuids.clear();
        }
        this.textSopCuids.put("BasicTextSR", "1.2.840.10008.5.1.4.1.1.88.11");
        this.textSopCuids.put("ChestCADSR", "1.2.840.10008.5.1.4.1.1.88.65");
        this.textSopCuids.put("ComprehensiveSR", "1.2.840.10008.5.1.4.1.1.88.33");
        this.textSopCuids.put("EnhancedSR", "1.2.840.10008.5.1.4.1.1.88.22");
        this.textSopCuids.put("KeyObjectSelectionDocument", "1.2.840.10008.5.1.4.1.1.88.59");
        this.textSopCuids.put("MammographyCADSR", "1.2.840.10008.5.1.4.1.1.88.50");
        this.textSopCuids.put("ProcedureLogStorage", "1.2.840.10008.5.1.4.1.1.88.40");
        this.textSopCuids.put("XRayRadiationDoseSR", "1.2.840.10008.5.1.4.1.1.88.67");
    }

    public long getFetchTimeout() {
        return this.fetchTimeout;
    }

    public void setFetchTimeout(long fetchTimeout) {
        this.fetchTimeout = fetchTimeout;
    }

    public String getFetchDestAET() {
        return this.destAET;
    }

    public void setFetchDestAET(String destAET) {
        this.destAET = destAET;
    }

    public boolean isUseSeriesLevelFetch() {
        return this.useSeriesLevelFetch;
    }

    public void setUseSeriesLevelFetch(boolean useSeriesLevelFetch) {
        this.useSeriesLevelFetch = useSeriesLevelFetch;
    }

    public Map uidsString2map(String uids) {
        StringTokenizer st = new StringTokenizer(uids, "\r\n;");
        TreeMap<String, String> map = new TreeMap<String, String>();
        while (st.hasMoreTokens()) {
            String uid;
            String name = uid = st.nextToken().trim();
            if (WADOSupport.isDigit(uid.charAt(0))) {
                if (!UIDs.isValid((String)uid)) {
                    throw new IllegalArgumentException("UID " + uid + " isn't a valid UID!");
                }
            } else {
                uid = UIDs.forName((String)name);
            }
            map.put(name, uid);
        }
        return map;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private ContentManager getContentManager() throws Exception {
        ContentManagerHome home = (ContentManagerHome)EJBHomeFactory.getFactory().lookup(ContentManagerHome.class, "ejb/ContentManager");
        return home.create();
    }

    private StudyPermissionManager getStudyPermissionManager() throws Exception {
        StudyPermissionManagerHome home = (StudyPermissionManagerHome)EJBHomeFactory.getFactory().lookup(StudyPermissionManagerHome.class, "ejb/StudyPermissionManager");
        return home.create();
    }

    public void handleNotification(Notification notification, Object handback) {
        try {
            this.objectReceived((Dataset)notification.getUserData());
        }
        catch (Throwable t) {
            log.error("Can't handle Notification: notification! Ignored", t);
        }
    }

    static {
        dict = null;
        waitIUIDs = Collections.synchronizedMap(new HashMap());
        moveSeriesIUIDs = Collections.synchronizedMap(new HashMap());
        icmColorValues = new byte[]{0, -1};
        bitSwapLut = WADOSupport.makeBitSwapLut();
    }

    class ImageCachingException
    extends IOException {
        private static final long serialVersionUID = 1L;
        private BufferedImage bi;

        public ImageCachingException(BufferedImage bi) {
            this.bi = bi;
        }

        public BufferedImage getImage() {
            return this.bi;
        }
    }

    class NoImageException
    extends Exception {
        private static final long serialVersionUID = 1L;

        NoImageException() {
        }
    }

    class NeedRedirectionException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private AEDTO aedto;

        public NeedRedirectionException(String msg, AEDTO aedto) {
            super(msg);
            this.aedto = aedto;
        }

        public AEDTO getExternalRetrieveAET() {
            return this.aedto;
        }

        public String getWadoUrl() {
            return this.aedto == null ? null : this.aedto.getWadoURL();
        }
    }
}

