/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.wado.mbean;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4chex.wado.mbean.BasicWADOResponseObject;
import org.xml.sax.SAXException;

public class WADOStreamResponseObjectImpl
extends BasicWADOResponseObject {
    private InputStream stream;
    private static final int BUF_LEN = 65536;
    private long maxLen = -1L;

    public WADOStreamResponseObjectImpl(InputStream is, String contentType, int retCode, String errMsg) {
        super(contentType, retCode, errMsg);
        this.stream = is;
    }

    public WADOStreamResponseObjectImpl(InputStream is, long maxLen, String contentType, int retCode, String errMsg) {
        this(is, contentType, retCode, errMsg);
        this.maxLen = maxLen;
    }

    public long length() {
        return this.maxLen;
    }

    public void execute(OutputStream out) throws TransformerConfigurationException, SAXException, IOException {
        if (this.stream != null) {
            InputStream in = this.stream instanceof BufferedInputStream ? this.stream : new BufferedInputStream(this.stream, 65536);
            byte[] buf = new byte[65536];
            long totLen = 0L;
            boolean checkLen = this.maxLen > 0L;
            try {
                int len = in.read(buf);
                while (len > 0) {
                    if (checkLen && (totLen += (long)len) > this.maxLen) {
                        int diff = (int)(totLen - this.maxLen);
                        out.write(buf, 0, len - diff);
                        break;
                    }
                    out.write(buf, 0, len);
                    len = in.read(buf);
                }
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                in.close();
            }
        }
    }
}

