/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.wado.mbean;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.dcm4che.data.Dataset;
import org.dcm4che2.audit.message.ActiveParticipant;
import org.dcm4che2.audit.message.AuditEvent;
import org.dcm4che2.audit.message.AuditMessage;
import org.dcm4che2.audit.message.InstancesTransferredMessage;
import org.dcm4che2.audit.message.ParticipantObject;
import org.dcm4che2.audit.message.ParticipantObjectDescription;
import org.dcm4chex.archive.common.SeriesStored;
import org.dcm4chex.archive.mbean.HttpUserInfo;
import org.dcm4chex.wado.common.WADORequestObject;
import org.dcm4chex.wado.common.WADOResponseObject;
import org.dcm4chex.wado.mbean.AbstractCacheService;
import org.dcm4chex.wado.mbean.WADOSupport;
import org.dcm4chex.wado.mbean.cache.WADOCacheImpl;

public class WADOService
extends AbstractCacheService {
    private static final String NONE = "NONE";
    private WADOSupport support;
    private NotificationListener seriesStoredListener;
    private boolean clearCacheForReceivedSeries;

    public WADOService() {
        this.support = new WADOSupport(this.server);
        this.clearCacheForReceivedSeries = false;
        this.cache = WADOCacheImpl.getWADOCache();
    }

    public boolean isClientRedirect() {
        return this.cache.isClientRedirect();
    }

    public void setClientRedirect(boolean clientRedirect) {
        this.cache.setClientRedirect(clientRedirect);
    }

    public boolean isRedirectCaching() {
        return this.cache.isRedirectCaching();
    }

    public void setRedirectCaching(boolean redirectCaching) {
        this.cache.setRedirectCaching(redirectCaching);
    }

    public String getImageQuality() {
        return this.cache.getImageQuality();
    }

    public void setImageQuality(String imageQuality) {
        this.cache.setImageQuality(imageQuality);
    }

    public String getImageWriterClass() {
        return this.cache.getImageWriterClass();
    }

    public void setImageWriterClass(String imageWriterClass) {
        this.cache.setImageWriterClass(imageWriterClass);
    }

    public boolean isForceRGB() {
        return this.support.isForceRGB();
    }

    public void setForceRGB(boolean forceRGB) {
        this.support.setForceRGB(forceRGB);
    }

    public boolean isUseTransferSyntaxOfFileAsDefault() {
        return this.support.isUseTransferSyntaxOfFileAsDefault();
    }

    public void setUseTransferSyntaxOfFileAsDefault(boolean b) {
        this.support.setUseTransferSyntaxOfFileAsDefault(b);
    }

    public String getSrImageRows() {
        String rows = this.support.getSrImageRows();
        return rows == null ? NONE : this.support.getSrImageRows();
    }

    public void setSrImageRows(String srImageRows) {
        this.support.setSrImageRows(NONE.equals(srImageRows) ? null : srImageRows);
    }

    public String getHtmlXslURL() {
        return this.support.getHtmlXslURL();
    }

    public void setHtmlXslURL(String htmlXslURL) {
        this.support.setHtmlXslURL(htmlXslURL);
    }

    public String getXHtmlXslURL() {
        return this.support.getXHtmlXslURL();
    }

    public void setXHtmlXslURL(String htmlXslURL) {
        this.support.setXHtmlXslURL(htmlXslURL);
    }

    public String getXmlXslURL() {
        return this.support.getXmlXslURL();
    }

    public void setXmlXslURL(String xslURL) {
        this.support.setXmlXslURL(xslURL);
    }

    public String getDicomXslURL() {
        return this.support.getDicomXslURL();
    }

    public void setDicomXslURL(String xslURL) {
        this.support.setDicomXslURL(xslURL);
    }

    public void clearTemplateCache() {
        this.support.clearTemplateCache();
    }

    public String getContentTypeDicomXML() {
        return this.support.getContentTypeDicomXML();
    }

    public void setContentTypeDicomXML(String contentTypeDicomXML) {
        this.support.setContentTypeDicomXML(contentTypeDicomXML);
    }

    public String getImageSopCuids() throws Exception {
        return this.map2string(this.support.getImageSopCuids());
    }

    public String getTextSopCuids() {
        Map uids = this.support.getTextSopCuids();
        return this.map2string(uids);
    }

    public void setTextSopCuids(String sopCuids) {
        this.support.setTextSopCuids(sopCuids);
    }

    public String getVideoSopCuids() {
        Map uids = this.support.getVideoSopCuids();
        return uids.isEmpty() ? NONE : this.map2string(uids);
    }

    public void setVideoSopCuids(String sopCuids) {
        this.support.setVideoSopCuids(sopCuids);
    }

    public String getEncapsulatedSopCuids() {
        Map uids = this.support.getEncapsulatedSopCuids();
        return uids.isEmpty() ? NONE : this.map2string(uids);
    }

    public void setEncapsulatedSopCuids(String sopCuids) {
        this.support.setEncapsulatedSopCuids(sopCuids);
    }

    private String map2string(Map map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuffer sb = new StringBuffer(map.size() << 5);
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next()).append(System.getProperty("line.separator", "\n"));
        }
        return sb.toString();
    }

    public void setEnableClearCacheForReceivedSeries(boolean b) throws InstanceNotFoundException, ListenerNotFoundException {
        if (b != this.clearCacheForReceivedSeries) {
            this.clearCacheForReceivedSeries = b;
            if (this.server != null) {
                this.updateEnableClearCacheForReceivedSeries();
            }
        }
    }

    public boolean isEnableClearCacheForReceivedSeries() {
        return this.clearCacheForReceivedSeries;
    }

    private void updateEnableClearCacheForReceivedSeries() throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.clearCacheForReceivedSeries) {
            this.seriesStoredListener = new NotificationListener(){

                public void handleNotification(Notification notif, Object handback) {
                    SeriesStored seriesStored = (SeriesStored)notif.getUserData();
                    WADOService.this.onSeriesStored(seriesStored);
                }
            };
            this.server.addNotificationListener(this.getStoreScpServiceName(), this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
        } else if (this.seriesStoredListener != null) {
            this.server.removeNotificationListener(this.getStoreScpServiceName(), this.seriesStoredListener, SeriesStored.NOTIF_FILTER, null);
            this.seriesStoredListener = null;
        }
    }

    public ObjectName getStoreScpServiceName() {
        return this.support.getStoreScpServiceName();
    }

    public void setStoreScpServiceName(ObjectName name) {
        this.support.setStoreScpServiceName(name);
    }

    public void setAuditLoggerName(ObjectName name) {
        this.support.setAuditLoggerName(name);
    }

    public ObjectName getAuditLoggerName() {
        return this.support.getAuditLoggerName();
    }

    public ObjectName getQueryRetrieveScpName() {
        return this.support.getQueryRetrieveScpName();
    }

    public void setQueryRetrieveScpName(ObjectName name) {
        this.support.setQueryRetrieveScpName(name);
    }

    public ObjectName getMoveScuServiceName() {
        return this.support.getMoveScuServiceName();
    }

    public void setMoveScuServiceName(ObjectName name) {
        this.support.setMoveScuServiceName(name);
    }

    public String getDisabledAuditLogHosts() {
        Set s = this.support.getDisabledAuditLogHosts();
        if (s == null) {
            return "ALL";
        }
        if (s.isEmpty()) {
            return NONE;
        }
        StringBuffer sb = new StringBuffer(s.size() << 4);
        Iterator it = s.iterator();
        while (it.hasNext()) {
            sb.append(it.next()).append(System.getProperty("line.separator", "\n"));
        }
        return sb.toString();
    }

    public void setDisabledAuditLogHosts(String disabledAuditLogHosts) {
        if ("ALL".equals(disabledAuditLogHosts)) {
            this.support.setDisabledAuditLogHosts(null);
        } else {
            HashSet<Object> disabledHosts = new HashSet<Object>();
            if (!NONE.equals(disabledAuditLogHosts)) {
                StringTokenizer st = new StringTokenizer(disabledAuditLogHosts, "\r\n;");
                while (st.hasMoreTokens()) {
                    disabledHosts.add(st.nextElement());
                }
            }
            this.support.setDisabledAuditLogHosts(disabledHosts);
        }
    }

    public boolean isDisableDNS() {
        return this.support.isDisableDNS();
    }

    public void setDisableDNS(boolean disableDNS) {
        this.support.setDisableDNS(disableDNS);
    }

    public boolean isDisableCache() {
        return this.support.isDisableCache();
    }

    public void setDisableCache(boolean disableCache) {
        this.support.setDisableCache(disableCache);
    }

    public long getFetchTimeout() {
        return this.support.getFetchTimeout();
    }

    public void setFetchTimeout(long t) {
        this.support.setFetchTimeout(t);
    }

    public String getFetchDestAET() {
        return this.support.getFetchDestAET();
    }

    public void setFetchDestAET(String destAET) {
        this.support.setFetchDestAET(destAET);
    }

    public boolean isUseSeriesLevelFetch() {
        return this.support.isUseSeriesLevelFetch();
    }

    public void setUseSeriesLevelFetch(boolean useSeriesLevelFetch) {
        this.support.setUseSeriesLevelFetch(useSeriesLevelFetch);
    }

    public WADOResponseObject getWADOObject(WADORequestObject reqVO) throws Exception {
        long t1 = System.currentTimeMillis();
        WADOResponseObject resp = this.support.getWADOObject(reqVO);
        if (this.support.isAuditLogEnabled(reqVO)) {
            this.logExport(reqVO, resp);
        } else {
            this.log.debug((Object)("Suppress audit log! Disabled for host:" + reqVO.getRemoteHost()));
        }
        long t2 = System.currentTimeMillis();
        this.log.debug((Object)("getWADOObject(): " + (t2 - t1) + "ms"));
        return resp;
    }

    private void logExport(WADORequestObject reqObj, WADOResponseObject resp) {
        try {
            Dataset ds;
            HttpUserInfo userInfo = new HttpUserInfo(reqObj.getRequest(), AuditMessage.isEnableDNSLookups());
            String user = userInfo.getUserId();
            String destHost = userInfo.getHostName();
            InstancesTransferredMessage msg = new InstancesTransferredMessage(InstancesTransferredMessage.EXECUTE);
            msg.setOutcomeIndicator(resp.getReturnCode() == 200 ? AuditEvent.OutcomeIndicator.SUCCESS : AuditEvent.OutcomeIndicator.MINOR_FAILURE);
            msg.addSourceProcess(AuditMessage.getProcessID(), AuditMessage.getLocalAETitles(), AuditMessage.getProcessName(), AuditMessage.getLocalHostName(), false);
            ParticipantObject obj = new ParticipantObject(reqObj.getRequest().getRequestURL().toString(), ParticipantObject.IDTypeCode.URI);
            obj.setParticipantObjectTypeCode(ParticipantObject.TypeCode.SYSTEM);
            obj.setParticipantObjectTypeCodeRole(ParticipantObject.TypeCodeRole.DATA_REPOSITORY);
            msg.addParticipantObject(obj);
            msg.addDestinationProcess(destHost, null, null, destHost, user == null);
            if (user != null) {
                ActiveParticipant ap = ActiveParticipant.createActivePerson((String)user, null, (String)user, null, (boolean)true);
                msg.addActiveParticipant(ap);
            }
            if ((ds = resp.getPatInfo()) != null) {
                msg.addPatient(ds.getString(0x100020), ds.getString(0x100010));
                ParticipantObjectDescription desc = new ParticipantObjectDescription();
                ParticipantObjectDescription.SOPClass sopClass = new ParticipantObjectDescription.SOPClass(ds.getString(524310));
                sopClass.setNumberOfInstances(1);
                desc.addSOPClass(sopClass);
                msg.addStudy(ds.getString(0x20000D), desc);
            } else {
                msg.addPatient("unknown_patid", "unknown_pn");
                msg.addStudy(reqObj.getStudyUID(), null);
            }
            msg.validate();
            Logger.getLogger((String)"auditlog").info((Object)msg);
        }
        catch (Exception e) {
            this.log.warn((Object)"Audit Log failed:", (Throwable)e);
        }
    }

    private void onSeriesStored(SeriesStored seriesStored) {
        Dataset ian = seriesStored.getIAN();
        String studyIUID = ian.getString(0x20000D);
        this.log.info((Object)("SeriesStored! remove cached entries for seriesStored:" + seriesStored));
        this.cache.purgeStudy(studyIUID);
    }

    public boolean isRenderOverlays() {
        return this.support.isRenderOverlays();
    }

    public void setRenderOverlays(boolean b) {
        this.support.setRenderOverlays(b);
    }

    protected void startService() throws InstanceNotFoundException, ListenerNotFoundException {
        this.updateEnableClearCacheForReceivedSeries();
    }
}

