/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.wado.mbean;

import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.TransformerConfigurationException;
import org.dcm4che.data.Dataset;
import org.dcm4che.data.DcmEncodeParam;
import org.dcm4che.net.DataSource;
import org.dcm4chex.wado.mbean.BasicWADOResponseObject;
import org.xml.sax.SAXException;

public class WADODatasourceResponseObjectImpl
extends BasicWADOResponseObject {
    private DataSource datasource;
    private Dataset dataset;
    String transferSyntax = null;

    public WADODatasourceResponseObjectImpl(DataSource ds, String ts, String contentType, int retCode, String errMsg) {
        super(contentType, retCode, errMsg);
        this.datasource = ds;
        this.transferSyntax = ts;
    }

    public WADODatasourceResponseObjectImpl(Dataset ds, String ts, String contentType, int retCode, String errMsg) {
        super(contentType, retCode, errMsg);
        this.dataset = ds;
        this.transferSyntax = ts;
    }

    public void execute(OutputStream out) throws TransformerConfigurationException, SAXException, IOException {
        if (this.datasource != null) {
            this.datasource.writeTo(out, this.transferSyntax);
        } else if (this.dataset != null) {
            this.dataset.writeFile(out, DcmEncodeParam.valueOf((String)this.transferSyntax));
        } else {
            throw new IllegalArgumentException("Cant execute WADO datasource response! Neither a datasource nor dataset object is set!");
        }
    }
}

