/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chex.wado.mbean;

import java.io.IOException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.dcm4chex.archive.config.RetryIntervalls;
import org.dcm4chex.archive.mbean.SchedulerDelegate;
import org.dcm4chex.archive.util.FileUtils;
import org.dcm4chex.wado.mbean.cache.WADOCache;
import org.dcm4chex.wado.mbean.cache.WADOCacheImpl;
import org.jboss.system.ServiceMBeanSupport;

public abstract class AbstractCacheService
extends ServiceMBeanSupport {
    protected final SchedulerDelegate scheduler = new SchedulerDelegate((ServiceMBeanSupport)this);
    protected Logger log = Logger.getLogger((String)((Object)((Object)this)).getClass().getName());
    protected WADOCache cache = null;
    private String timerID;
    private final NotificationListener freeDiskSpaceListener = new NotificationListener(){

        public void handleNotification(Notification notif, Object handback) {
            try {
                AbstractCacheService.this.cache.freeDiskSpace(true);
            }
            catch (IOException e) {
                AbstractCacheService.this.log.error((Object)"Failed to free disk space: ", (Throwable)e);
            }
        }
    };
    private long freeDiskSpaceInterval;
    private Integer freeDiskSpaceListenerID;

    public ObjectName getSchedulerServiceName() {
        return this.scheduler.getSchedulerServiceName();
    }

    public void setSchedulerServiceName(ObjectName schedulerServiceName) {
        this.scheduler.setSchedulerServiceName(schedulerServiceName);
    }

    public WADOCache getCache() {
        return this.cache;
    }

    public String getCacheDataRootDir() {
        return this.cache.getDataRootDir();
    }

    public void setCacheDataRootDir(String cacheDataRootDir) {
        this.cache.setDataRootDir(cacheDataRootDir);
    }

    public String getCacheNumberOfStudyBags() {
        return this.cache.getNumberOfStudyBags();
    }

    public void setCacheNumberOfStudyBags(String s) {
        if (this.getState() == 3) {
            if (s.equals(this.getCacheNumberOfStudyBags())) {
                return;
            }
            this.assertEmptyCache();
        }
        this.cache.setNumberOfStudyBags(s);
    }

    private void assertEmptyCache() {
        if (!this.cache.isEmpty()) {
            throw new IllegalStateException("cache not empty!");
        }
    }

    public String getCacheJournalRootDir() {
        return this.cache.getJournalRootDir();
    }

    public void setCacheJournalRootDir(String cacheJournalRootDir) {
        this.cache.setJournalRootDir(cacheJournalRootDir);
    }

    public String getCacheJournalFilePathFormat() {
        return this.cache.getJournalFilePathFormat();
    }

    public void setCacheJournalFilePathFormat(String journalFilePathFormat) {
        if (this.getState() == 3) {
            if (journalFilePathFormat.equals(this.getCacheJournalFilePathFormat())) {
                return;
            }
            this.assertEmptyCache();
        }
        this.cache.setJournalFilePathFormat(journalFilePathFormat);
    }

    public String getDeleterThresholds() {
        return ((WADOCacheImpl)this.cache).getDeleterThresholds();
    }

    public void setDeleterThresholds(String s) {
        ((WADOCacheImpl)this.cache).setDeleterThresholds(s);
    }

    public String showMinFreeSpace() {
        return FileUtils.formatSize((long)this.cache.getMinFreeSpace());
    }

    public String clearCache() throws IOException {
        long before = this.cache.showFreeSpace();
        this.cache.clearCache();
        return this.getDeleteResult(before);
    }

    private String getDeleteResult(long before) throws IOException {
        long after = this.cache.showFreeSpace();
        long delta = after - before;
        StringBuffer sb = new StringBuffer();
        this.log.info((Object)("getDeleteResult: before:" + before + " , after:" + after + " , delta:" + delta));
        sb.append(FileUtils.formatSize((long)delta)).append(" removed!");
        if (after < this.cache.getMinFreeSpace()) {
            sb.append(" WARNING: INSUFFICIANT Free disk space! Should be ").append(this.showMinFreeSpace());
        }
        return sb.toString();
    }

    public final String getFreeDiskSpaceInterval() {
        return RetryIntervalls.formatIntervalZeroAsNever((long)this.freeDiskSpaceInterval);
    }

    public void setFreeDiskSpaceInterval(String interval) throws Exception {
        this.freeDiskSpaceInterval = RetryIntervalls.parseIntervalOrNever((String)interval);
        if (this.getState() == 3) {
            this.scheduler.stopScheduler(this.timerID, this.freeDiskSpaceListenerID, this.freeDiskSpaceListener);
            this.freeDiskSpaceListenerID = this.scheduler.startScheduler(this.timerID, this.freeDiskSpaceInterval, this.freeDiskSpaceListener);
        }
    }

    public String freeDiskSpace() throws IOException {
        long before = this.cache.showFreeSpace();
        this.cache.freeDiskSpace(false);
        return this.getDeleteResult(before);
    }

    public String showFreeSpace() throws IOException {
        return FileUtils.formatSize((long)this.cache.showFreeSpace());
    }

    protected void startService() throws Exception {
        this.freeDiskSpaceListenerID = this.scheduler.startScheduler(this.timerID, this.freeDiskSpaceInterval, this.freeDiskSpaceListener);
    }

    protected void stopService() throws Exception {
        this.scheduler.stopScheduler(this.timerID, this.freeDiskSpaceListenerID, this.freeDiskSpaceListener);
        super.stopService();
    }

    public String getTimerID() {
        return this.timerID;
    }

    public void setTimerID(String timerID) {
        this.timerID = timerID;
    }
}

