/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.dcm4che2.data.BasicDicomObject;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.TransferSyntax;
import org.dcm4che2.data.VR;
import org.dcm4che2.io.DicomInputStream;
import org.dcm4che2.io.DicomOutputStream;
import org.dcm4chee.archive.exceptions.BlobCorruptedException;

public class DicomObjectUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] encode(DicomObject attrs, String tsuid) {
        ByteArrayOutputStream baos;
        block6: {
            baos = new ByteArrayOutputStream();
            try {
                DicomOutputStream dos = new DicomOutputStream((OutputStream)baos);
                if (tsuid == null) {
                    dos.writeDataset(attrs, TransferSyntax.ExplicitVRLittleEndian);
                    break block6;
                }
                dos.setPreamble(null);
                attrs.putString(131088, VR.UI, tsuid);
                try {
                    dos.writeDicomFile(attrs);
                }
                finally {
                    attrs.remove(131088);
                }
            }
            catch (IOException e) {
                throw new RuntimeException();
            }
        }
        return baos.toByteArray();
    }

    public static DicomObject decode(byte[] b) {
        BasicDicomObject dest = new BasicDicomObject();
        DicomObjectUtils.decode(b, (DicomObject)dest);
        return dest;
    }

    public static void decode(byte[] b, DicomObject dest) {
        try {
            new DicomInputStream((InputStream)new ByteArrayInputStream(b)).readDicomObject(dest, -1);
        }
        catch (IOException e) {
            throw new BlobCorruptedException(e);
        }
        dest.remove(131088);
    }
}

