/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4che2.data.PersonName;
import org.dcm4chee.archive.conf.AttributeFilter;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.Instance;

@Entity
@Table(name="verify_observer")
public class VerifyingObserver
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = 8647650970218017903L;
    @Column(name="verify_datetime")
    private Date verificationDateTime;
    private String verifyingObserverName;
    @Column(name="observer_fn_sx")
    private String verifyingObserverFamilyNameSoundex;
    @Column(name="observer_gn_sx")
    private String verifyingObserverGivenNameSoundex;
    private String verifyingObserverIdeographicName;
    private String verifyingObserverPhoneticName;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="instance_fk")
    private Instance instance;

    public Date getVerificationDateTime() {
        return this.verificationDateTime;
    }

    public String getVerifyingObserverName() {
        return this.verifyingObserverName;
    }

    public String getVerifyingObserverFamilyNameSoundex() {
        return this.verifyingObserverFamilyNameSoundex;
    }

    public void setVerifyingObserverFamilyNameSoundex(String verifyingObserverFamilyNameSoundex) {
        this.verifyingObserverFamilyNameSoundex = verifyingObserverFamilyNameSoundex;
    }

    public String getVerifyingObserverGivenNameSoundex() {
        return this.verifyingObserverGivenNameSoundex;
    }

    public void setVerifyingObserverGivenNameSoundex(String verifyingObserverGivenNameSoundex) {
        this.verifyingObserverGivenNameSoundex = verifyingObserverGivenNameSoundex;
    }

    public String getVerifyingObserverIdeographicName() {
        return this.verifyingObserverIdeographicName;
    }

    public String getVerifyingObserverPhoneticName() {
        return this.verifyingObserverPhoneticName;
    }

    public Instance getInstance() {
        return this.instance;
    }

    public void setInstance(Instance instance) {
        this.instance = instance;
    }

    public String toString() {
        return "VerifyingObserver[pk=" + this.getPk() + ", name=" + this.verifyingObserverName + ", time=" + this.verificationDateTime + "]";
    }

    public void setAttributes(DicomObject attrs) {
        this.verificationDateTime = attrs.getDate(4235312);
        PersonName pn = new PersonName(attrs.getString(4235381));
        this.verifyingObserverName = pn.componentGroupString(0, false).toUpperCase();
        this.verifyingObserverIdeographicName = pn.componentGroupString(1, false);
        this.verifyingObserverPhoneticName = pn.componentGroupString(2, false);
        if (AttributeFilter.isSoundexEnabled()) {
            this.verifyingObserverFamilyNameSoundex = AttributeFilter.toSoundex(pn, 0, "*");
            this.verifyingObserverGivenNameSoundex = AttributeFilter.toSoundex(pn, 1, "*");
        }
    }
}

