/*
 * Decompiled with CFR 0.152.
 */
package org.dcm4chee.archive.entity;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.dcm4che2.data.DicomObject;
import org.dcm4chee.archive.entity.BaseEntity;
import org.dcm4chee.archive.entity.UPS;

@Entity
@Table(name="ups_req")
public class UPSRequest
extends BaseEntity
implements Serializable {
    private static final long serialVersionUID = -570793086711647075L;
    @Column(name="req_proc_id")
    private String requestedProcedureID;
    @Column(name="accession_no")
    private String accessionNumber;
    @Column(name="confidentiality")
    private String confidentiality;
    @Column(name="req_service")
    private String requestingService;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="ups_fk")
    private UPS ups;

    public String getRequestedProcedureID() {
        return this.requestedProcedureID;
    }

    public String getAccessionNumber() {
        return this.accessionNumber;
    }

    public String getConfidentiality() {
        return this.confidentiality;
    }

    public String getRequestingService(String requestingService) {
        return this.requestingService;
    }

    public UPS getUPS() {
        return this.ups;
    }

    public void setUPS(UPS ups) {
        this.ups = ups;
    }

    public String toString() {
        return "UPSRequest[pk=" + this.getPk() + ", rpid=" + this.requestedProcedureID + ", accno=" + this.accessionNumber + "]";
    }

    public void setAttributes(DicomObject attrs) {
        this.requestedProcedureID = attrs.getString(0x401001);
        this.accessionNumber = attrs.getString(524368);
    }
}

